#!/usr/bin/python
""" sqlcmd.py - Mimics Microsoft SQL Server sqlcmd utility """
import sys
import os.path
import pymssql
import getopt
import traceback

def usage() :
    """ Usage Function """
    print 'sqlcmd.py -S<server> -d<database>  -U<user> -P<password> -i<input file> -Q<query> -v<var1-val1 .. varn=valn>'
    print 'sqlcmd.py --server<server> --database<database> --user<user> --password<password> --inputfile<input file> -query<query> -variables<var1-val1 .. varn=valn>'
    return

def getoptions(arguments):
    """ get command line options """
    server=None
    database=None
    user=None
    password=None
    inputfile=None
    sql=None
    variables=None
    mode='script'
    try:
	opts, args = getopt.getopt(arguments, "U:P:S:d:i::Q:v:h", ["user" "password" "server" "database" "inputfile" "query" "variables" "help"])
	# starts at the second element of argv since the first one is the script name
	#opts is a list containing the pair "option"/"value"
	#print 'Opts:',opts
	#parse command line arguments
	for opt, arg in opts:
	    if opt in ("-h", "--help"):
		usage()
		sys.exit()
	    elif opt in ("-U","--user"):
		user=arg
	    elif opt in ("-P","--password"):
		password=arg
	    elif opt in ("-S","--server"):
		server=arg
	    elif opt in ("-d","--database"):
		database=arg
	    elif opt in ("-Q","--query"):
		mode='query'
		sql=arg
	    elif opt in ("-v","--variables"):
		variables=arg
	    elif opt in ("-i","--inputfile"):
		mode='script'
		inputfile=arg
		if not os.path.isfile(inputfile):
		    print 'Can not find input file ' + inputfile
		    sys.exit(2)
	if (user is None and password is None and server is None and database is None):
	    if ((mode=='script' and inputfile is None) or (mode=='query' and sql is None)):
		usage()
		sys.exit(6)
	return user,password,server,database,sql,variables,inputfile,mode

    except getopt.GetoptError:
	usage()
	sys.exit(3)

def getsqlfromfile(inputfile):
    """ read the given sql file to a string variable """
    file = open(inputfile, 'r')
    sql = file.read()
    sql =  replacemultilinecomments(sql)
    if not variables is None:
	sql = replacevars(sql,variables)
    #print 'SQL : ' + sql
    file.close()
    return sql

def replacemultilinecomments(sql):
    """ replacemultilinecomments -  deletes multi-line comments """
    start = sql.find('/*')
    while (start >= 0):
	end = sql.find('*/',start)
	if (start == 0):
	    sql = sql[end+2:]
	else:
	    sql = sql[:start] + sql[end+2:]
	start = sql.find('/*')
    return sql


def replacevars(sql,str):
    """ replacevars - replaces variables with given values , string is in format var1=val1 ... varn=valn """
    settings = str.split()
    for setting in settings:
	var,val = setting.split('=')
	sql = sql.replace(var,val)
    return sql


""" Main Code """


try:

    try:
	user,password,server,database,sql,variables,inputfile,mode = getoptions(sys.argv[1:])
	if (mode=='script'):
	    sql = getsqlfromfile(inputfile)
    except IOError:
	print 'could not open file ' + inputfile
	sys.exit(4)

    # Opening a connection to the database
    conn =  pymssql.connect(host=server, user=user, password=password, database=database , as_dict=True)
    try:
	# Setting auto-commit flag to true
	conn.autocommit(1)
	cur = conn.cursor()
	# execute all commands in the string that we got after reading the file.
	if (mode == 'query'):
	     #print 'query:' + sql
	     cur.execute(sql)
	elif (mode == 'script'):
	    #split to statements according to GO , must do that since in upgrade DDL changes must be
	    #done in a separate transaction and committed before used.
	    statements = sql.lower().replace('n\'','N\'').split('\ngo')
	    for statement in statements:
		if (statement.strip().__len__ > 0):
		    #print 'statement : ' + statement
		    cur.execute(statement)
    finally:
	conn.close
except Exception , e:
    print "Unexpected error:", sys.exc_info()[0], str(e)
    traceback.format_exc()
    sys.exit(5)


