/* ---------------------------------------------------------------------- */
/* Script generated with: DeZign for Databases v4.1.1                     */
/* Target DBMS:           MS SQL Server 2005                              */
/* Project file:          vdc_3.dez                                       */
/* Project name:                                                          */
/* Author:                                                                */
/* Script type:           Database creation script                        */
/* Created on:            2007-02-15 15:03                                */
/* ---------------------------------------------------------------------- */


/* ---------------------------------------------------------------------- */
/* Tables                                                                 */
/* ---------------------------------------------------------------------- */


/* ---------------------------------------------------------------------- */
/* Add table "tags_vm_pool_map"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[tags_vm_pool_map](
	[tag_id] [UNIQUEIDENTIFIER] NOT NULL,
	[vm_pool_id] [UNIQUEIDENTIFIER] NOT NULL,
	[_create_date] datetime default getdate(),
 CONSTRAINT [pk_tags_vm_pool_map] PRIMARY KEY  
(
	[tag_id] ,
	[vm_pool_id] 
)
)
GO
/* ---------------------------------------------------------------------- */
/* Add table "tags_vm_map"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [tags_vm_map](
	[tag_id] UNIQUEIDENTIFIER NOT NULL,
	[vm_id] UNIQUEIDENTIFIER NOT NULL,
	[_create_date] datetime default getdate(),
	[DefaultDisplayType] INT CONSTRAINT [DEF_tags_vm_map_DefaultDisplayType] DEFAULT 0, 
	constraint pk_tags_vm_map primary key ([tag_id],[vm_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "tags_vds_map"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [tags_vds_map](
	[tag_id] UNIQUEIDENTIFIER NOT NULL,
	[vds_id] UNIQUEIDENTIFIER NOT NULL,
	[_create_date] datetime default getdate(),
	constraint pk_tags_vds_map primary key ([tag_id],[vds_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "tags"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [tags](
	[tag_id] UNIQUEIDENTIFIER NOT NULL,
	[tag_name] NVARCHAR(50) default '' NOT NULL,
	[description] NVARCHAR(max),
	[parent_id]  UNIQUEIDENTIFIER,
	[readonly]  bit,
    [type] int NOT NULL DEFAULT ((0)),	
	[tag_id___old] [int] IDENTITY(1,1) NOT NULL,
	[_create_date] datetime default getdate(),
	[_update_date] datetime default NULL,
	constraint pk_tags_id primary key ([tag_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "tags_user_map"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [tags_user_map](
	[tag_id] UNIQUEIDENTIFIER NOT NULL,
	[user_id] UNIQUEIDENTIFIER NOT NULL,
	[_create_date] datetime default getdate(),
	constraint pk_tags_user_map primary key ([tag_id],[user_id])
)
GO
/* ---------------------------------------------------------------------- */
/* Add table "tags_user_group_map"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [tags_user_group_map](
	[tag_id] UNIQUEIDENTIFIER NOT NULL,
	[group_id] UNIQUEIDENTIFIER NOT NULL,
	[_create_date] datetime default getdate(),
	constraint pk_tags_user_group_map primary key ([tag_id],[group_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "custom_actions"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [custom_actions] (
    [action_id] INTEGER IDENTITY(0,1) NOT NULL,
    [action_name] NVARCHAR(50) NOT NULL,
    [path] NVARCHAR(300) NOT NULL,
    [tab] INTEGER,
	[description] NVARCHAR(max),
	CONSTRAINT [PK_custom_actions] PRIMARY KEY ([action_name], [tab])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "image_templates"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [image_templates] (
    [it_guid] UNIQUEIDENTIFIER NOT NULL,
    [creation_date] DATETIME NOT NULL,
    [size] BIGINT NOT NULL,
    [os] NVARCHAR(40),
    [os_version] NVARCHAR(40),
    [bootable] BIT CONSTRAINT [DEF_image_templates_bootable] DEFAULT 0,
    [description] NVARCHAR(max),
    CONSTRAINT [PK_image_templates] PRIMARY KEY ([it_guid])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "images"                                                     */
/* ---------------------------------------------------------------------- */

CREATE TABLE [images] (
    [image_guid] UNIQUEIDENTIFIER NOT NULL,
    [creation_date] DATETIME NOT NULL,
    [size] BIGINT NOT NULL,
    [it_guid] UNIQUEIDENTIFIER NOT NULL,
    [internal_drive_mapping] VARCHAR(50),
    [description] NVARCHAR(max),
    [ParentId] uniqueidentifier,
    [imageStatus] int CONSTRAINT [DEF_images_imageStatus] DEFAULT 0,
    [lastModified] datetime,
	[app_list] NVARCHAR(MAX),
	[storage_id] uniqueidentifier,
	[vm_snapshot_id] uniqueidentifier,
	[volume_type] int NOT NULL CONSTRAINT [DEF_images_volume_type] DEFAULT 2,
	[volume_format] int NOT NULL CONSTRAINT [DEF_images_volume_format] DEFAULT 4,
	[disk_type] int NOT NULL CONSTRAINT [DEF_images_disk_type] DEFAULT 1,
	[image_group_id] uniqueidentifier NULL,
	[disk_interface] int NOT NULL CONSTRAINT [DEF_images_disk_interface] DEFAULT 0,
	[boot] bit NOT NULL CONSTRAINT [DEF_images_boot] DEFAULT 0,
	[wipe_after_delete] bit NOT NULL CONSTRAINT [DEF_images_wipe_after_delete] DEFAULT 0,
	[propagate_errors] int NOT NULL CONSTRAINT [DEF_images_propagate_errors] DEFAULT 0,
	[_create_date] datetime default getdate(),
 	[_update_date] datetime default NULL,
    CONSTRAINT [PK_images] PRIMARY KEY ([image_guid])
)
GO
/* ---------------------------------------------------------------------- */
/* Add table "image_vm_map"                                                     */
/* ---------------------------------------------------------------------- */

CREATE TABLE [image_vm_map]
(
[image_id] UNIQUEIDENTIFIER not null,
[vm_id] UNIQUEIDENTIFIER not null,
[active] bit,
CONSTRAINT [pk_image_vm_map] PRIMARY KEY ([image_id],[vm_id])

 )
GO
/* ---------------------------------------------------------------------- */
/* Add table "vm_templates"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vm_templates] (
    [vmt_guid] UNIQUEIDENTIFIER NOT NULL,
    [name] NVARCHAR(40) NOT NULL,
    [mem_size_mb] INTEGER NOT NULL,
    [os] INTEGER CONSTRAINT [DEF_vm_templates_os] DEFAULT 0 NOT NULL,
    [creation_date] DATETIME NOT NULL,
    [child_count] INTEGER CONSTRAINT [DEF_vm_templates_child_count] DEFAULT 0 NOT NULL,
    [num_of_sockets] INTEGER CONSTRAINT [DEF_vm_templates_num_of_sockets] DEFAULT 1 NOT NULL,
    [cpu_per_socket] INTEGER CONSTRAINT [DEF_vm_templates_cpu_per_socket] DEFAULT 1 NOT NULL,
    [description] NVARCHAR(max),
    [vds_group_id] UNIQUEIDENTIFIER NOT NULL,
	[domain] NVARCHAR(40) NULL,
	[num_of_monitors]	int	NOT NULL,
	[status] int NOT NULL,
	[usb_policy]		int,	
	[time_zone] varchar(40) NULL,
	[is_auto_suspend]	bit	NULL default 0,
    [fail_back] bit CONSTRAINT [DF_vm_templates_fail_back] DEFAULT 0 NOT NULL,
	[vm_type] int CONSTRAINT [DF_vm_templates_vm_type] DEFAULT 0 NOT NULL,
	[hypervisor_type] int CONSTRAINT [DF_vm_templates_hypervisor_type] DEFAULT 0 NOT NULL,
	[operation_mode] int CONSTRAINT [DF_vm_templates_operation_mode] DEFAULT 0 NOT NULL,
    [nice_level] int constraint [DF_vm_templates_nice_level] DEFAULT 0 NOT NULL,
	[default_boot_sequence] int NOT NULL default 0,
    [default_display_type] int NOT NULL default 0,
    [priority] int NOT NULL default 0,
	[auto_startup] bit,
	[is_stateless] bit NULL,
    [iso_path] nvarchar(max) NULL default '',
    [initrd_url] NVARCHAR(max) NULL,
    [kernel_url] NVARCHAR(max) NULL,
    [kernel_params] NVARCHAR(max) NULL,
    [origin] int NULL default 0,
    CONSTRAINT [PK_vm_templates] PRIMARY KEY ([vmt_guid])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "vds_static"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vds_static] (
    [vds_id] uniqueidentifier NOT NULL,
    [vds_name] NVARCHAR(255) NOT NULL,
    [ip] NVARCHAR(255),
    [vds_unique_id] NVARCHAR(128) NULL,
    [host_name] NVARCHAR(255) NOT NULL,
    [port] INTEGER NOT NULL,
    [vds_group_id] uniqueidentifier NOT NULL,
    [server_SSL_enabled] bit,
    vds_type int NOT NULL CONSTRAINT DF_vds_static_vds_type DEFAULT 0,
    [vds_strength] int NOT NULL CONSTRAINT DF_vds_static_vds_strength DEFAULT 100,
    [pm_type] nvarchar(20) NULL,
    [pm_user] nvarchar(50) NULL,
	[pm_password] nvarchar(50) NULL,
    [pm_port] integer null,
    [pm_options] nvarchar(max) not null default '',
    [pm_enabled] bit default 0 not null,
    [_create_date] datetime default getdate(),
    [_update_date] datetime NULL,
	[vds_id___old] [int] IDENTITY(1,1) NOT NULL,
    CONSTRAINT [PK_vds_static] PRIMARY KEY ([vds_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "vm_static"                                                  */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vm_static] (
    [vm_guid] UNIQUEIDENTIFIER NOT NULL,
    [vm_name] NVARCHAR(255) NOT NULL,
    [mem_size_mb] INTEGER NOT NULL,
    [vmt_guid] UNIQUEIDENTIFIER NOT NULL,
    [os] INTEGER CONSTRAINT [DEF_vm_static_os] DEFAULT 0 NOT NULL,
    [description] NVARCHAR(max),
    [vds_group_id] UNIQUEIDENTIFIER NOT NULL,
	[domain] NVARCHAR(40) NULL, 
	[creation_date] datetime NULL,
	[num_of_monitors]	int	NOT NULL,
	[is_initialized]	bit	NULL,
	[is_auto_suspend]	bit	NULL default 0,
    [num_of_sockets] INTEGER DEFAULT 1 NOT NULL,
    [cpu_per_socket] INTEGER DEFAULT 1 NOT NULL,
	[usb_policy]		int,
	[time_zone]	varchar(40) NULL,    
	[is_stateless] bit NULL,
	[fail_back]		bit CONSTRAINT [DF_vm_static_fail_back] DEFAULT 0 NOT NULL,
    [_create_date] datetime default getdate(),
    [_update_date] datetime NULL,
    [dedicated_vm_for_vds] UNIQUEIDENTIFIER,
	[auto_startup] bit,
	[vm_type] int CONSTRAINT [DF_vm_static_vm_type] DEFAULT 0 NOT NULL,
	[hypervisor_type] int CONSTRAINT [DF_vm_static_hypervisor_type] DEFAULT 0 NOT NULL,
	[operation_mode] int CONSTRAINT [DF_vm_static_operation_mode] DEFAULT 0 NOT NULL,
    [nice_level] int constraint [DF_vm_static_nice_level] DEFAULT 0 NOT NULL,
    [default_boot_sequence] int NOT NULL default 0,
    [default_display_type] int NOT NULL default 0,
    [priority] int NOT NULL default 0,
    [iso_path] nvarchar(max) NULL default '',
    [origin] int NULL default 0,
    [initrd_url] NVARCHAR(max) NULL,
    [kernel_url] NVARCHAR(max) NULL,
    [kernel_params] NVARCHAR(max) NULL,
    [migration_support] int NOT NULL default 0,
	[userdefined_properties] VARCHAR(max) NULL,
	[predefined_properties] VARCHAR(max) NULL,
    [min_allocated_mem] int not null default 0, --indicates how much memory at least VM need to run, value is in MB
    CONSTRAINT [PK_vm_static] PRIMARY KEY ([vm_guid])	
)
GO

ALTER TABLE [vm_static] ADD CONSTRAINT [FK_vds_static_vm_static] FOREIGN KEY ([dedicated_vm_for_vds]) REFERENCES [dbo].[vds_static] ([vds_id]) 
GO

-- add non clustered index on vm_name
CREATE NONCLUSTERED INDEX [IDX_vm_static_vm_name] ON [dbo].[vm_static] 
(
	[vm_name] ASC
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]

GO


/* ---------------------------------------------------------------------- */
/* Add table "users"                                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [users] (
    [user_id] UNIQUEIDENTIFIER NOT NULL,
    [name] NVARCHAR(255),
    [surname] NVARCHAR(255),
    [domain] NVARCHAR(255) NOT NULL,
    [username] NVARCHAR(255) NOT NULL,
    [groups] NVARCHAR(max) NOT NULL,
    [department] NVARCHAR(255),
    [role] NVARCHAR(255),
    [user_icon_path] NVARCHAR(255),
    [desktop_device] NVARCHAR(255),
    [email] NVARCHAR(255),
    [note] NVARCHAR(255),
    [status] INTEGER NOT NULL,
    [session_count] INTEGER default 0 NOT NULL,
	[last_admin_check_status] Bit default 0 NOT NULL,
    CONSTRAINT [PK_users] PRIMARY KEY ([user_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "vds_groups"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vds_groups] (
    [vds_group_id] UNIQUEIDENTIFIER NOT NULL,
    [name] NVARCHAR(40) NOT NULL,
    [description] NVARCHAR(max),
    [cpu_name] NVARCHAR(255),
    [_create_date] datetime default getdate(),
    [_update_date] datetime NULL,
    [selection_algorithm] int NOT NULL CONSTRAINT DF_vds_groups_selection_algorithm DEFAULT 0,
    [high_utilization] int NOT NULL CONSTRAINT DF_vds_groups_high_utilization DEFAULT 75,
    [low_utilization] int NOT NULL CONSTRAINT DF_vds_groups_low_utilization DEFAULT 0,
    [cpu_over_commit_duration_minutes] int NOT NULL CONSTRAINT DF_vds_groups_cpu_over_commit_duration_minutes DEFAULT 2,
    [hypervisor_type] int NOT NULL CONSTRAINT DF_vds_groups_hypervisor_type DEFAULT 0,
    [storage_pool_id] uniqueidentifier NULL,
	[max_vds_memory_over_commit] int NOT NULL CONSTRAINT DF_vds_groups_mem_over_commit DEFAULT 100,
	[compatibility_version] NVARCHAR(40) NOT NULL CONSTRAINT DF_vds_groups_compatibility_version DEFAULT '2.2',
	[transparent_hugepages] bit NOT NULL DEFAULT '0',
	[migrate_on_error] int NOT NULL DEFAULT '1',
	[vds_group_id___old] [int] IDENTITY(1,1) NOT NULL,
    CONSTRAINT [PK_vds_groups] PRIMARY KEY ([vds_group_id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "vm_template_image_map"                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vm_template_image_map] (
    [it_guid] UNIQUEIDENTIFIER NOT NULL,
    [vmt_guid] UNIQUEIDENTIFIER NOT NULL,
    [internal_drive_mapping] VARCHAR(50) NOT NULL,
    CONSTRAINT [PK_vm_template_image_map] PRIMARY KEY ([it_guid], [vmt_guid])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "audit_log"                                                  */
/* ---------------------------------------------------------------------- */

CREATE TABLE [audit_log] (
    [audit_log_id] bigint IDENTITY(0,1) NOT NULL,
    [user_id] UNIQUEIDENTIFIER,
    [user_name] NVARCHAR(255),
    [vm_id] UNIQUEIDENTIFIER,
    [vm_name] NVARCHAR(255),
	[vm_template_id] UNIQUEIDENTIFIER,
    [vm_template_name] NVARCHAR(40),
    [vds_id] UNIQUEIDENTIFIER,
    [vds_name] NVARCHAR(255),
    [log_time] DATETIME NOT NULL,
    [log_type_name] nvarchar(100) default '' NULL,
    [log_type] INTEGER NOT NULL,
    [severity] INTEGER NOT NULL,
    [message] NVARCHAR(max) NOT NULL, 
	[processed] bit default 0 NOT NULL,
    [storage_pool_id] UNIQUEIDENTIFIER,
    [storage_pool_name] NVARCHAR(40),
    [storage_domain_id] UNIQUEIDENTIFIER,
    [storage_domain_name] NVARCHAR(250),
    [vds_group_id] UNIQUEIDENTIFIER,
    [vds_group_name] NVARCHAR(255),
    CONSTRAINT [PK_audit_log] PRIMARY KEY ([audit_log_id] DESC) 
)
GO

-- add non clustered index on log_time (desc)
CREATE NONCLUSTERED INDEX [IDX_audit_log_log_time] ON [dbo].[audit_log] 
(
	[log_time] DESC
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

-- add non clustered index on user_name 
CREATE NONCLUSTERED INDEX [IDX_audit_log_user_name] ON [dbo].[audit_log] 
(
	[user_name] 
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

-- add non clustered index on vm_name (
CREATE NONCLUSTERED INDEX [IDX_audit_log_vm_name] ON [dbo].[audit_log] 
(
	[vm_name] 
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

-- add non clustered index on vm_template_name 
CREATE NONCLUSTERED INDEX [IDX_audit_log_vm_template_name] ON [dbo].[audit_log] 
(
	[vm_template_name] 
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

-- add non clustered index on vds_name
CREATE NONCLUSTERED INDEX [IDX_audit_log_vds_name] ON [dbo].[audit_log] 
(
	[vds_name] 
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

-- add non clustered index on storage_pool_name 
CREATE NONCLUSTERED INDEX [IDX_audit_log_storage_pool_name] ON [dbo].[audit_log] 
(
	[storage_pool_name] 
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

-- add non clustered index on storage_domain_name 
CREATE NONCLUSTERED INDEX [IDX_audit_log_storage_domain_name] ON [dbo].[audit_log] 
(
	[storage_domain_name] 
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/* Add table "vds_dynamic"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [dbo].[vds_dynamic](
	[vds_id] [UNIQUEIDENTIFIER] NOT NULL,
	[status] [int] NOT NULL,
	[cpu_cores] [int] NULL,
	[cpu_model] [nvarchar](255)  NULL,
	[cpu_speed_mh] [decimal](18, 0) NULL,
	[if_total_speed] [nvarchar](40)  NULL,
	[kvm_enabled] [bit] NULL,
	[physical_mem_mb] [int] NULL,
	[mem_commited] [int] NULL CONSTRAINT [DEF_vds_dynamic_mem_commited]  DEFAULT ((0)),
	[vm_active] [int] NULL CONSTRAINT [DEF_vds_dynamic_vm_active]  DEFAULT ((0)),
	[vm_count] [int] NOT NULL CONSTRAINT [DEF_vds_dynamic_vm_count]  DEFAULT ((0)),
	[vm_migrating] [int] NULL CONSTRAINT [DEF_vds_dynamic_vm_migrating]  DEFAULT ((0)),
	[reserved_mem] [int] NULL,
	[guest_overhead] [int] NULL,
	[software_version] [varchar](40)  NULL,
	[version_name] [varchar](40)  NULL,
	[build_name] [varchar](40)  NULL,
	[previous_status] [int] NULL,
	[cpu_flags] [NVARCHAR](max) NULL,
	[cpu_over_commit_time_stamp] [datetime] NULL,
	[hypervisor_type] [int] NULL,
	[vms_cores_count] [int] NULL,
	[pending_vcpus_count] [int] NULL,
    [cpu_sockets] [int] NULL,
	[net_config_dirty] [bit] NULL,
	[supported_cluster_levels] NVARCHAR(40) NULL,
	[supported_rhevms] NVARCHAR(40) NULL,
	[host_os] [nvarchar](max)  NULL,
	[kvm_version] [nvarchar](max)  NULL,
	[spice_version] [nvarchar](max)  NULL,
	[kernel_version] [nvarchar](max)  NULL,
	[iscsi_initiator_name] [varchar](max)  NULL,
	[transparent_hugepages_state] INT NOT NULL DEFAULT '0',
	[anonymous_hugepages] INT NOT NULL DEFAULT '0',
        [hooks] nvarchar(max) default '',
	[_update_date] [datetime] NULL,
	[non_operational_reason] INT NOT NULL DEFAULT '0',
    [pending_vmem_size] [int] NOT NULL DEFAULT 0,

 CONSTRAINT [PK_vds_dynamic] PRIMARY KEY CLUSTERED 
(
	[vds_id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/* Add table "vm_dynamic"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vm_dynamic] (
    [vm_guid] UNIQUEIDENTIFIER NOT NULL,
    [status] INTEGER NOT NULL,
    [vm_ip] NVARCHAR(255),
    [vm_host] VARCHAR(255),
    [vm_pid] INTEGER,
    [vm_last_up_time] DATETIME,
    [vm_last_boot_time] DATETIME,
    [guest_cur_user_name] NVARCHAR(255),
    [guest_cur_user_id] UNIQUEIDENTIFIER,
    [guest_last_login_time] DATETIME,
    [guest_last_logout_time] DATETIME,
    [guest_os] NVARCHAR(255),
    [run_on_vds] UNIQUEIDENTIFIER,
    [migrating_to_vds] UNIQUEIDENTIFIER,
    [app_list] NVARCHAR(max),
    [display] INTEGER,
    [acpi_enable] [bit] NULL,
	[session] [int] NULL,
	[display_ip] [varchar](255)  NULL,
	[display_type] [int] NULL,
	[kvm_enable] [bit] NULL,
	[display_secure_port] [int] NULL,
	[utc_diff] INTEGER NULL,
    [last_vds_run_on] UNIQUEIDENTIFIER,
    [client_ip] varchar(255),
    [guest_requested_memory] int,
    [hibernation_vol_handle] varchar(255),
	[boot_sequence] [int] NULL,
	[exit_status] [int] NOT NULL CONSTRAINT [DF_vm_dynamic_exit_status]  DEFAULT ((0)),
	[pause_status] [int] NOT NULL CONSTRAINT [DF_vm_dynamic_pause_status]  DEFAULT ((0)),
	[exit_message] [nvarchar](max) NULL,
    CONSTRAINT [PK_vm_dynamic] PRIMARY KEY ([vm_guid])
)
GO

-- add non clustered index on run_on_vds
CREATE NONCLUSTERED INDEX [IDX_vm_dynamic_run_on_vds] ON [dbo].[vm_dynamic] 
(
	[run_on_vds] ASC
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]

GO

/* ---------------------------------------------------------------------- */
/*	bookmarks						                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [bookmarks](
[bookmark_Id] uniqueidentifier NOT NULL,
[bookmark_name]  NVARCHAR(40),
 [bookmark_value] NVARCHAR(300) NOT NULL,
[bookmark_Id___old] [int] IDENTITY(1,1) NOT NULL,
CONSTRAINT [PK_bookmarks] PRIMARY KEY ([bookmark_Id]))
GO

/* ---------------------------------------------------------------------- */
/*	vm_pools						                                      */
/* ---------------------------------------------------------------------- */
CREATE TABLE [vm_pools](
[vm_pool_id] uniqueidentifier NOT NULL, 
vm_pool_name NVARCHAR(255) NOT NULL,
 vm_pool_description NVARCHAR(max) NOT NULL,
[vm_pool_type] int,
[parameters]  NVARCHAR(200),
[vds_group_id] uniqueidentifier,
[vm_pool_id___old] [int] IDENTITY(1,1) NOT NULL,
CONSTRAINT [PK_vm_pools] PRIMARY KEY ([vm_pool_id]))
GO


/* ---------------------------------------------------------------------- */
/*	vm_pool_map						                                      */
/* ---------------------------------------------------------------------- */
CREATE TABLE [vm_pool_map] (
vm_pool_id uniqueidentifier, 
vm_guid UNIQUEIDENTIFIER, 
CONSTRAINT [PK_vm_pool_map] PRIMARY KEY (vm_guid))
GO
/* ---------------------------------------------------------------------- */
/*	images_vm_pool_map    			                                      */
/* ---------------------------------------------------------------------- */
CREATE TABLE [image_vm_pool_map] (
	[vm_guid] UNIQUEIDENTIFIER not null,
	[image_guid] UNIQUEIDENTIFIER not NULL,
	[internal_drive_mapping] VARCHAR(50),
	CONSTRAINT [PK_image_vm_pool_map] PRIMARY KEY (image_guid))
GO

CREATE TABLE [time_lease_vm_pool_map]
(
[vm_pool_id] UNIQUEIDENTIFIER NOT NULL,
[id] UNIQUEIDENTIFIER not null,
[start_time] datetime NOT NULL,
[end_time] datetime NOT NULL,
[type] int NOT NULL,
CONSTRAINT [pk_time_user_vm_pool_map] PRIMARY KEY ([vm_pool_id],[id])
)
GO
/* ---------------------------------------------------------------------- */
/*         ad_groups                                                      */
/* ---------------------------------------------------------------------- */ 
CREATE TABLE  [ad_groups](
 [id] UNIQUEIDENTIFIER not null,
 [name] NVARCHAR(256) not NULL,
 [status] INTEGER NOT NULL,
 [domain] NVARCHAR(100),
 [distinguishedname] NVARCHAR(MAX) default NULL,
 constraint pk_ad_group_id primary key ([id]))
GO

/* ---------------------------------------------------------------------- */
/*           options table								*/
/* ---------------------------------------------------------------------- */
CREATE TABLE [vdc_options] (
	[option_id] INTEGER IDENTITY(0,1) NOT NULL,
    [option_name] NVARCHAR(100)  NOT NULL,
    [option_value] NVARCHAR(max) NOT NULL,
    [version] NVARCHAR(40) NOT NULL CONSTRAINT DF_vdc_options_version DEFAULT 'general',
	CONSTRAINT [PK_vdc_options] PRIMARY KEY CLUSTERED 
	(
	[option_id]
	) WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX IX_vdc_options ON dbo.vdc_options
	(
	option_name
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/*           vds_statistics table								*/
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vds_statistics](
	[vds_id] [uniqueidentifier] NOT NULL,
	[cpu_idle] [decimal](18, 0) NULL CONSTRAINT [DEF_vds_statistics_cpu_idle]  DEFAULT ((0)),
	[cpu_load] [decimal](18, 0) NULL CONSTRAINT [DEF_vds_statistics_cpu_load]  DEFAULT ((0)),
	[cpu_sys] [decimal](18, 0) NULL CONSTRAINT [DEF_vds_statistics_cpu_sys]  DEFAULT ((0)),
	[cpu_user] [decimal](18, 0) NULL CONSTRAINT [DEF_vds_statistics_cpu_user]  DEFAULT ((0)),
	[usage_mem_percent] [int] NULL CONSTRAINT [DEF_vds_statistics_usage_mem_percent]  DEFAULT ((0)),
	[usage_cpu_percent] [int] NULL CONSTRAINT [DEF_vds_statistics_usage_cpu_percent]  DEFAULT ((0)),
	[usage_network_percent] [int] NULL,
	[mem_available] [BIGINT] NULL,
	[mem_shared] [BIGINT] NULL,
    [swap_free] [BIGINT] NULL,
    [swap_total] [BIGINT] NULL,
	[ksm_cpu_percent] [int] NULL CONSTRAINT [DEF_vds_statistics_ksm_cpu_percent]  DEFAULT ((0)),
	[ksm_pages] [BIGINT] NULL,
    [ksm_state] bit NULL ,

 CONSTRAINT [PK_vds_statistics] PRIMARY KEY CLUSTERED 
(
	[vds_id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/*           vm_statistics table								*/
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vm_statistics](
	[vm_guid] [uniqueidentifier] NOT NULL,
	[cpu_user] [decimal](18, 0) NULL CONSTRAINT [DEF_vm_statistics_cpu_user]  DEFAULT ((0)),
	[cpu_sys] [decimal](18, 0) NULL CONSTRAINT [DEF_vm_statistics_cpu_sys]  DEFAULT ((0)),
	[elapsed_time] [decimal](18, 0) NULL CONSTRAINT [DEF_vm_statistics_elapsed_time]  DEFAULT ((0)),
	[usage_network_percent] [int] NULL CONSTRAINT [DEF_vm_statistics_usage_network_percent]  DEFAULT ((0)),
	[usage_mem_percent] [int] NULL CONSTRAINT [DEF_vm_statistics_usage_mem_percent]  DEFAULT ((0)),
	[usage_cpu_percent] [int] NULL CONSTRAINT [DEF_vm_statistics_usage_cpu_percent]  DEFAULT ((0)),
 CONSTRAINT [PK_vm_statistics] PRIMARY KEY CLUSTERED 
(
	[vm_guid] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

/* ---------------------------------------------------------------------- */
/*           stateless_vm_image_map table								  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [stateless_vm_image_map] (
	[vm_guid] UNIQUEIDENTIFIER not null,
	[image_guid] UNIQUEIDENTIFIER not NULL,
	[internal_drive_mapping] VARCHAR(50),
	CONSTRAINT [PK_stateless_vm_image_map] PRIMARY KEY (image_guid),
	CONSTRAINT [FK_stateless_vm_static] 
	FOREIGN KEY ([vm_guid]) REFERENCES [vm_static] ([vm_guid]) ON DELETE CASCADE)
GO

/* ---------------------------------------------------------------------- */
/*           user_sessions table								*/
/* ---------------------------------------------------------------------- */


CREATE TABLE [dbo].[user_sessions](
	[session_id] [nchar](32) NOT NULL,
	[user_id] [uniqueidentifier] NOT NULL,
	[os] [nchar](10)  NULL,
	[browser] [nchar](10)  NULL,
	[client_type] [nchar](10)  NULL,
	[login_time] [datetime] default getdate() NULL,
	constraint pk_user_sessions primary key ([user_id],[session_id])
) 
GO


/* ---------------------------------------------------------------------- */
/*           vdc_db_log table								              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [vdc_db_log]
(
	[error_id] Bigint identity(1,1) NOT NULL,
	[occured_at] datetime default getdate() NOT NULL,
	[error_code] int NOT NULL,
	[error_message] Nvarchar(2048) NULL,
	[error_proc] Nvarchar(126) NULL,
	[error_line] int NULL,
constraint pk_vdc_db_log primary key ([error_id])
) 

GO

/* ---------------------------------------------------------------------- */
/*           multi level administration tables							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [permissions]
(
	[id] uniqueidentifier NOT NULL,
	[role_id] uniqueidentifier NOT NULL,
	[ad_element_id] uniqueidentifier   NOT NULL ,
	[object_id] uniqueidentifier NOT NULL,
	[object_type_id] int NOT NULL,
constraint pk_permissions_id primary key ([id])
) 

GO

CREATE TABLE [roles]
(
	[id] uniqueidentifier not null,
	[name] Nvarchar(126)  NOT NULL,
	[description] Nvarchar(MAX),
	[is_readonly] bit not null,
	[role_type] int not null,
constraint pk_roles_id primary key ([id])
)
GO

CREATE TABLE [roles_groups]
(
[role_id] uniqueidentifier not null,
[action_group_id] int not null,
constraint pk_roles_groups primary key ([role_id],[action_group_id])
)
GO
ALTER TABLE [roles_groups] ADD CONSTRAINT [fk_roles_groups_action_id] FOREIGN KEY ([role_id]) REFERENCES [roles] (id) ON DELETE CASCADE
GO

CREATE TABLE [roles_relations]
(
[role_id] uniqueidentifier not null,
[role_container_id] uniqueidentifier not null,
constraint [pk_roles_relations] primary key ([role_id],[role_container_id])
)
GO

ALTER TABLE [roles_relations] ADD CONSTRAINT [fk_roles_relations_role_id] FOREIGN KEY ([role_id]) REFERENCES [roles] (id)
GO
ALTER TABLE [roles_relations] ADD CONSTRAINT [fk_roles_relations_container_id] FOREIGN KEY ([role_container_id]) REFERENCES [roles] (id)
GO

---StoragePool handling	
CREATE TABLE [storage_pool]
(
	[id] [uniqueidentifier] not null,
	[name] [nvarchar](40) NOT NULL,
	[description] [nvarchar](max) NOT NULL,
	[storage_pool_type] [int] NOT NULL,
	[storage_pool_format_type] [int] default NULL,
	[status] [int] NOT NULL,
	[master_domain_version] [int] NOT NULL,
	[spm_vds_id] [uniqueidentifier] NULL,
	[compatibility_version] NVARCHAR(40) NOT NULL CONSTRAINT DF_storage_pool_compatibility_version DEFAULT '2.2',
	[_create_date] datetime default getdate(),
 	[_update_date] datetime default NULL,
	constraint [pk_storage_pool] primary key ([id])
)
GO
CREATE TABLE [storage_domain_static]
(
	[id] [uniqueidentifier] not null,
	[storage] [nvarchar](250) NOT NULL,
	[storage_name] [nvarchar](250) NOT NULL,
	[storage_domain_type] [int] NOT NULL,
	[storage_type] [int] NOT NULL,
	[storage_domain_format_type] [int] NOT NULL default 0,
	[_create_date] datetime default getdate(),
 	[_update_date] datetime default NULL,
	constraint [pk_storage] primary key ([id])
)
GO
CREATE TABLE [dbo].[storage_domain_dynamic](
	[id] [uniqueidentifier] NOT NULL,
	[available_disk_size] [int] NULL,
	[used_disk_size] [int] NULL,
CONSTRAINT [PK_storage_domain_dynamic] PRIMARY KEY
(
	[id] 
)
) 
GO
ALTER TABLE [dbo].[storage_domain_dynamic]  ADD  CONSTRAINT [FK_storage_domain_dynamic_storage_domain_static] FOREIGN KEY([id])
REFERENCES [dbo].[storage_domain_static] ([id])

GO
CREATE TABLE [dbo].[storage_server_connections](
	[id] [nvarchar](50)  NOT NULL,
	-- use collate in order to support case sensitive queries
	[connection] [nvarchar](250) COLLATE SQL_Latin1_General_CP1_CS_AS NOT NULL,
	[user_name] [nvarchar](50)  NULL,
	[password] [nvarchar](50)  NULL,
	[iqn] [nvarchar](128)  NULL,
	[port] [nvarchar](50)  NULL,
	[portal] [nvarchar](50)  NULL,
	[storage_type] [int] NOT NULL,
 CONSTRAINT [PK_storage_server] PRIMARY KEY
(
	[id] 
)
) 
GO
CREATE TABLE [dbo].[storage_pool_iso_map](
	[storage_id] [uniqueidentifier] NOT NULL,
	[storage_pool_id] [uniqueidentifier] NOT NULL,
	[status] [int] NULL,
	[owner] [int] NULL,
 CONSTRAINT [PK_storage_domain_pool_map] PRIMARY KEY  
(
	[storage_id] ASC,
	[storage_pool_id] ASC
)
)

GO
ALTER TABLE [dbo].[storage_pool_iso_map]  ADD  CONSTRAINT [FK_storage_domain_pool_map_storage_pool] FOREIGN KEY([storage_pool_id])
REFERENCES [dbo].[storage_pool] ([id]) ON DELETE CASCADE
GO
ALTER TABLE [dbo].[storage_pool_iso_map]  ADD  CONSTRAINT [FK_storage_domain_pool_map_storage_domain_static] FOREIGN KEY([storage_id])
REFERENCES [dbo].[storage_domain_static] ([id]) ON DELETE CASCADE
GO
CREATE TABLE [dbo].[LUNs](
	[phisical_volume_id] [nvarchar](50) NULL,
	[LUN_id] [nvarchar](50) NOT NULL,
	[volume_group_id] [nvarchar](50) NULL,
	[serial] [nvarchar](max) NULL,
	[lun_mapping] int NULL,
	[vendor_id] [nvarchar](50) NULL,
	[product_id] [nvarchar](50) NULL,
CONSTRAINT [PK_LUNs] PRIMARY KEY 
(
	[LUN_id] ASC
)
) 

GO
CREATE TABLE [dbo].[LUN_storage_server_connection_map](
	[LUN_id] [nvarchar](50) NOT NULL,
	[storage_server_connection] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LUN_storage_server_connection_map] PRIMARY KEY 
(
	[LUN_id] ASC,
	[storage_server_connection] ASC
)
) 

GO
ALTER TABLE [dbo].[LUN_storage_server_connection_map]  ADD  CONSTRAINT [FK_LUN_storage_server_connection_map_LUNs] FOREIGN KEY([LUN_id])
REFERENCES [dbo].[LUNs] ([LUN_id]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[LUN_storage_server_connection_map]   ADD  CONSTRAINT [FK_LUN_storage_server_connection_map_storage_server_connections] FOREIGN KEY([storage_server_connection])
REFERENCES [dbo].[storage_server_connections] ([id]) ON DELETE CASCADE
GO

CREATE TABLE [dbo].[async_tasks](
	[task_id] [uniqueidentifier] NOT NULL,
	[action_type] [int] NOT NULL,
	[status] [int] NOT NULL,
	[result] [int] NOT NULL,
	[action_parameters] [image] NULL,
 CONSTRAINT [PK_async_tasks] PRIMARY KEY  
(
	[task_id] 
))
GO
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
                             -- NETWORS --
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/*           vm_interface table             							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vm_interface](
	[id] [uniqueidentifier] NOT NULL,
	[network_name] [nvarchar](50)  NULL,
	[vm_guid] [uniqueidentifier] NULL,
	[vmt_guid] [uniqueidentifier] NULL,
	[mac_addr] [nvarchar](20)  NULL,
	[name] [nvarchar](50)  NOT NULL,
	[speed] [int] NULL,
	[type] [int] NULL CONSTRAINT [DF_vm_interface_type]  DEFAULT ((0)),
	[_create_date] datetime default getdate(),
	[_update_date] datetime default NULL,
    CONSTRAINT [PK_vm_interface] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

-- add non clustered index on [vm_guid],[vmt_guid]
CREATE NONCLUSTERED INDEX [IDX_vm_interface_vm_vmt_guid] ON [dbo].[vm_interface] 
(
	[vm_guid],[vmt_guid]
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO


/* ---------------------------------------------------------------------- */
/*           vm_interface_statistics table        							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vm_interface_statistics](
	[id] [uniqueidentifier] NOT NULL,
	[vm_id] [uniqueidentifier] NULL,
	[rx_rate] [decimal](18, 0) NULL,
	[tx_rate] [decimal](18, 0) NULL,
	[rx_drop] [decimal](18, 0) NULL,
	[tx_drop] [decimal](18, 0) NULL,
	[iface_status] int,
 CONSTRAINT [PK_vm_interface_statistics] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [vm_interface_statistics] ADD CONSTRAINT [fk_vm_interface_statistics_vm_static] 
	FOREIGN KEY ([vm_id]) REFERENCES [vm_static] (vm_guid) ON DELETE CASCADE
GO


/* ---------------------------------------------------------------------- */
/*           vds_interface_statistics table        							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vds_interface_statistics](
	[id] [uniqueidentifier] NOT NULL,	
	[vds_id] [uniqueidentifier] NULL,
	[rx_rate] [decimal](18, 0) NULL,
	[tx_rate] [decimal](18, 0) NULL,
	[rx_drop] [decimal](18, 0) NULL,
	[tx_drop] [decimal](18, 0) NULL,
	[iface_status] int,
 CONSTRAINT [PK_vds_interface_statistics] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [vds_interface_statistics] ADD CONSTRAINT [fk_vds_interface_statistics_vds_static] 
	FOREIGN KEY ([vds_id]) REFERENCES [vds_static] (vds_id) ON DELETE CASCADE


/* ---------------------------------------------------------------------- */
/*           vds_interface table             							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vds_interface](
	[id] [uniqueidentifier] NOT NULL,
	[name] [nvarchar](50)  NOT NULL,
	[network_name] [nvarchar](50)  NULL,
	[vds_id] [uniqueidentifier] NULL,
	[mac_addr] [nvarchar](20)  NULL,
	[is_bond] [bit] NULL CONSTRAINT [DF_vds_interface_is_bond]  DEFAULT ((0)),
	[bond_name] [nvarchar](50)  NULL,
	[bond_type] [int] NULL,
	[bond_opts] [nvarchar](max) NULL,
	[vlan_id] [int] NULL,
	[speed] [int] NULL,
	[addr] [nvarchar](20)  NULL,
	[subnet] [nvarchar](20)  NULL,
	[gateway] [nvarchar](20)  NULL,
	[boot_protocol] [int]  NULL,
    [type] [int] NULL CONSTRAINT [DF_vds_interface_type]  DEFAULT ((0)),	
	[_create_date] datetime default getdate(),
	[_update_date] datetime default NULL,
 CONSTRAINT [PK_vds_interface] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

-- add non clustered index on [vds_id]
CREATE NONCLUSTERED INDEX [IDX_vds_interface_vds_id] ON [dbo].[vds_interface] 
(
	[vds_id] ASC
)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]

GO


/* ---------------------------------------------------------------------- */
/*           network table                  							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[network](
	[id] [uniqueidentifier] NOT NULL,
	[name] [nvarchar](50)  NOT NULL,
	[description] [nvarchar](max)  NULL,
	[type] [int] NULL,
	[addr] [nvarchar](50)  NULL,
	[subnet] [nvarchar](20)  NULL,
	[gateway] [nvarchar](20)  NULL,
	[vlan_id] [int] NULL,
    [stp] [bit] NOT NULL CONSTRAINT [DF_network_stp]  DEFAULT ((0)),
    [storage_pool_id] [uniqueidentifier] NULL,
 CONSTRAINT [PK_network] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/*           network_cluster table             							  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[network_cluster](
	[network_id] [uniqueidentifier] NOT NULL,
	[cluster_id] [uniqueidentifier] NOT NULL,
    [status] [int] NOT NULL CONSTRAINT [DF_network_cluster_status]  DEFAULT ((0)),
    [is_display] [bit] NOT NULL CONSTRAINT [DF_network_cluster_is_display]  DEFAULT ((0)),    
 CONSTRAINT [PK_network_cluster] PRIMARY KEY CLUSTERED 
(
	[network_id] ASC,
	[cluster_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

/* -----------------------------------------------------------------------*/
/* Event Notification                                                       */
/* -----------------------------------------------------------------------*/

CREATE TABLE [dbo].[event_map](
    [event_up_name] [nvarchar](100) NOT NULL,
	[event_down_name] [nvarchar](100) NOT NULL,
 CONSTRAINT [PK_EVENT_MAP] PRIMARY KEY CLUSTERED 
(
	[event_up_name] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[event_notification_methods](
	[method_id] [int] NOT NULL,
	[method_type] [nchar](10)  NOT NULL,
 CONSTRAINT [PK_EVENT_NOTIFICATION_METHODS] PRIMARY KEY CLUSTERED 
(
	[method_id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO


CREATE TABLE [dbo].[event_subscriber](
	[subscriber_id] [uniqueidentifier] NOT NULL,
	[event_up_name] [nvarchar](100) NOT NULL,
	[method_id] [int] NOT NULL,
	[method_address] nvarchar(255) NULL,
    [tag_name] [nvarchar](50) default '' NOT NULL,
 CONSTRAINT [PK_EVENT_SUBSCRIBER] PRIMARY KEY CLUSTERED 
(
	[subscriber_id],[event_up_name],[method_id],[tag_name]
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[event_notification_hist](
	[subscriber_id] [uniqueidentifier] NOT NULL,
	[event_name] [nvarchar](100) NOT NULL,
	[audit_log_id] [bigint] NOT NULL,
	[method_type] [nchar](10) NOT NULL,
	[sent_at] [datetime] NOT NULL,
	[status] [bit] NOT NULL,
	[reason] [nchar](255)  NULL    
) ON [PRIMARY]

GO
/* ---------------------------------------------------------------------- */
/* vds_spm_id_map table	                                                  */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[vds_spm_id_map](
	[storage_pool_id] [uniqueidentifier] NOT NULL,
	[vds_spm_id] [int] NOT NULL,
	[vds_id] [UNIQUEIDENTIFIER] NOT NULL,
 CONSTRAINT [PK_vds_spm_id_map] PRIMARY KEY CLUSTERED 
(
	[storage_pool_id] ASC,
	[vds_spm_id] ASC
))
GO

/* ---------------------------------------------------------------------- */
/* Add table "disk_image_dynamic"                                            */
/* ---------------------------------------------------------------------- */
CREATE TABLE [disk_image_dynamic] (
    [image_id] UNIQUEIDENTIFIER NOT NULL,
    [read_rate] INTEGER NULL,
    [write_rate] INTEGER NULL,
    [actual_size] BIGINT NOT NULL,
    CONSTRAINT [PK_disk_image_dynamic] PRIMARY KEY ([image_id])
)
GO

/* ---------------------------------------------------------------------- */
/* License Usage                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [dbo].[rhevm_license_usage](
	  [date] datetime primary key NOT NULL,
	  [quarter] nchar(7) NOT NULL,
      [lic_desktops] [int] NOT NULL, 
	  [max_used_desktops] [int] NOT NULL, 
	  [lic_sockets] [int] NOT NULL, 
	  [max_used_sockets] [int] NOT NULL
) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/*  table "repo_file_meta_data"                                         */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[repo_file_meta_data](
		[repo_domain_id] [uniqueidentifier] NOT NULL,
		[repo_file_name] [nvarchar](256) NOT NULL,
		[size] bigint default 0,
		[date_created] datetime default getdate(),
		[last_refreshed] bigint default 0,
		[file_type] int default 0
	 CONSTRAINT [PK_repo_file_meta_data] PRIMARY KEY ([repo_domain_id],[repo_file_name])
)
GO

/* ---------------------------------------------------------------------- */
/*  table "image_group_storage_domain_map"                                */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[image_group_storage_domain_map](
	[image_group_id] [uniqueidentifier] NOT NULL,
	[storage_domain_id] [uniqueidentifier] NOT NULL,
 CONSTRAINT [PK_image_group_storage_domain_map] PRIMARY KEY CLUSTERED 
(
	[image_group_id] ASC,
	[storage_domain_id] ASC
))
GO

/* ---------------------------------------------------------------------- */
/*  table action_version_map				                              */
/* ---------------------------------------------------------------------- */
CREATE TABLE [dbo].[action_version_map](
	[action_type] [int] NOT NULL,
	[cluster_minimal_version] [nvarchar](40) NOT NULL,
	[storage_pool_minimal_version] [nvarchar](40) NOT NULL,
 CONSTRAINT [PK_action_version_map] PRIMARY KEY CLUSTERED 
(
	[action_type] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

/* ---------------------------------------------------------------------- */
/*  table dwh_history_timekeeping				                              */
/* ---------------------------------------------------------------------- */

if (not exists (select * from sys.tables WHERE name = 'dwh_history_timekeeping'))
begin
CREATE TABLE [dbo].[dwh_history_timekeeping](
	[var_name] varchar(50) NOT NULL,
	[var_value] varchar(255) NULL,
	[var_datetime] datetime NULL
) ON [PRIMARY]
end
GO

/* ---------------------------------------------------------------------- */
/*  table business_entity_snapshot				                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE business_entity_snapshot
(
  id uniqueidentifier NOT NULL,
  command_id uniqueidentifier NOT NULL,
  command_type nvarchar(256) NOT NULL,
  entity_id nvarchar(128),
  entity_type nvarchar(128),
  entity_snapshot  text,
  snapshot_class nvarchar(128),
  snapshot_type INTEGER,
  insertion_order INTEGER,
  CONSTRAINT PK_id PRIMARY KEY (id),
  CONSTRAINT UQ_command_id_entity_id UNIQUE (command_id, entity_id, entity_type, snapshot_type)
)

GO


/* ---------------------------------------------------------------------- */
/* Foreign key constraints                                                */
/* ---------------------------------------------------------------------- */
ALTER TABLE [tags_user_group_map] ADD CONSTRAINT [tags_user_group_map_tag] 
		FOREIGN KEY ([tag_id]) REFERENCES [tags] (tag_id)
GO
ALTER TABLE [tags_user_group_map] ADD CONSTRAINT [tags_user_map_user_group] 
		FOREIGN KEY ([group_id]) REFERENCES [ad_groups] (id)
GO
ALTER TABLE [image_vm_pool_map] ADD CONSTRAINT [vm_pool_map_image] 
		FOREIGN KEY ([vm_guid]) REFERENCES [vm_pool_map] ([vm_guid]) ON DELETE CASCADE
GO

ALTER TABLE [images] ADD CONSTRAINT [image_templates_images] 
    FOREIGN KEY ([it_guid]) REFERENCES [image_templates] (it_guid)
GO



ALTER TABLE [vm_templates] ADD CONSTRAINT [vds_groups_vm_templates] 
    FOREIGN KEY ([vds_group_id]) REFERENCES [vds_groups] (vds_group_id)
GO

ALTER TABLE [vm_static] ADD CONSTRAINT [vm_templates_vm_static] 
    FOREIGN KEY ([vmt_guid]) REFERENCES [vm_templates] (vmt_guid)
GO

ALTER TABLE [vm_static] ADD CONSTRAINT [vds_groups_vm_static] 
    FOREIGN KEY ([vds_group_id]) REFERENCES [vds_groups] (vds_group_id)
GO

ALTER TABLE [vds_static] ADD CONSTRAINT [vds_groups_vds_static] 
    FOREIGN KEY ([vds_group_id]) REFERENCES [vds_groups] (vds_group_id)
GO

ALTER TABLE [vm_template_image_map] ADD CONSTRAINT [image_templates_vm_template_image_map] 
    FOREIGN KEY ([it_guid]) REFERENCES [image_templates] (it_guid)
GO

ALTER TABLE [image_vm_map] ADD CONSTRAINT [FK_image_vm_map_vm_static] 
	FOREIGN KEY ([vm_id]) REFERENCES [vm_static] ([vm_guid]) ON DELETE CASCADE
GO

ALTER TABLE [vm_template_image_map] ADD CONSTRAINT [vm_templates_vm_template_image_map] 
    FOREIGN KEY ([vmt_guid]) REFERENCES [vm_templates] (vmt_guid)
GO

ALTER TABLE [vds_dynamic] ADD CONSTRAINT [vds_static_vds_dynamic] 
    FOREIGN KEY ([vds_id]) REFERENCES [vds_static] (vds_id)
GO

ALTER TABLE [vm_dynamic] ADD CONSTRAINT [vm_static_vm_dynamic] 
    FOREIGN KEY ([vm_guid]) REFERENCES [vm_static] (vm_guid) ON DELETE CASCADE
GO

ALTER TABLE [vm_dynamic] ADD CONSTRAINT [vds_static_vm_dynamic_r] 
    FOREIGN KEY ([run_on_vds]) REFERENCES [vds_static] (vds_id)
GO

ALTER TABLE [vm_dynamic] ADD CONSTRAINT [vds_static_vm_dynamic_m] 
    FOREIGN KEY ([migrating_to_vds]) REFERENCES [vds_static] (vds_id)
GO

ALTER TABLE [vm_pool_map] ADD CONSTRAINT [vm_pools_vm] 
FOREIGN KEY ([vm_pool_id]) REFERENCES [vm_pools] (vm_pool_id)
GO

ALTER TABLE [vm_pool_map] ADD CONSTRAINT [vm_guid_pools]
	FOREIGN KEY ([vm_guid]) REFERENCES [vm_static] (vm_guid) ON DELETE CASCADE
GO

ALTER TABLE [vds_statistics] ADD CONSTRAINT [vds_static_vds_statistics] 
    FOREIGN KEY ([vds_id]) REFERENCES [vds_static] (vds_id)
GO

ALTER TABLE [vm_statistics] ADD CONSTRAINT [vm_static_vm_statistics] 
    FOREIGN KEY ([vm_guid]) REFERENCES [vm_static] (vm_guid) ON DELETE CASCADE
GO

ALTER TABLE [tags_user_map] ADD CONSTRAINT [tags_user_map_tag] 
		FOREIGN KEY ([tag_id]) REFERENCES [tags] (tag_id)
GO
ALTER TABLE [tags_user_map] ADD CONSTRAINT [tags_user_map_user] 
		FOREIGN KEY ([user_id]) REFERENCES [users] (user_id)
GO
ALTER TABLE [tags_vds_map] ADD CONSTRAINT [tags_vds_map_tag] 
		FOREIGN KEY ([tag_id]) REFERENCES [tags] (tag_id)
GO
ALTER TABLE [tags_vds_map] ADD CONSTRAINT [tags_vds_map_vds] 
		FOREIGN KEY ([vds_id]) REFERENCES [vds_static] (vds_id)
GO
ALTER TABLE [tags_vm_map] ADD CONSTRAINT [tags_vm_map_tag] 
		FOREIGN KEY ([tag_id]) REFERENCES [tags] (tag_id)
GO
ALTER TABLE [tags_vm_map] ADD CONSTRAINT [tags_vm_map_vm] 
		FOREIGN KEY ([vm_id]) REFERENCES [vm_static] (vm_guid) ON DELETE CASCADE
GO
ALTER TABLE [vm_pools] ADD CONSTRAINT [FK_vds_groups_vm_pools]
		FOREIGN KEY ([vds_group_id]) REFERENCES [vds_groups](vds_group_id)
GO

ALTER TABLE [vds_groups] ADD  CONSTRAINT [Fk_vds_groups_storage_pool_id] FOREIGN KEY([storage_pool_id]) 
		REFERENCES [dbo].[storage_pool] ([id]) ON DELETE SET NULL
GO

ALTER TABLE [images] ADD  CONSTRAINT [Fk_images_storage_id] FOREIGN KEY([storage_id]) 
		REFERENCES [dbo].[storage_domain_static] ([id])
GO
ALTER TABLE [dbo].[tags_vm_pool_map]   ADD  CONSTRAINT [fk_tags_vm_pool_map_tag] FOREIGN KEY([tag_id])
REFERENCES [dbo].[tags] ([tag_id]) ON DELETE CASCADE 
GO
ALTER TABLE [dbo].[tags_vm_pool_map]   ADD  CONSTRAINT [fk_tags_vm_pool_map_vm_pool] FOREIGN KEY([vm_pool_id])
REFERENCES [dbo].[vm_pools] ([vm_pool_id]) ON DELETE CASCADE 
GO
ALTER TABLE [dbo].[user_sessions] ADD CONSTRAINT [fk_users] 
FOREIGN KEY (user_id) REFERENCES users (user_id) ON DELETE CASCADE 
GO

ALTER TABLE [dbo].[vm_interface] ADD  CONSTRAINT [FK_vm_interface_vm_static] FOREIGN KEY([vm_guid])
REFERENCES [dbo].[vm_static] ([vm_guid]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[vds_interface]  ADD  CONSTRAINT [FK_vds_interface_vds_interface] FOREIGN KEY([vds_id])
REFERENCES [dbo].[vds_static] ([vds_id])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[network_cluster]  ADD  CONSTRAINT [FK_network_cluster_network] FOREIGN KEY([network_id])
REFERENCES [dbo].[network] ([id]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[network_cluster]  ADD  CONSTRAINT [FK_network_cluster_vds_groups] FOREIGN KEY([cluster_id])
REFERENCES [dbo].[vds_groups] ([vds_group_id]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[network] ADD CONSTRAINT [FK_network_storage_pool] FOREIGN KEY([storage_pool_id])
REFERENCES [dbo].[storage_pool] ([id]) ON DELETE SET NULL
GO

-- Event Notification 
ALTER TABLE [dbo].[event_subscriber]  ADD  CONSTRAINT [FK_EVENT_SUBSCRIBER_EVENT_MAP] FOREIGN KEY([event_up_name])
REFERENCES [dbo].[event_map] ([event_up_name])  ON DELETE CASCADE
GO

ALTER TABLE [dbo].[event_subscriber]  ADD  CONSTRAINT [FK_EVENT_SUBSCRIBER_EVENT_NOTIFICATION_METHODS] FOREIGN KEY([method_id])
REFERENCES [dbo].[event_notification_methods] ([method_id])  ON DELETE CASCADE
GO

ALTER TABLE [dbo].[event_subscriber]  ADD  CONSTRAINT [FK_EVENT_SUBSCRIBER_users] FOREIGN KEY([subscriber_id])
REFERENCES [dbo].[users] ([user_id])  ON DELETE CASCADE
GO

ALTER TABLE [dbo].[event_notification_hist]  ADD  CONSTRAINT [FK_EVENT_NOTIFICATION_HIST_audit_log] FOREIGN KEY([audit_log_id])
REFERENCES [dbo].[audit_log] ([audit_log_id])  ON DELETE CASCADE
GO

ALTER TABLE [dbo].[event_notification_hist]  ADD  CONSTRAINT [FK_EVENT_NOTIFICATION_users] FOREIGN KEY([subscriber_id])
REFERENCES [dbo].[users] ([user_id])  ON DELETE CASCADE
GO

-- [vds_spm_id_map]
ALTER TABLE [dbo].[vds_spm_id_map]  ADD  CONSTRAINT [FK_vds_spm_id_map_storage_pool] FOREIGN KEY([storage_pool_id])
REFERENCES [dbo].[storage_pool] ([id])
ON DELETE CASCADE
GO
 
ALTER TABLE [dbo].[vds_spm_id_map]  WITH CHECK ADD  CONSTRAINT [FK_vds_spm_id_map_vds_id] FOREIGN KEY([vds_id]) 
REFERENCES [dbo].[vds_static] ([vds_id]) ON DELETE CASCADE
GO

-- [image_group_storage_domain_map]
ALTER TABLE [dbo].[image_group_storage_domain_map] ADD CONSTRAINT [FK_image_group_storage_domain_map_storage_domain_static] FOREIGN KEY([storage_domain_id])
REFERENCES [dbo].[storage_domain_static] ([id]) ON DELETE CASCADE
GO

-- [repo_file_meta_data]
ALTER TABLE [repo_file_meta_data] ADD CONSTRAINT [FK_repo_file_meta_data_storage_domain_static]
	FOREIGN KEY ([repo_domain_id]) REFERENCES [storage_domain_static] ([id]) ON DELETE CASCADE
GO

ALTER TABLE [disk_image_dynamic] ADD CONSTRAINT [FK_disk_image_dynamic_images]
	FOREIGN KEY([image_id]) REFERENCES [dbo].[images] ([image_guid]) ON DELETE CASCADE
GO


ALTER TABLE [dbo].[permissions] ADD  CONSTRAINT [fk_permissions_roles] FOREIGN KEY([role_id])
	REFERENCES [dbo].[roles] ([id]) ON DELETE CASCADE 

CREATE NONCLUSTERED  INDEX IDX_permissions_ad_element_id
    ON permissions (ad_element_id ASC)
go

CREATE NONCLUSTERED  INDEX IDX_repo_file_file_type
	ON repo_file_meta_data (file_type)
go

CREATE NONCLUSTERED  INDEX IDX_permissions_object_id
    ON permissions (object_id ASC)
go

CREATE NONCLUSTERED  INDEX IDX_permissions_role_id
    ON permissions (role_id ASC)
go

CREATE NONCLUSTERED  INDEX IDX_roles_groups_action_group_id
    ON roles_groups (action_group_id ASC)
go

CREATE UNIQUE NONCLUSTERED INDEX [IDX_combined_ad_role_object] ON [dbo].[permissions] 
(
	[ad_element_id] ASC,
	[role_id] ASC,
	[object_id] ASC
)
go

CREATE NONCLUSTERED INDEX [IDX_business_entity_snapshot_command_id] ON [dbo].[business_entity_snapshot]
([command_id] ASC)
go
