PRINT 'Processing action_version_map_sp.sql'

----------------------------------------------------------------
-- [dbo].[action_version_map] Table
--

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertaction_version_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertaction_version_map] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[Insertaction_version_map]
    @action_type int,
	@cluster_minimal_version nvarchar(40),
	@storage_pool_minimal_version nvarchar(40)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[action_version_map] ([action_type], [cluster_minimal_version], [storage_pool_minimal_version])
	VALUES (@action_type, @cluster_minimal_version, @storage_pool_minimal_version)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteaction_version_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteaction_version_map] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[Deleteaction_version_map]
	@action_type int
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[action_version_map]
	WHERE [action_type]=@action_type
    
    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromaction_version_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromaction_version_map] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetAllFromaction_version_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[action_version_map].[action_type] AS 'action_type',
	[action_version_map].[cluster_minimal_version] AS 'cluster_minimal_version',
	[action_version_map].[storage_pool_minimal_version] AS 'storage_pool_minimal_version'
FROM [dbo].[action_version_map] [action_version_map]

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getaction_version_mapByaction_type')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getaction_version_mapByaction_type] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[Getaction_version_mapByaction_type] 
	@action_type int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[action_version_map].[action_type] AS 'action_type',
	[action_version_map].[cluster_minimal_version] AS 'cluster_minimal_version',
	[action_version_map].[storage_pool_minimal_version] AS 'storage_pool_minimal_version'
	FROM [dbo].[action_version_map] [action_version_map]
	WHERE [action_type]=@action_type

	SET NOCOUNT OFF
END
GO