@echo off

set ERRORLEVEL=0

set DOMAINS=%1
set USER=%2
set PASS=%3
set MIXED-MODE=%4
set KRB_CONF_FILE=krb5.conf
set JAAS_CONF_FILE=%5
set JB_HOME=%6
set JB_PROFILE=%7
set EAR_LIB=server\%JB_PROFILE%\deploy\rhevm.ear\lib

if "-%DOMAINS%" == "-" or
if "-%USER%" == "-" or
if "-%PASS%" =="-" or
if "-%MIXED-MODE%" =="-" or
if "-%JAAS_CONF_FILE%" =="-" or
if "-%JB_HOME%" =="-" or
if "-%JB_PROFILE%" == "-" goto usage


rem When DEVEOPER_MODE is empty, all jars are assumed to rest under the same folder.
rem This is used duting installation where Jboss is not extracted yet
rem set DEVELOPER_MODE=y
if "x%DEVELOPER_MODE%" == "x" (
    set CLASSPATH=%JB_HOME%\utils-3.0.3-0001.jar;%JB_HOME%\rhevm-compat.jar;%JB_HOME%\commons-logging.jar
) else ( 
    set CLASSPATH=%JB_HOME%\%EAR_LIB%\utils-3.0.3-0001.jar;%JB_HOME%\%EAR_LIB%\rhevm-compat.jar;%JB_HOME%\common\lib\commons-logging.jar
	echo ### running in deveoper mode ###
	
)

echo creating the krb5.conf file...
java -cp %CLASSPATH% org.ovirt.engine.core.utils.kerberos.KrbConfCreator -mixed_mode=%MIXED-MODE% -domains=%DOMAINS% -krb5_conf_path=%KRB_CONF_FILE%

if not ERRORLEVEL 0 goto error

echo checking the file configuration...
java -cp %CLASSPATH% org.ovirt.engine.core.utils.kerberos.KerberosConfigCheck -domains=%DOMAINS% -user=%USER% -password=%PASS% -jaas_file=%JAAS_CONF_FILE%  -krb5_conf_path=%KRB_CONF_FILE%

if ERRORLEVEL 0 goto end



:error 
set ERRORLEVEL=1
goto end 

:end
exit /b %ERRORLEVEL%

:usage
echo Usage:
echo 	%0% [domains] [user] [pass] [mixed-mode] [jass conf] [jboss home] [jboss profile]
echo Where:
echo 	domains		= comma seperaed domains list
echo 	user		= user name
echo 	pass		= password
echo 	mixed_mode	= y/n use AD in 2003 mixed mode.
echo 	jass conf	= jass conf path.
echo 	jboss home	= path to jboss-as dir
echo 	jboss profile	= jboss profile
goto error
