@ECHO OFF

setlocal enableextensions

:: ================ Input validation ================
IF (%3)==() GOTO Usage
IF NOT "%OS%"=="Windows_NT"    GOTO Usage
WMIC.EXE Alias /? >NUL 2>&1 || GOTO noWMIC
openssl /? >NUL 2>&1 || GOTO noOpenssl

set INST_MODE="0"
IF "%1"=="1" set INST_MODE="1"

set Initial_Path=%CD:Program Files (x86)=PROGRA~2%
IF EXIST ..\..\3rdparty\pub2ssh\bin\pubkey2ssh.exe (
	set PUB_SSH=%Initial_Path%\..\..\3rdparty\pub2ssh\bin\
) else IF EXIST ..\pub2ssh\bin\pubkey2ssh.exe (
	set PUB_SSH=%Initial_Path%\..\pub2ssh\bin\
) else IF EXIST pubkey2ssh.exe (
	set PUB_SSH=.\
) else (
	GOTO noPub
)

:: Calc argc:
set /A argC=0
for %%x in (%*) do (
	set /A argC+=1
)

::In installer mode we skip input calculations
IF %INST_MODE% == "1" GOTO skipCalc

set curDIR=%2
IF NOT EXIST %curDIR% GOTO noDir
IF NOT EXIST %2\keys GOTO noCA

:: ================ Time & host calculations ================

:: ================ Calculate current time -24 hours in ASN1 format ================
:: Use WMIC to retrieve UTC date and time
FOR /F "skip=2 tokens=2-7 delims=," %%A IN ('WMIC Path Win32_UTCTime Get Day^,Hour^,Minute^,Month^,Second^,Year /Format:csv') DO (
	SET /A UTCYear = %%F - 2000
	SET /A UTCDay = %%A - 1
	SET /A UTCDate = 10000 * UTCYear + 100 * %%D + UTCDay
	SET /A UTCTime = 10000 * %%B + 100 * %%C + %%E
)

:: Use WMIC to retrieve timezone in minutes
FOR /F "skip=2 tokens=1-2 delims=," %%A IN ('wmic OS Get CurrentTimeZone /Format:csv') DO (
	SET /A UTCZone = %%B / 60
	set /a TZfrac=%%B%%60*100/60
)

:: Remove negation sign
if %TZfrac% LSS 0 set /a TZfrac=-%TZfrac%

:: If we have a fraction convert to 30 minutes.
if %TZfrac% NEQ 0 (
	set TZfrac=30
) else (
	set TZfrac=00
)

:: Add +/- sign to the result
if %UTCZone% LSS 0 (
	set UTCFull=-
	set /a UTCZone=-%UTCZone%
) else (
	set UTCFull=+
)

:: Add leading zero where needed
if %UTCZone% LSS 10 (
	set UTCFull=%UTCFull%0
)
if %UTCTime% LSS 100000 (
	set UTCTime=0%UTCTime%
)

set TZ=%UTCFull%%UTCZone%%TZfrac%
set DATE=%UTCDate%%UTCTime%%TZ%

REM :: Display the results:
REM echo ASN1 time formated now -1 day: %DATE%

:skipCalc

:: Use WMIC to retrieve hostname
FOR /F "skip=2 tokens=1-2 delims=," %%A IN ('wmic path Win32_ComputerSystem Get Name^,Domain /Format:csv') DO (
	SET HOST=%%A.%%B
)

:: ================ Set other variables ================

if %INST_MODE% == "1" (
	set C=%2
	set O=%3
	set SUBJECT=%4
	set CA_SUBJECT=%5
	set PASS=%6
	set ALIAS=%7
	set START_DATE=%8
	set JB=%9
) else (
	set C=US
	set O=RedHat
	set SUBJECT=%HOST%
	set CA_SUBJECT=CA-%HOST%
	set PASS=mypass
	set ALIAS=rhevm
	set START_DATE=%DATE%
	set JB=c:\Program Files\jboss-eap-5.0
	set ROOT_WAR=%JB%\server\default\deploy\ROOT.war
)

:: Handle extra param's
:: IMPORTANT!!! From now on we change param order!!!! %0 and %1 will be gone!
:: ============================================================================
:: Read ROOT.war location
set JB=%JB:"=%
set original=%9
IF %argC% GTR 9 shift
IF NOT (%9)==(%original%) set ROOT_WAR=%JB%\%9
set original=%9
set /A argC-=1

:: Read CN2 (if given)
IF %argC% GTR 9 shift
IF NOT (%9)==(%original%) set CN2=%9
set original=%9
set /A argC-=1

:: Read CN3 (if given)
IF %argC% GTR 9 shift
IF NOT (%9)==(%original%) set CN3=%9

:: ================ Start working... ================
if %INST_MODE% == "0" (
	echo # Generating CA in working directory %3...
	xcopy /Q /E /Y /I %2 %3
	cd %3
)
set CurrentPath=%CD:Program Files (x86)=PROGRA~2%

echo.
echo } Creating CA...

call CreateCA.bat %C% %O% %CA_SUBJECT% %START_DATE% %CN2% %CN3%
set curFile=private\ca.pem
IF NOT EXIST %curFile% GOTO noFile
set curFile=requests\ca.csr
IF NOT EXIST %curFile% GOTO noFile
set curFile=ca.pem
IF NOT EXIST %curFile% GOTO noFile

echo.
echo } Creating KeyStore...
call CreateKStore.bat %CurrentPath% %C% %O% %SUBJECT% %ALIAS% %PASS% %PASS%
set curFile=.\.keystore
IF NOT EXIST %curFile% GOTO noFile

echo.
echo }} Converting formats...
openssl x509 -in ca.pem -out certs\ca.der -outform DER

echo.
echo } Importing CA certificate...
:: Generate truststore
keytool -import -noprompt -trustcacerts -alias cacert -keypass %PASS% -file certs\ca.der -keystore .\.truststore -storepass %PASS%
:: Import to keystore as well
call importToKeyStore.bat %CurrentPath%\.keystore cacert certs\ca.der %PASS%
del certs\ca.der

echo.
echo } Creating client certificate for oVirt...

echo.
echo }} Creating certificate request...
call CreateReq.bat 1 %C% %O% %SUBJECT% %ALIAS% %PASS%

echo.
echo }} Signing certificate request...
call SignReq.bat rhevm.req rhevm.cer 1800 %CurrentPath% %START_DATE% %PASS%
set curFile=certs\rhevm.cer
IF NOT EXIST %curFile% GOTO noFile

echo.
echo }} Converting formats...
openssl x509 -in certs\rhevm.cer -out certs\rhevm.der -outform DER

echo.
echo } Importing oVirt certificate...
call importToKeyStore.bat %CurrentPath%\.keystore %ALIAS% certs\rhevm.der %PASS%
del certs\rhevm.der

echo.
echo } Exporting oVirt key as SSH...
call exportK2SSH.bat %CurrentPath%\.keystore %ALIAS% rhevm.pub %PASS%
%PUB_SSH%\pubkey2ssh.exe %CurrentPath%\keys\rhevm.pub rhevm > %CurrentPath%\keys\rhevm.ssh.key.txt
del keys\rhevm.pub

echo.
echo } Copying SSH key to JBoss...
echo.

IF NOT DEFINED JB set JB=%JBOSS_HOME%
set JB=%JB:"=%
IF EXIST "%JB%" (
	echo copy "%CurrentPath%\keys\rhevm.ssh.key.txt" "%ROOT_WAR%"
	copy "%CurrentPath%\keys\rhevm.ssh.key.txt" "%ROOT_WAR%"
) ELSE (
	echo Unable to locate JBoss install dir. Please copy %CurrentPath%\keys\rhevm.ssh.key.txt to JBOSS_HOME\%ROOT_WAR%
)

echo.
echo CA Installation Done.
echo.

IF %INST_MODE% == "1" GOTO done

echo ======================================================
echo Please note:
echo ======================================================
echo }}} Do not forget to set:
echo.
echo }}} 1. Update ConfigValues.java (if not possible in DB):
echo }}} 1.1. CABaseDirectory to %3
echo }}} 1.2. keystoreUrl to %3\.keystore
echo }}} 1.3. TruststoreUrl to %3\.keystore
echo }}} 1.4. SignScriptName to bat(/sh) 
echo }}} 1.5. PublicURLPath to [jboss dir]\jboss-as\server\default\deploy\ROOT.war\
echo.
echo }}} 2. DB updates (vdc_options table):
echo }}} 2.1. CertificateFileName %3\certs\rhevm.cer
echo }}} 2.2. CABaseDirectory to %3"
echo }}} 2.3. CARhevmKey to %3\private\ca.pem"
echo ======================================================

:done
endlocal
EXIT /B %ERRORLEVEL%

:Usage
ECHO installCA.bat- creates a ca structure for installer or development environment.
ECHO This script can run only on XP Pro and later (vista, 2008, etc).
ECHO Usage: 
ECHO     installCA.bat [Installer mode: 0] [git CA dir path] [working directory]
ECHO     or
ECHO     installCA.bat [Installer mode: 1] [Country] [Organization] [Subject] [CA-Subject] [keystore pass] [Alias] [ASN1 START DATE] [JBOSS_HOME] [ROOT_WAR] [CN2] [CN3]

ECHO	 IE: installCA.bat 0 c:\dev\ca c:\temp\ca
ECHO	 or-
ECHO	 IE: installCA.bat 1 US RedHat my-host.redhat.com ca-my-host.redhat.com changepass rhevm 101222132527+0200 "c:\Program Files\jboss-eap-5.0" jboss-as\server\default\deploy\ROOT.war my-cn-test
ECHO Where:
ECHO     Installer mode		= 1 To be used by installer, 0 otherwise.
ECHO     git CA dir path	= Path to git source ca directory. ie- c:\dev\ca
ECHO     working directory	= Path to target ca dir. ie- c:\temp\ca

endlocal
Exit /B 1

:noDir
ECHO Directory %curDIR% does not exist!
endlocal
Exit /B 1

:noCA
ECHO Directory $1 is not CA!
endlocal
Exit /B 1

:noFile
ECHO File %curFile% does not exist!
endlocal
Exit /B 1

:noWMIC
ECHO Can't use wmic. Please verify it's installed and in the path.
endlocal
Exit /B 1

:noOpenssl
ECHO Can't use openssl. Please verify it's installed and in the path.
endlocal
Exit /B 1

:noPub
ECHO Can't locate pubkey2ssh. Please verify it's in the path.
endlocal
Exit /B 1

