/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT MODIFY */

/*
 * schema-defined QAPI visitor functions
 *
 * Copyright IBM, Corp. 2011
 *
 * Authors:
 *  Anthony Liguori   <aliguori@us.ibm.com>
 *
 * This work is licensed under the terms of the GNU LGPL, version 2.1 or later.
 * See the COPYING.LIB file in the top-level directory.
 *
 */

#include "rhev-qapi-visit.h"

void visit_type_NewImageMode(Visitor *m, NewImageMode * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, NewImageMode_lookup, "NewImageMode", name, errp);
}

void visit_type_BlockdevSnapshot(Visitor *m, BlockdevSnapshot ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevSnapshot", name, sizeof(BlockdevSnapshot), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
                visit_type_str(m, obj ? &(*obj)->snapshot_file : NULL, "snapshot-file", &err);
                visit_start_optional(m, obj ? &(*obj)->has_format : NULL, "format", &err);
                if (obj && (*obj)->has_format) {
                    visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_mode : NULL, "mode", &err);
                if (obj && (*obj)->has_mode) {
                    visit_type_NewImageMode(m, obj ? &(*obj)->mode : NULL, "mode", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevSnapshotList(Visitor *m, BlockdevSnapshotList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevSnapshotList *native_i = (BlockdevSnapshotList *)i;
                visit_type_BlockdevSnapshot(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevMirror(Visitor *m, BlockdevMirror ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevMirror", name, sizeof(BlockdevMirror), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
                visit_type_str(m, obj ? &(*obj)->target : NULL, "target", &err);
                visit_start_optional(m, obj ? &(*obj)->has_format : NULL, "format", &err);
                if (obj && (*obj)->has_format) {
                    visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_speed : NULL, "speed", &err);
                if (obj && (*obj)->has_speed) {
                    visit_type_int(m, obj ? &(*obj)->speed : NULL, "speed", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_full : NULL, "full", &err);
                if (obj && (*obj)->has_full) {
                    visit_type_bool(m, obj ? &(*obj)->full : NULL, "full", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_mode : NULL, "mode", &err);
                if (obj && (*obj)->has_mode) {
                    visit_type_NewImageMode(m, obj ? &(*obj)->mode : NULL, "mode", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevMirrorList(Visitor *m, BlockdevMirrorList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevMirrorList *native_i = (BlockdevMirrorList *)i;
                visit_type_BlockdevMirror(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevActionKind(Visitor *m, BlockdevActionKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockdevActionKind_lookup, "BlockdevActionKind", name, errp);
}

void visit_type_BlockdevAction(Visitor *m, BlockdevAction ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "BlockdevAction", name, sizeof(BlockdevAction), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevActionKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case BLOCKDEV_ACTION_KIND_BLOCKDEV_SNAPSHOT_SYNC:
                        visit_type_BlockdevSnapshot(m, &(*obj)->blockdev_snapshot_sync, "data", &err);
                        break;
                    case BLOCKDEV_ACTION_KIND_COM_REDHAT_DRIVE_MIRROR:
                        visit_type_BlockdevMirror(m, &(*obj)->__com_redhat_drive_mirror, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevActionList(Visitor *m, BlockdevActionList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevActionList *native_i = (BlockdevActionList *)i;
                visit_type_BlockdevAction(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageCheck(Visitor *m, ImageCheck ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ImageCheck", name, sizeof(ImageCheck), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->filename : NULL, "filename", &err);
                visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
                visit_type_int(m, obj ? &(*obj)->check_errors : NULL, "check-errors", &err);
                visit_start_optional(m, obj ? &(*obj)->has_image_end_offset : NULL, "image-end-offset", &err);
                if (obj && (*obj)->has_image_end_offset) {
                    visit_type_int(m, obj ? &(*obj)->image_end_offset : NULL, "image-end-offset", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_corruptions : NULL, "corruptions", &err);
                if (obj && (*obj)->has_corruptions) {
                    visit_type_int(m, obj ? &(*obj)->corruptions : NULL, "corruptions", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_leaks : NULL, "leaks", &err);
                if (obj && (*obj)->has_leaks) {
                    visit_type_int(m, obj ? &(*obj)->leaks : NULL, "leaks", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_corruptions_fixed : NULL, "corruptions-fixed", &err);
                if (obj && (*obj)->has_corruptions_fixed) {
                    visit_type_int(m, obj ? &(*obj)->corruptions_fixed : NULL, "corruptions-fixed", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_leaks_fixed : NULL, "leaks-fixed", &err);
                if (obj && (*obj)->has_leaks_fixed) {
                    visit_type_int(m, obj ? &(*obj)->leaks_fixed : NULL, "leaks-fixed", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_total_clusters : NULL, "total-clusters", &err);
                if (obj && (*obj)->has_total_clusters) {
                    visit_type_int(m, obj ? &(*obj)->total_clusters : NULL, "total-clusters", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_allocated_clusters : NULL, "allocated-clusters", &err);
                if (obj && (*obj)->has_allocated_clusters) {
                    visit_type_int(m, obj ? &(*obj)->allocated_clusters : NULL, "allocated-clusters", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_fragmented_clusters : NULL, "fragmented-clusters", &err);
                if (obj && (*obj)->has_fragmented_clusters) {
                    visit_type_int(m, obj ? &(*obj)->fragmented_clusters : NULL, "fragmented-clusters", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageCheckList(Visitor *m, ImageCheckList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ImageCheckList *native_i = (ImageCheckList *)i;
                visit_type_ImageCheck(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceMapEntry(Visitor *m, BlockDeviceMapEntry ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockDeviceMapEntry", name, sizeof(BlockDeviceMapEntry), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_int(m, obj ? &(*obj)->start : NULL, "start", &err);
                visit_type_int(m, obj ? &(*obj)->length : NULL, "length", &err);
                visit_type_int(m, obj ? &(*obj)->depth : NULL, "depth", &err);
                visit_type_bool(m, obj ? &(*obj)->zero : NULL, "zero", &err);
                visit_type_bool(m, obj ? &(*obj)->data : NULL, "data", &err);
                visit_start_optional(m, obj ? &(*obj)->has_offset : NULL, "offset", &err);
                if (obj && (*obj)->has_offset) {
                    visit_type_int(m, obj ? &(*obj)->offset : NULL, "offset", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceMapEntryList(Visitor *m, BlockDeviceMapEntryList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockDeviceMapEntryList *native_i = (BlockDeviceMapEntryList *)i;
                visit_type_BlockDeviceMapEntry(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_EventInfo(Visitor *m, EventInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "EventInfo", name, sizeof(EventInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_EventInfoList(Visitor *m, EventInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                EventInfoList *native_i = (EventInfoList *)i;
                visit_type_EventInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_String(Visitor *m, String ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "String", name, sizeof(String), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->str : NULL, "str", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_StringList(Visitor *m, StringList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                StringList *native_i = (StringList *)i;
                visit_type_String(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_InetSocketAddress(Visitor *m, InetSocketAddress ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "InetSocketAddress", name, sizeof(InetSocketAddress), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
                visit_type_str(m, obj ? &(*obj)->port : NULL, "port", &err);
                visit_start_optional(m, obj ? &(*obj)->has_to : NULL, "to", &err);
                if (obj && (*obj)->has_to) {
                    visit_type_uint16(m, obj ? &(*obj)->to : NULL, "to", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_ipv4 : NULL, "ipv4", &err);
                if (obj && (*obj)->has_ipv4) {
                    visit_type_bool(m, obj ? &(*obj)->ipv4 : NULL, "ipv4", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_ipv6 : NULL, "ipv6", &err);
                if (obj && (*obj)->has_ipv6) {
                    visit_type_bool(m, obj ? &(*obj)->ipv6 : NULL, "ipv6", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_InetSocketAddressList(Visitor *m, InetSocketAddressList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                InetSocketAddressList *native_i = (InetSocketAddressList *)i;
                visit_type_InetSocketAddress(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_UnixSocketAddress(Visitor *m, UnixSocketAddress ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "UnixSocketAddress", name, sizeof(UnixSocketAddress), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->path : NULL, "path", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_UnixSocketAddressList(Visitor *m, UnixSocketAddressList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                UnixSocketAddressList *native_i = (UnixSocketAddressList *)i;
                visit_type_UnixSocketAddress(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SocketAddressKind(Visitor *m, SocketAddressKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, SocketAddressKind_lookup, "SocketAddressKind", name, errp);
}

void visit_type_SocketAddress(Visitor *m, SocketAddress ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "SocketAddress", name, sizeof(SocketAddress), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_SocketAddressKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case SOCKET_ADDRESS_KIND_INET:
                        visit_type_InetSocketAddress(m, &(*obj)->inet, "data", &err);
                        break;
                    case SOCKET_ADDRESS_KIND_UNIX:
                        visit_type_UnixSocketAddress(m, &(*obj)->q_unix, "data", &err);
                        break;
                    case SOCKET_ADDRESS_KIND_FD:
                        visit_type_String(m, &(*obj)->fd, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SocketAddressList(Visitor *m, SocketAddressList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                SocketAddressList *native_i = (SocketAddressList *)i;
                visit_type_SocketAddress(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevFile(Visitor *m, ChardevFile ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevFile", name, sizeof(ChardevFile), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_start_optional(m, obj ? &(*obj)->has_in : NULL, "in", &err);
                if (obj && (*obj)->has_in) {
                    visit_type_str(m, obj ? &(*obj)->in : NULL, "in", &err);
                }
                visit_end_optional(m, &err);
                visit_type_str(m, obj ? &(*obj)->out : NULL, "out", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevFileList(Visitor *m, ChardevFileList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevFileList *native_i = (ChardevFileList *)i;
                visit_type_ChardevFile(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevHostdev(Visitor *m, ChardevHostdev ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevHostdev", name, sizeof(ChardevHostdev), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevHostdevList(Visitor *m, ChardevHostdevList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevHostdevList *native_i = (ChardevHostdevList *)i;
                visit_type_ChardevHostdev(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSocket(Visitor *m, ChardevSocket ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevSocket", name, sizeof(ChardevSocket), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_SocketAddress(m, obj ? &(*obj)->addr : NULL, "addr", &err);
                visit_start_optional(m, obj ? &(*obj)->has_server : NULL, "server", &err);
                if (obj && (*obj)->has_server) {
                    visit_type_bool(m, obj ? &(*obj)->server : NULL, "server", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_wait : NULL, "wait", &err);
                if (obj && (*obj)->has_wait) {
                    visit_type_bool(m, obj ? &(*obj)->wait : NULL, "wait", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_nodelay : NULL, "nodelay", &err);
                if (obj && (*obj)->has_nodelay) {
                    visit_type_bool(m, obj ? &(*obj)->nodelay : NULL, "nodelay", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_telnet : NULL, "telnet", &err);
                if (obj && (*obj)->has_telnet) {
                    visit_type_bool(m, obj ? &(*obj)->telnet : NULL, "telnet", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSocketList(Visitor *m, ChardevSocketList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevSocketList *native_i = (ChardevSocketList *)i;
                visit_type_ChardevSocket(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevDgram(Visitor *m, ChardevDgram ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevDgram", name, sizeof(ChardevDgram), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_SocketAddress(m, obj ? &(*obj)->remote : NULL, "remote", &err);
                visit_start_optional(m, obj ? &(*obj)->has_local : NULL, "local", &err);
                if (obj && (*obj)->has_local) {
                    visit_type_SocketAddress(m, obj ? &(*obj)->local : NULL, "local", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevDgramList(Visitor *m, ChardevDgramList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevDgramList *native_i = (ChardevDgramList *)i;
                visit_type_ChardevDgram(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevMux(Visitor *m, ChardevMux ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevMux", name, sizeof(ChardevMux), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->chardev : NULL, "chardev", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevMuxList(Visitor *m, ChardevMuxList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevMuxList *native_i = (ChardevMuxList *)i;
                visit_type_ChardevMux(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevStdio(Visitor *m, ChardevStdio ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevStdio", name, sizeof(ChardevStdio), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_start_optional(m, obj ? &(*obj)->has_signal : NULL, "signal", &err);
                if (obj && (*obj)->has_signal) {
                    visit_type_bool(m, obj ? &(*obj)->signal : NULL, "signal", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevStdioList(Visitor *m, ChardevStdioList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevStdioList *native_i = (ChardevStdioList *)i;
                visit_type_ChardevStdio(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSpiceChannel(Visitor *m, ChardevSpiceChannel ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevSpiceChannel", name, sizeof(ChardevSpiceChannel), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSpiceChannelList(Visitor *m, ChardevSpiceChannelList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevSpiceChannelList *native_i = (ChardevSpiceChannelList *)i;
                visit_type_ChardevSpiceChannel(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSpicePort(Visitor *m, ChardevSpicePort ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevSpicePort", name, sizeof(ChardevSpicePort), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_str(m, obj ? &(*obj)->fqdn : NULL, "fqdn", &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSpicePortList(Visitor *m, ChardevSpicePortList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevSpicePortList *native_i = (ChardevSpicePortList *)i;
                visit_type_ChardevSpicePort(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevVC(Visitor *m, ChardevVC ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevVC", name, sizeof(ChardevVC), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_start_optional(m, obj ? &(*obj)->has_width : NULL, "width", &err);
                if (obj && (*obj)->has_width) {
                    visit_type_int(m, obj ? &(*obj)->width : NULL, "width", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_height : NULL, "height", &err);
                if (obj && (*obj)->has_height) {
                    visit_type_int(m, obj ? &(*obj)->height : NULL, "height", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_cols : NULL, "cols", &err);
                if (obj && (*obj)->has_cols) {
                    visit_type_int(m, obj ? &(*obj)->cols : NULL, "cols", &err);
                }
                visit_end_optional(m, &err);
                visit_start_optional(m, obj ? &(*obj)->has_rows : NULL, "rows", &err);
                if (obj && (*obj)->has_rows) {
                    visit_type_int(m, obj ? &(*obj)->rows : NULL, "rows", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevVCList(Visitor *m, ChardevVCList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevVCList *native_i = (ChardevVCList *)i;
                visit_type_ChardevVC(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevRingbuf(Visitor *m, ChardevRingbuf ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevRingbuf", name, sizeof(ChardevRingbuf), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_start_optional(m, obj ? &(*obj)->has_size : NULL, "size", &err);
                if (obj && (*obj)->has_size) {
                    visit_type_int(m, obj ? &(*obj)->size : NULL, "size", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevRingbufList(Visitor *m, ChardevRingbufList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevRingbufList *native_i = (ChardevRingbufList *)i;
                visit_type_ChardevRingbuf(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevDummy(Visitor *m, ChardevDummy ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevDummy", name, sizeof(ChardevDummy), &err);
        if (!err) {
            if (!obj || *obj) {
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevDummyList(Visitor *m, ChardevDummyList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevDummyList *native_i = (ChardevDummyList *)i;
                visit_type_ChardevDummy(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevBackendKind(Visitor *m, ChardevBackendKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, ChardevBackendKind_lookup, "ChardevBackendKind", name, errp);
}

void visit_type_ChardevBackend(Visitor *m, ChardevBackend ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "ChardevBackend", name, sizeof(ChardevBackend), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevBackendKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case CHARDEV_BACKEND_KIND_FILE:
                        visit_type_ChardevFile(m, &(*obj)->file, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SERIAL:
                        visit_type_ChardevHostdev(m, &(*obj)->serial, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_PARALLEL:
                        visit_type_ChardevHostdev(m, &(*obj)->parallel, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_PIPE:
                        visit_type_ChardevHostdev(m, &(*obj)->pipe, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SOCKET:
                        visit_type_ChardevSocket(m, &(*obj)->socket, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_DGRAM:
                        visit_type_ChardevDgram(m, &(*obj)->dgram, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_PTY:
                        visit_type_ChardevDummy(m, &(*obj)->pty, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_NULL:
                        visit_type_ChardevDummy(m, &(*obj)->null, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_MUX:
                        visit_type_ChardevMux(m, &(*obj)->mux, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_MSMOUSE:
                        visit_type_ChardevDummy(m, &(*obj)->msmouse, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_BRAILLE:
                        visit_type_ChardevDummy(m, &(*obj)->braille, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_STDIO:
                        visit_type_ChardevStdio(m, &(*obj)->stdio, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_CONSOLE:
                        visit_type_ChardevDummy(m, &(*obj)->console, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SPICEVMC:
                        visit_type_ChardevSpiceChannel(m, &(*obj)->spicevmc, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SPICEPORT:
                        visit_type_ChardevSpicePort(m, &(*obj)->spiceport, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_VC:
                        visit_type_ChardevVC(m, &(*obj)->vc, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_MEMORY:
                        visit_type_ChardevRingbuf(m, &(*obj)->memory, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevBackendList(Visitor *m, ChardevBackendList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevBackendList *native_i = (ChardevBackendList *)i;
                visit_type_ChardevBackend(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevReturn(Visitor *m, ChardevReturn ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevReturn", name, sizeof(ChardevReturn), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_start_optional(m, obj ? &(*obj)->has_pty : NULL, "pty", &err);
                if (obj && (*obj)->has_pty) {
                    visit_type_str(m, obj ? &(*obj)->pty : NULL, "pty", &err);
                }
                visit_end_optional(m, &err);
            
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevReturnList(Visitor *m, ChardevReturnList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevReturnList *native_i = (ChardevReturnList *)i;
                visit_type_ChardevReturn(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}
