""" 3.0 -> 3.1 upgrade msgs """

import basedefs
import basedefs30

MSG_INFO_30_DETECTED = "Info: %s 3.0 to 3.1 upgrade detected" % basedefs.APP_NAME
MSG_WARN_UPGRADE_WHITELIST = "\nWarning: the following packages will be removed if you proceed \
with the upgrade:\n%s\n"

MSG_ERROR_REMOVE_PREVIOUS = "Error: Couldn't remove previous installation"
MSG_INFO_PROCEED="Would you like to proceed"
MSG_ERROR_QUERY_REPORTS_DB = "Error: sql query on rhevmreports DB failed."
MSG_ERROR_UPGRADE_IPA = "Error: IPA was found to be installed on this machine. %s 3.1 \
does not support installing IPA on the same machine. Please refer to https://access.redhat.com/knowledge/articles/233143, \
on how to migrate IPA and remove IPA packages before you continue." % basedefs.APP_NAME
MSG_ERROR_UPGRADE_RHDS = "Error: redhat-ds package was found to be installed on this machine. %s 3.1 \
does not support installing RHDS on the same machine. Please remove redhat-ds package before you \
continue." % basedefs.APP_NAME
MSG_ERROR_UPGRADE_JASPER = "Error: Jasper Server was found to be installed on this machine. Upgrade \
to %s 3.1 will remove complete JBoss installation including Jasper. Please remove Jasper installation \
before you continue." % basedefs.APP_NAME
MSG_ERROR_BACKUP_JASPER = "Error: Failed to backup an old Jasper installation."
MSG_ERROR_RPM_QUERY = "Error: Unable to retrieve rpm versions"
MSG_ERROR_UPGRADE_FAILED = "Error: Upgrade failed"

MSG_ROLLBACK_INSTRUCTIONS = "In order to restore the previous installation, perform the following steps: \n\
1. Make sure that there are no EAP6 packages on the system:\n\
\trpm -qa | grep ep6\.el6\n\
If there are such packages, remove them:\n\
\tyum remove `rpm -qa | grep ep6\.el6`\n\
2. Make sure that rhevm or its dependencies are not installed:\n\
\trpm -qa | grep rhevm \n\
If they are still installed, remove them:\n\
\tyum remove `rpm -qa | grep rhevm`\n\
3. Disable JBoss EAP6 and RHEVM-3.1 channels in order to avoid package dependency issues.\n\
4. Install rhevm-3.0 from the RHEVM-3.0 channel. For example, use the following command:\n\
\tyum install %s\n\
5. Update changed packages, use the following command:\n\
\tyum update jakarta-commons-codec jakarta-commons-collections jakarta-commons-lang jakarta-commons-pool jdom log4j slf4j\n\
6. Rename DB if it is present:\n\
\tpsql -U postgres --list\n\
If 'rhevm' DB exists, rename it:\n\
\tpsql -U postgres -c \"ALTER DATABASE rhevm RENAME TO rhevm_old;\"\n\
7. Run rhevm-setup using the answer file located at " + basedefs30.ANSWER_FILE + ":\n\
\trhevm-setup --answer-file=" + basedefs30.ANSWER_FILE + "\n\
8. Remove the DB created by the setup:\n\
\tservice jbossas stop\n\
\tdropdb -U postgres rhevm\n\
9. Drop the role created by setup:\n\
\tpsql -U postgres -c \"DROP ROLE engine\"\n\
10. Remove the pgpass dir created by setup:\n\
\trm -r /etc/ovirt-engine/\n\
11. Restore the production DB using the backup file by running the following commands: \n\
\tpsql -U postgres -f %s \n\
\tpsql -U postgres -c \"ALTER DATABASE engine RENAME TO rhevm;\"\n\
12. Restore security certificates and configs using the following command: \n\
\ttar jxvfP " + basedefs30.OLD_VERSION_FILES + " \n\
13. Start jboss service using the following command: \n\
\tservice jbossas start\n\
\nUp-to-date instructions are also available at: https://access.redhat.com/knowledge/articles/269333"

MSG_ERROR_UPGRADE_DWH = "\nTo restore DWH perform the following:\n\
1. Install dwh package:\n\
\tyum install %s\n\
2. Start ETL service:\n\
\tservice rhevm-etl start\n\
\tservice rhevm-notifierd start\n"

MSG_ERROR_UPGRADE_REPORTS = "\nTo restore reports installation perform the following:\n\
1. Install reports packages:\n\
\tyum install %s\n\
2. Stop the JBoss service:\n\
\tservice jbossas stop\n\
3. Rename the original DB:\n\
\tpsql -U postgres -c \"ALTER DATABASE rhevmreports RENAME TO rhevmreports_orig;\"\n\
4. Run reports setup. Answers to interactive questions do not matter:\n\
\trhevm-reports-setup\n\
5. Drop the newly created DB and restore the original one:\n\
\tpsql -U postgres -c \"DROP DATABASE rhevmreports\"\n\
\tpsql -U postgres -c \"ALTER DATABASE rhevmreports_orig RENAME TO rhevmreports;\"\n\
6. Restart Jboss service:\n\
\tservice jbossas start\n"
