using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Shapes;
using System.Windows.Controls;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.monitor;

namespace UI.WPFClient
{
	public class LineChart : Chart
	{
		private Canvas host;
		private Polyline line;

		#region Properties

		public IList<ChartSeriesModel> Items
		{
			get { return (IList<ChartSeriesModel>)GetValue(ItemsProperty); }
			set { SetValue(ItemsProperty, value); }
		}
		public static readonly DependencyProperty ItemsProperty =
			DependencyProperty.Register("Items", typeof(IList<ChartSeriesModel>), typeof(LineChart), new UIPropertyMetadata(null, ItemsChanged));

		private static void ItemsChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			LineChart instance = (LineChart)d;
			instance.ItemsChanged((IList<ChartSeriesModel>)e.NewValue);
		}

		#endregion

		public override void OnApplyTemplate()
		{
			base.OnApplyTemplate();

			host = GetTemplateChild("PART_Host") as Canvas;
			host.SizeChanged += Host_SizeChanged;

			line = GetTemplateChild("PART_Line") as Polyline;
		}

		private void Host_SizeChanged(object sender, SizeChangedEventArgs e)
		{
			BuildShape();
		}

		private void ItemsChanged(IList<ChartSeriesModel> value)
		{
			var notifier = value as INotifyCollectionChanged;
			if (notifier != null)
			{
				notifier.CollectionChanged += LineChart_CollectionChanged;
			}
			else
			{
				BuildShape();
			}
		}

		void LineChart_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
		{
			if (e.Action == NotifyCollectionChangedAction.Add)
			{
				BuildShape();
			}
		}

		public void BuildShape()
		{
			if (Items == null)
			{
				return;
			}

			line.Points.Clear();

			double ystep = (host.ActualHeight - 2) / 100.0;
			const double xstep = 1.0;
			int index = 0;
			double x = 0.0;

			foreach (var item in Items)
			{
				x = xstep * index;
				double y = host.ActualHeight - (double)item.Y * ystep - 1.0;
				//y = Math.Min(host.ActualHeight, y);

				Point pt = new Point(x, y);
				line.Points.Add(pt);

				index++;
			}

			double diff = x - host.ActualWidth;
			Canvas.SetLeft(line, -diff);

			if (x >= host.ActualWidth)
			{
				for (int i = 0; i < Convert.ToInt32(diff / xstep); i++)
				{
					Items.RemoveAt(0);
				}
			}
		}
	}
}
