using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;
using VdcFrontend;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using System.Windows.Controls;
using System.Windows.Documents;
using org.ovirt.engine.ui.uicommon.models;

namespace UI.WPFClient
{
	public interface IDocumentBuilder
	{
		void BuildDocument(FlowDocument document);
	}


	public class MessageModel : Model
	{
		#region Events

		public event EventHandler Closed = delegate { }; 

		#endregion

		#region Properties

		private IDocumentBuilder documentBuilder;
		public IDocumentBuilder DocumentBuilder
		{
			get { return documentBuilder; }
			set
			{
				documentBuilder = value;
				RecreateFlowDocument();
			}
		}


		private FlowDocument document;
		public FlowDocument Document
		{
			get { return document; }
			set
			{
				if (document != value)
				{
					document = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Document"));
				}
			}
		}

		/// <summary>
		/// Gets or sets a value indicating whether the message this
		/// model representing should be the only one user may see.
		/// </summary>
		public bool IsExclusive { get; set; }

		#endregion

		public MessageModel()
		{
			Commands.Add(
				new UICommand("Close", this)
				{
					Title = "Close",
					IsDefault = true,
					IsCancel = true
				});
		}

		private void RecreateFlowDocument()
		{
			Document =
				new FlowDocument
				{
					PagePadding = new Thickness(0, 0, 0, 0),
					FontFamily = new FontFamily("Verdana"),
					FontSize = 12,
					TextAlignment = TextAlignment.Left
				};

			DocumentBuilder.BuildDocument(Document);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command.Name == "Close")
			{
				Closed(this, EventArgs.Empty);
			}
		}
	}
}
