﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Interactivity;

namespace UI.WPFClient
{
	public class BindablePasswordBehavior : Behavior<PasswordBox>
	{
		#region Properties

		public string Password
		{
			get { return (string)GetValue(PasswordProperty); }
			set { SetValue(PasswordProperty, value); }
		}
		public static readonly DependencyProperty PasswordProperty =
			DependencyProperty.Register("Password", typeof(string), typeof(BindablePasswordBehavior), new FrameworkPropertyMetadata(null, FrameworkPropertyMetadataOptions.BindsTwoWayByDefault, PasswordChanged));

		private static void PasswordChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			var instance = (BindablePasswordBehavior)d;
			instance.PasswordChanged();
		}

		#endregion

		private bool isUpdating;

		protected override void OnAttached()
		{
			base.OnAttached();

			AssociatedObject.PasswordChanged += PasswordChanged;
		}

		private void PasswordChanged(object sender, RoutedEventArgs e)
		{
			PasswordBox passwordBox = (PasswordBox)sender;
			isUpdating = true;
			Password = passwordBox.Password;
			isUpdating = false;
		}

		private void PasswordChanged()
		{
			AssociatedObject.PasswordChanged -= PasswordChanged;

			if (!isUpdating)
			{
				AssociatedObject.Password = Password;
			}

			AssociatedObject.PasswordChanged += PasswordChanged;
		}
	}
}
