﻿using System;
using System.Xml;

namespace VdcUtils
{
    public class XmlUtils
    {
        /// <summary>
        /// Gets the node Attribute value using XPath.
        /// </summary>
        /// <param name="doc">The doc.</param>
        /// <param name="xPath">The x path pattern to the node.</param>
        /// <param name="attribute">The attribute name.</param>
        /// <param name="error">The error string (if occured).</param>
        /// <returns></returns>
        public static String GetNodeAttributeValue(XmlDocument doc, String xPath, string attribute, out string error)
        {
            String value = string.Empty;
            error = string.Empty;

            try
            {
                XmlNode node = doc.SelectSingleNode(xPath);
                if (node != null)
                {
                    value = node.Attributes[attribute].Value;
                }
            }
            catch (Exception ex)
            {
                error = ex.Message;
            }
            return value;
        }

        /// <summary>
        /// Sets the node Attribute value using XPath.
        /// </summary>
        /// <param name="doc">The doc.</param>
        /// <param name="xPath">The x path pattern to the node.</param>
        /// <param name="attribute">The attribute name.</param>
        /// <param name="value">The value.</param>
        /// <param name="error">The error string (if occured).</param>
        public static void SetNodeAttributeValue(XmlDocument doc, String xPath, string attribute, String value, out string error)
        {
            error = string.Empty;
            try
            {                
                XmlNode node = doc.SelectSingleNode(xPath);
                if (node != null)
                {
                    node.Attributes[attribute].Value = value;                    
                }
            }
            catch (Exception ex)
            {
                string.Format("Unable to update certificate finger print in {0}/[{1}\n]", xPath, attribute);
                error += ex.Message;
            }
        }       
    }
}
