using System;
using System.Globalization;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class IntegerValidation : IValidation
	{
		public int Maximum { get; set; }
		public int Minimum { get; set; }


		public IntegerValidation()
		{
			Maximum = Int32.MaxValue;
			Minimum = Int32.MinValue;
		}

		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();

			string msg = "This field must contain integer number";
			if (value != null && value is String && !((string)value).Equals(String.Empty))
			{
				int intValue;
				if (!Int32.TryParse((string)value, NumberStyles.Integer, CultureInfo.CurrentCulture, out intValue))
				{
					result.Success = false;
                    msg += String.Format(" between {0} and {1}.", Minimum, Maximum);
					result.Reasons.Add(msg);
				}
				else if (intValue < Minimum || intValue > Maximum)
				{
					if (Minimum != Int32.MinValue && Maximum != Int32.MaxValue)
					{
						msg += String.Format(" between {0} and {1}", Minimum, Maximum);
					}
					else if (Minimum != Int32.MinValue)
					{
						msg += " greater than " + Minimum;
					}
					else if (Maximum != Int32.MaxValue)
					{
						msg += " less than " + Maximum;
					}

					result.Success = false;
					result.Reasons.Add(msg + ".");
				}
			}

			return result;
		}
	}
}