using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.Interfaces;
using VdcCommon.VdcQueries;
using VdcFrontend;
using System.ComponentModel;
using System.Collections;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmImportDiskListModel : VmDiskListModel
	{
		private bool collapseSnapshots;
		public bool CollapseSnapshots
		{
			get { return collapseSnapshots; }
			set
			{
				if (collapseSnapshots != value)
				{
					collapseSnapshots = value;
					OnCollapseSnapshotsChanged();
					OnPropertyChanged(new PropertyChangedEventArgs("CollapseSnapshots"));
				}
			}
		}

		public int SelectedVMsCount { get; set; }

		private void OnCollapseSnapshotsChanged()
		{
			SetDisksVolumeTypeAvailability();
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			VM vm = (VM)Entity;
			if (vm != null && vm.DiskMap != null)
			{
				List<DiskModel> list = new List<DiskModel>();
				foreach (DiskImage img in vm.DiskMap.Values)
				{
					DiskModel model = new DiskModel();
					model.Name = img.internal_drive_mapping;
					model.Size = new EntityModel { Entity = img.SizeInGigabytes };
					model.VolumeType.SelectedItem = img.volume_type;
					model.VolumeType.SelectedItemChangedEvent.addListener(this);
					model.DiskType = img.disk_type;
					model.VolumeFormat = img.volume_format;
					model.CreationDate = img.creation_date;
					//NOTE: The following code won't pass conversion to Java.
					//model.ActualSize = Convert.ToInt32(img.ActualDiskWithSnapshotsSize);
					list.Add(model);
				}
				Items = list;

			}
			else
			{
				Items = null;
			}

			SetDisksVolumeTypeAvailability();
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(SelectedItemChangedEventDefinition) && sender is ListModel)
			{
				VolumeType_SelectedItemChanged(args);
			}
		}

		void VolumeType_SelectedItemChanged(EventArgs e)
		{
			VM vm = (VM)Entity;
			if (vm != null)
			{
				foreach (object item in Items)
				{
					DiskModel model = (DiskModel)item;

					foreach (KeyValuePair<string, DiskImage> kvp in vm.DiskMap)
					{
						DiskImage disk = kvp.Value;
						ListModel volumeType = model.VolumeType;
						if (disk.internal_drive_mapping == model.Name)
						{
							disk.volume_type = (VolumeType)volumeType.SelectedItem;
							break;
						}
					}
				}
			}
		}

		private void SetDisksVolumeTypeAvailability()
		{
			List<DiskModel> list = (List<DiskModel>)Items;
			if (list != null && list.Count > 0)
			{
				if (SelectedVMsCount == 1)
				{
					if (!CollapseSnapshots)
					{
						foreach (DiskModel a in list)
						{
							a.VolumeType.ChangeProhibitionReasons.Add("Allocation can be modified only when 'Collapse Snapshots' is check");
							a.VolumeType.IsChangable = false;
						}
					}
					else
					{
						foreach (DiskModel a in list)
						{
							a.VolumeType.IsChangable = true;
						}
					}
				}
				else
				{
					foreach (DiskModel a in list)
					{
						a.VolumeType.ChangeProhibitionReasons.Add("Allocation can be modified only when importing a single VM");
						a.VolumeType.IsChangable = false;
					}
				}
			}
		}

		public override void Search()
		{
		}


	}
}
