using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class SnapshotModel : Model
	{
		#region Properties

		public Guid SnapshotId { get; set; }

		private bool isPreviewed;
		public bool IsPreviewed
		{
			get { return isPreviewed; }
			set
			{
				if (isPreviewed != value)
				{
					isPreviewed = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NAME"));
				}
			}
		}

		private bool isCurrent;
		public bool IsCurrent
		{
			get { return isCurrent; }
			set
			{
				if (isCurrent != value)
				{
					isCurrent = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NAME"));
				}
			}
		}

		public EntityModel Description { get; set; }

		/// <summary>
		/// DescriptionValue: A simple getter, for use in the web GUI (it is
		/// impossible to bind values with type FieldModel to an ext:Store).
		/// </summary>
		public string DescriptionValue
		{
			get
			{
				return Description == null ? null : (string)(Description.Entity);
			}
		}

		private DateTime? date;
		public DateTime? Date
		{
			get { return date; }
			set
			{
				if (date == null || date != value)
				{
					date = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Date"));
				}
			}
		}

		private string participantDisks;
		public string ParticipantDisks
		{
			get { return participantDisks; }
			set
			{
				if (participantDisks != value)
				{
					participantDisks = value;
					OnPropertyChanged(new PropertyChangedEventArgs("ParticipantDisks"));
				}
			}
		}

		private IList<EntityModel> disks;
		public IList<EntityModel> Disks
		{
			get { return disks; }
			set
			{
				if (disks != value)
				{
					disks = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Disks"));
				}
			}
		}

		private string apps;
		public string Apps
		{
			get { return apps; }
			set
			{
				if (apps != value)
				{
					apps = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Apps"));
				}
			}
		}

		#endregion

		public SnapshotModel()
		{
			Description = new EntityModel();
		}

		public bool Validate()
		{
			Description.ValidateEntity(new IValidation[] { new NotEmptyValidation() });

			bool isDisksValid = false;
			Message = null;
			if (Disks != null)
			{
				foreach (EntityModel a in Disks)
				{
					if (a.IsSelected)
					{
						isDisksValid = true;
						break;
					}
				}
				if (!isDisksValid)
				{
					Message = "At least one disk must be marked.";
					return false;
				}

				return Description.IsValid;
			}

			return Description.IsValid;
		}
	}
}
