using System;
using System.Collections.ObjectModel;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class BootSequenceModel : ListModel
	{
		#region Commands

		public UICommand MoveItemUpCommand { get; private set; }
		public UICommand MoveItemDownCommand { get; private set; }

		#endregion

		#region Properties

		public new ObservableCollection<EntityModel> Items
		{
			get { return (ObservableCollection<EntityModel>)(base.Items); }
			set { base.Items = value; }
		}

		public EntityModel NetworkOption
		{
			get
			{
				foreach (EntityModel a in Items)
				{
					if ((BootSequence)a.Entity == BootSequence.N)
					{
						return a;
					}
				}

				throw new IndexOutOfRangeException();
			}
		}

		public EntityModel CdromOption
		{
			get
			{
				foreach (EntityModel a in Items)
				{
					if ((BootSequence)a.Entity == BootSequence.D)
					{
						return a;
					}
				}

				throw new IndexOutOfRangeException();
			}
		}


		public BootSequence Sequence
		{
			get
			{
				//string str = Items.Where(a => a.IsChangable)
				//    .Select(a => (BootSequence)a.Entity)
				//    .Aggregate(String.Empty, (a, b) => a += b.ToString());

				string str = String.Empty;
				foreach (EntityModel a in Items)
				{
					if (a.IsChangable)
					{
						BootSequence bs = (BootSequence)a.Entity;
						str += bs.ToString();
					}
				}

				return (BootSequence)Enum.Parse(typeof(BootSequence), str);
			}
		}

		#endregion

		public BootSequenceModel()
		{
			MoveItemUpCommand = new UICommand("MoveItemUp", this);
			MoveItemDownCommand = new UICommand("MoveItemDown", this);

			InitializeItems();

			UpdateActionAvailability();
		}

		public int SelectedItemIndex
		{
			get
			{
				return SelectedItem != null ? Items.IndexOf((EntityModel)SelectedItem) : -1;
			}
		}

		public void MoveItemDown()
		{
			if (SelectedItemIndex < Items.Count - 1)
			{
				Items.Move(SelectedItemIndex, SelectedItemIndex + 1);
			}
		}

		public void MoveItemUp()
		{
			if (SelectedItemIndex > 0)
			{
				Items.Move(SelectedItemIndex, SelectedItemIndex - 1);
			}
		}

		private void InitializeItems()
		{
			ObservableCollection<EntityModel> items = new ObservableCollection<EntityModel>();
			items.Add(
				new EntityModel
				{
					Title = "Hard Disk",
					Entity = BootSequence.C
				});
			items.Add(
				new EntityModel
				{
					Title = "CD-ROM",
					Entity = BootSequence.D
				});
			items.Add(
				new EntityModel
				{
					Title = "Network (PXE)",
					Entity = BootSequence.N
				});

			Items = items;
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == MoveItemUpCommand)
			{
				MoveItemUp();
			}
			else if (command == MoveItemDownCommand)
			{
				MoveItemDown();
			}
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		private void UpdateActionAvailability()
		{
			MoveItemUpCommand.IsExecutionAllowed = SelectedItem != null;
			MoveItemDownCommand.IsExecutionAllowed = SelectedItem != null;
		}
	}
}
