using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.events;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.VdcQueries;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class StorageEventListModel : EventListModel
	{
		#region Properties

		public new storage_domains Entity
		{
			//			get { return base.Entity as storage_domains; }
			get { return (storage_domains)base.Entity; }
			set { base.Entity = value; }
		}

		#endregion

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				SearchCommand.Execute();
			}
			else
			{
				Items = null;
			}
		}

		public override void Search()
		{
			if (Entity != null)
			{
				SearchString = String.Format("events: event_storage={0}", Entity.storage_name);
				base.Search();
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "storage_name")
			{
				SearchCommand.Execute();
			}
		}
	}
}
