using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicommon.validation;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.pools
{
	public class PoolModel : VmModel
	{
		#region Properties

		public ListModel PoolType { get; private set; }
		public EntityModel NumOfDesktops { get; private set; }
		public bool CanDefineVM { get { return IsNew || (int)NumOfDesktops.Entity == 0; } }

		public override bool IsNew
		{
			get
			{
				return base.IsNew;
			}
			set
			{
				IsAddVMMode = value;
				base.IsNew = value;
			}
		}

		//public int OriginalNumberOfDesktops { get; set; }

		private int assignedVms;
		public int AssignedVms
		{
			get { return assignedVms; }
			set
			{
				if (assignedVms != value)
				{
					assignedVms = value;
					OnPropertyChanged(new PropertyChangedEventArgs("AssignedVms"));
				}
			}
		}

		bool isPoolTabValid;
		public bool IsPoolTabValid
		{
			get { return isPoolTabValid; }
			set
			{
				if (isPoolTabValid != value)
				{
					isPoolTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsPoolTabValid"));
				}
			}
		}

		bool isAddVMMode;
		public bool IsAddVMMode
		{
			get { return isAddVMMode; }
			set
			{
				if (isAddVMMode != value)
				{
					isAddVMMode = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsAddVMMode"));
				}
			}
		}

		#endregion

		public PoolModel()
		{
			List<EntityModel> poolTypeItems = new List<EntityModel>();
			EntityModel automaticOption = new EntityModel { Title = "Automatic", Entity = VmPoolType.Automatic };
			poolTypeItems.Add(automaticOption);
			poolTypeItems.Add(new EntityModel { Title = "Manual", Entity = VmPoolType.Manual });

			PoolType = new ListModel();
			PoolType.Items = poolTypeItems;

			NumOfDesktops = new EntityModel { Entity = 1 };

			IsPoolTabValid = true;

			PoolType.SelectedItem = automaticOption;
			OSType.SelectedItem = VmOsType.Unassigned;
		}

		protected override void FillTemplateList(Guid DataCenterId)
		{
			//			var templates = DataProvider.GetTemplateListByDataCenter(DataCenterId).Where(a => (Guid)a.vmt_guid != Guid.Empty);
			List<VmTemplate> templates = new List<VmTemplate>();
			foreach (VmTemplate template in DataProvider.GetTemplateList(DataCenterId))
			{
				if (!template.Id.Equals(Guid.Empty))
				{
					templates.Add(template);
				}
			}
			Template.Items = templates;
			//			Template.Value = templates.FirstOrDefault();
			Template.SelectedItem = Linq.FirstOrDefault(templates);
		}

		//private void DataCenterChanged()
		//{
		//    Clusters = DataProvider.GetClusterList(DataCenter.id);
		//    if (CanDefineVM)
		//    {
		//        Cluster = Clusters.FirstOrDefault();
		//    }

		//    StorageDomains = DataProvider.GetStorageDomainList(DataCenter.id);

		//    Templates = DataProvider.GetTemplateListByDataCenter(DataCenter.id)
		//        .Where(a => a.vmt_guid != Guid.Empty);
		//    if (CanDefineVM)
		//    {
		//        Template = Templates.FirstOrDefault();
		//    }
		//}

		//public void TemplateChanged()
		//{
		//    if (Template == null && !CanDefineVM)
		//    {
		//        return;
		//    }

		//    OSType = Template.os;
		//    NumOfMonitors = Template.num_of_monitors;
		//    Domain = Template.domain;
		//    MemSize = Template.mem_size_mb;
		//    UsbPolicy = Template.usb_policy;
		//    IsAutoSuspend = Template.is_auto_suspend;
		//    if (TimeZones != null)
		//    {
		//        TimeZone = TimeZones.FirstOrDefault(a => a.Key == (String.IsNullOrEmpty(Template.time_zone)
		//            ? DataProvider.GetDefaultTimeZone()
		//            : Template.time_zone)
		//        );
		//    }
		//    var storageDomains = DataProvider.GetStorageDomainListByTemplate(Template.vmt_guid);
		//    StorageDomains = storageDomains;
		//    StorageDomain = storageDomains.FirstOrDefault();
		//}

		//private void OsTypeChanged()
		//{
		//    HasDomain = IsWindowsOsType(OSType);
		//    HasTimeZone = IsWindowsOsType(OSType);
		//}

		internal override bool Validate()
		{
			bool baseValidation = base.Validate();

			IsPoolTabValid = true;
			//Revalidate name field.
			//TODO: Make maximum characters value depend on number of desktops in pool.
			VmOsType os = (VmOsType)OSType.SelectedItem;

			int maxAlowedVms = DataProvider.GetMaxVmsInPool();
			int maxNumOfCharsVmSerialNumber = Convert.ToString(maxAlowedVms).Length + 1;
			int maxAllowedChars_windows = WINDOWS_VM_NAME_MAX_LIMIT - maxNumOfCharsVmSerialNumber;
			int maxAllowedChars_nonWindows = NON_WINDOWS_VM_NAME_MAX_LIMIT - maxNumOfCharsVmSerialNumber;

			string nameExpr = string.Format(@"^[0-9a-zA-Z-_]{{1,{0}}}$", maxAllowedChars_windows);
			string nameMsg = string.Format(
				"Name must contain only alphanumeric characters. Maximum length: {0}.",
				maxAllowedChars_windows);

			if (!DataProvider.IsWindowsOsType(os))
			{
				nameExpr = string.Format(@"^[-\w]{{1,{0}}}$", maxAllowedChars_nonWindows);
				nameMsg = string.Format(
					"Name cannot contain special characters. Maximum length: {0}.",
					maxAllowedChars_nonWindows);
			}

			Name.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(),
					new RegexValidation { Expression = nameExpr, Message = nameMsg }
				});

			NumOfDesktops.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(),
					new IntegerValidation
					{
						Minimum = 1, 
						Maximum = IsNew ? maxAlowedVms : maxAlowedVms - AssignedVms
					}
				});

			IsGeneralTabValid = IsGeneralTabValid
				&& Name.IsValid
				&& NumOfDesktops.IsValid;

			IsPoolTabValid = true;

			return baseValidation &&
				   Name.IsValid &&
				   NumOfDesktops.IsValid;
		}
	}
}
