using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using System.Windows.Threading;
using System.Collections;
using org.ovirt.engine.ui.uicompat;
using SearchBackend;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.autocomplete
{
	public class SearchSuggestModel : SearchableListModel, ITaskTarget
	{
		private readonly ISyntaxChecker syntaxChecker;

		#region Properties

		public new IList Items
		{
			get { return (IList)base.Items; }
			set { base.Items = value; }
		}

		public string Prefix { get; set; }

		/// <summary>
		/// Gets or sets an array specifying which options will be filtered out from suggestion.
		/// </summary>
		public string[] Filter { get; set; }

		#endregion


		public SearchSuggestModel()
		{
			Items = new ObservableCollection<object>();

			syntaxChecker = SyntaxCheckerFactory.CreateUISyntaxChecker(DataProvider.GetAuthenticationMethod());
		}

		protected override void SearchStringChanged()
		{
			base.SearchStringChanged();
			SearchCommand.Execute();
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			Task.Create(this, null).InvokeUIThread();
		}

		public void UpdateOptionsAsync(string search)
		{
			Items.Clear();

			SyntaxContainer syntax = syntaxChecker.getCompletion(search);

			int lastHandledIndex = syntax.getLastHandledIndex();
			string pf = search.Substring(0, lastHandledIndex);
			string notHandled = search.Substring(lastHandledIndex);

			if (syntax.Error == SyntaxError.NO_ERROR)
			{
				string[] items = syntax.getCompletionArray();

				foreach (string item in items)
				{
					//Apply filter.
					if (Filter != null)
					{
						bool skipItem = false;
						foreach (string value in Filter)
						{
							if (value.ToLower() == item.ToLower())
							{
								skipItem = true;
								break;
							}
						}

						if (skipItem)
						{
							continue;
						}
					}


					string space = "";
					if ((pf.Length > 0) && (pf.Substring(pf.Length - 1, 1) != ".") && (item != "."))
					{
						space = " ";
					}

					//Patch: monitor-desktop
					if (!item.Trim().ToLower().StartsWith("monitor-desktop"))
					{
						List<SuggestItemPartModel> parts =
							new List<SuggestItemPartModel>
							{
								new SuggestItemPartModel
								{
									PartString = pf.TrimEnd(),
									PartType = SuggestItemPartType.Valid
								},
								new SuggestItemPartModel
								{
									PartString = space + item.Trim(),
									PartType = SuggestItemPartType.New
								}
							};

						Items.Add(parts);
					}
				}
			}
			else
			{
				List<SuggestItemPartModel> parts =
					new List<SuggestItemPartModel>
					{
						new SuggestItemPartModel
						{
							PartString = pf,
							PartType = SuggestItemPartType.Valid
						},
						new SuggestItemPartModel
						{
							PartString = notHandled,
							PartType = SuggestItemPartType.Erroneous
						}
					};

				Items.Add(parts);
			}
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();

			IList selectedItem = (IList)SelectedItem;
			if (selectedItem != null)
			{
				//SearchString = String.Join(String.Empty,
				//	selectedItem
				//		.Cast<SuggestItemPartModel>()
				//		.Select(a => a.PartString)
				//		.ToArray()
				//	);
				List<string> items = new List<string>();
				foreach (object item in selectedItem)
				{
					SuggestItemPartModel i = (SuggestItemPartModel)item;
					items.Add(i.PartString);
				}

				string searchString = String.Join(String.Empty, items.ToArray());
				//If there prefix exist, don't transfer it back as a part of search string.
				if (Prefix != null)
				{
					searchString = searchString.Substring(Prefix.Length);
				}

				SearchString = searchString;
			}
		}

		public void run(TaskContext context)
		{
			UpdateOptionsAsync(Prefix + SearchString);
		}
	}
}
