using System.Collections.Generic;
using System.Text;
using SearchBackend;

namespace SearchBackend
{
    public class SearchObjectsBaseAutoCompleter : BaseAutoCompleter
    {
        public override string changeCaseDisplay(string text)
        {
            return text.Substring(0, 1).ToUpper() + text.Remove(0, 1).ToLower();
        }
    }

    public class SearchObjectAutoCompleter : SearchObjectsBaseAutoCompleter
    {
        private readonly Dictionary<string, string[]> mJoinDictionary = new Dictionary<string, string[]>();
        
        public SearchObjectAutoCompleter(bool isDesktopsAllowed) 
        {
           
            mVerbs.Add(SearchObjects.VM_PLU_OBJ_NAME, SearchObjects.VM_PLU_OBJ_NAME);
            if (isDesktopsAllowed)
            {
                mVerbs.Add(SearchObjects.VDC_POOL_PLU_OBJ_NAME, SearchObjects.VDC_POOL_PLU_OBJ_NAME);
            }
            mVerbs.Add(SearchObjects.VDS_PLU_OBJ_NAME, SearchObjects.VDS_PLU_OBJ_NAME);
            mVerbs.Add(SearchObjects.TEMPLATE_PLU_OBJ_NAME, SearchObjects.TEMPLATE_PLU_OBJ_NAME);
            mVerbs.Add(SearchObjects.AUDIT_PLU_OBJ_NAME, SearchObjects.AUDIT_PLU_OBJ_NAME);
            mVerbs.Add(SearchObjects.VDC_USER_PLU_OBJ_NAME, SearchObjects.VDC_USER_PLU_OBJ_NAME);
            mVerbs.Add(SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME, SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME);
            mVerbs.Add(SearchObjects.VDC_STORAGE_POOL_OBJ_NAME, SearchObjects.VDC_STORAGE_POOL_OBJ_NAME);
            mVerbs.Add(SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME);
            
            buildCompletions();
            mVerbs.Add(SearchObjects.VM_OBJ_NAME, SearchObjects.VM_OBJ_NAME);
            if (isDesktopsAllowed)
            {
                mVerbs.Add(SearchObjects.VDC_POOL_OBJ_NAME, SearchObjects.VDC_POOL_OBJ_NAME);
            }
            mVerbs.Add(SearchObjects.VDS_OBJ_NAME, SearchObjects.VDS_OBJ_NAME);
            mVerbs.Add(SearchObjects.TEMPLATE_OBJ_NAME, SearchObjects.TEMPLATE_OBJ_NAME);
            mVerbs.Add(SearchObjects.AUDIT_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME);
            mVerbs.Add(SearchObjects.VDC_USER_OBJ_NAME, SearchObjects.VDC_USER_OBJ_NAME);
            mVerbs.Add(SearchObjects.VDC_CLUSTER_OBJ_NAME, SearchObjects.VDC_CLUSTER_OBJ_NAME);

            //vms - vds
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VM_OBJ_NAME, SearchObjects.VDS_OBJ_NAME),new[] { "run_on_vds", "vds_id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VM_OBJ_NAME, SearchObjects.VDS_OBJ_NAME), new[] { "vds_id", "run_on_vds" });
            
            //vms - vmt
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VM_OBJ_NAME, SearchObjects.TEMPLATE_OBJ_NAME), new[] { "vmt_guid", "vmt_guid" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VM_OBJ_NAME, SearchObjects.TEMPLATE_OBJ_NAME), new[] { "vmt_guid", "vmt_guid" });
            
            //vms - users
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VM_OBJ_NAME, SearchObjects.VDC_USER_OBJ_NAME), new[] { "vm_guid", "vm_guid" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VM_OBJ_NAME, SearchObjects.VDC_USER_OBJ_NAME), new[] { "vm_guid", "vm_guid" });
            
            //vms - audit
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VM_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new[] { "vm_guid", "vm_id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VM_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new[] { "vm_id", "vm_guid" });

            // vms - storage domain
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VM_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "storage_id", "id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VM_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "id", "storage_id" });

            // templates - storage domain
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.TEMPLATE_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "storage_id", "id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.TEMPLATE_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "id", "storage_id" });

            // vds - storage domain
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDS_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "storage_id", "id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDS_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "id", "storage_id" });

            //vds - audit
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDS_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new[] { "vds_id", "vds_id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDS_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new[] { "vds_id", "vds_id" });

            //cluster - storage domain
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDC_CLUSTER_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "storage_id", "id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDC_CLUSTER_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new[] { "id", "storage_id" });
            
            //users - audit
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDC_USER_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new[] { "user_id", "user_id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDC_USER_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new[] { "user_id", "user_id" });
                 
            //Datacenter(Storage_pool) - Cluster(vds group)
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDC_STORAGE_POOL_OBJ_NAME, SearchObjects.VDC_CLUSTER_OBJ_NAME), new[] { "id", "storage_pool_id"});
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDC_STORAGE_POOL_OBJ_NAME, SearchObjects.VDC_CLUSTER_OBJ_NAME), new[] { "storage_pool_id", "id"});

            // Datacenter(Storage_pool) - Storage Domain
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDC_STORAGE_POOL_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new [] { "id", "storage_pool_id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDC_STORAGE_POOL_OBJ_NAME, SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME), new [] { "storage_pool_id", "id" });

            // Datacenter(Storage_pool) - Storage Domain
            mJoinDictionary.Add(string.Format("{0}.{1}", SearchObjects.VDC_CLUSTER_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new [] { "vds_group_id", "vds_group_id" });
            mJoinDictionary.Add(string.Format("{1}.{0}", SearchObjects.VDC_CLUSTER_OBJ_NAME, SearchObjects.AUDIT_OBJ_NAME), new [] { "vds_group_id", "vds_group_id" });
 
            
        }

        public IAutoCompleter getCrossRefAutoCompleter(string obj)
        {
            switch (obj)
            {
                case SearchObjects.AUDIT_OBJ_NAME:
                case SearchObjects.AUDIT_PLU_OBJ_NAME:
                    return new AuditCrossRefAutoCompleter();

                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    return new TemplateCrossRefAutoCompleter();

                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    return new UserCrossRefAutoCompleter();

                case SearchObjects.VDS_OBJ_NAME:
                case SearchObjects.VDS_PLU_OBJ_NAME:
                    return new VdsCrossRefAutoCompleter();

                case SearchObjects.VM_OBJ_NAME:
                case SearchObjects.VM_PLU_OBJ_NAME:
                    return new VmCrossRefAutoCompleter();

                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    return new ClusterCrossRefAutoCompleter();

                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                    return new StoragePoolCrossRefAutoCompleter();

                case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
                    return new StorageDomainCrossRefAutoCompleter();

                case SearchObjects.VDC_POOL_OBJ_NAME:
                case SearchObjects.VDC_POOL_PLU_OBJ_NAME:
                default:
                    return null;
            }
            
        }


        public bool isCrossReferece(string text, string obj)
        {
            IAutoCompleter completer = getCrossRefAutoCompleter(obj);
            bool retval = false;
            if(completer != null)
            {
                retval = completer.validate(text);
            }
            return retval;
        }


        public string getInnerJoin(string searchObj, string crossRefObj)
        {
            string[] JoinKey = mJoinDictionary[string.Format("{0}.{1}", searchObj, crossRefObj)];
            string crossRefTable = getRelatedTableName(crossRefObj);   
            string searchObjTable = getRelatedTableName(searchObj);
            
            return string.Format(" LEFT OUTER JOIN {2} ON {0}.{1}={2}.{3} ", searchObjTable, JoinKey[0], crossRefTable, JoinKey[1]);
        }

        public IConditionFieldAutoCompleter getFieldAutoCompleter(string obj)
        {
            IConditionFieldAutoCompleter retval = null;
            switch (obj)
            {
                case SearchObjects.VDS_OBJ_NAME:
                case SearchObjects.VDS_PLU_OBJ_NAME:
                    retval = new VdsConditionFieldAutoCompleter();
                    break;
                case SearchObjects.VM_OBJ_NAME:
                case SearchObjects.VM_PLU_OBJ_NAME:
                    retval = new VmConditionFieldAutoCompleter();
                    break;
                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    retval = new VmTemplateConditionFieldAutoCompleter();
                    break;
                case SearchObjects.AUDIT_OBJ_NAME:
                case SearchObjects.AUDIT_PLU_OBJ_NAME:
                    retval = new AuditLogConditionFieldAutoCompleter();
                    break;
                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    retval = new VdcUserConditionFieldAutoCompleter();
                    break;
                case SearchObjects.VDC_POOL_OBJ_NAME:
                case SearchObjects.VDC_POOL_PLU_OBJ_NAME:
                    retval = new PoolConditionFieldAutoCompleter();
                    break;
                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    retval = new 
                        ClusterConditionFieldAutoCompleter();
                    break;
                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                    retval = new StoragePoolFieldAutoCompleter();
                    break;
                case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
                    retval = new StorageDomainFieldAutoCompleter();
                    break;

                    
                default:
                    break;
            }
            return retval;
        }

        public string getRelatedTableNameWithOutTags(string obj)
        {
            string retval;
            switch (obj)
            {
                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    retval = "vdc_users";
                    break;

				case SearchObjects.VM_OBJ_NAME:
				case SearchObjects.VM_PLU_OBJ_NAME:
					retval = "vms";
					break;

                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    retval = "vm_templates_view";
                    break;

				case SearchObjects.VDS_OBJ_NAME:
				case SearchObjects.VDS_PLU_OBJ_NAME:
					retval = "vds";
					break;

                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    retval = "vds_groups";
                    break;

                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                    retval = "storage_pool";
                    break;

				case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
					retval = "storage_domains_without_storage_pools";
					break;

                default:
                    retval = getRelatedTableName(obj);
                    break;
            }
            return retval;
        }

        public string getRelatedTableName(string obj)
        {
            string retval = null;
            switch (obj)
            {
                case SearchObjects.VDS_OBJ_NAME:
                case SearchObjects.VDS_PLU_OBJ_NAME:
                    retval = "vds_with_tags";
                    break;
                case SearchObjects.VM_OBJ_NAME:
                case SearchObjects.VM_PLU_OBJ_NAME:
					retval = "vms_with_tags";
                    break;
                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    retval = "vm_templates_storage_domain";
                    break;
                case SearchObjects.AUDIT_OBJ_NAME:
                case SearchObjects.AUDIT_PLU_OBJ_NAME:
                    retval = "audit_log";
                    break;
                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    retval = "vdc_users_with_tags";
                    break;
                case SearchObjects.VDC_POOL_OBJ_NAME:
                case SearchObjects.VDC_POOL_PLU_OBJ_NAME:
                    retval = "vm_pools_full_view";
                    break;
                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    retval = "vds_groups_storage_domain";
                    break;
                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                    retval = "storage_pool";
                    break;
                case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
                    retval = "storage_domains";
                    break;
                    
                default:
                    break;
            }
            return retval;
        }
        
        public string getPrimeryKeyName(string obj)
        {
            string retval = null;
            switch (obj)
            {
                case SearchObjects.VDS_OBJ_NAME:
                case SearchObjects.VDS_PLU_OBJ_NAME:
                    retval = "vds_id";
                    break;
                case SearchObjects.VM_OBJ_NAME:
                case SearchObjects.VM_PLU_OBJ_NAME:
                    retval = "vm_guid";
                    break;
                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    retval = "vmt_guid";
                    break;
                case SearchObjects.AUDIT_OBJ_NAME:
                case SearchObjects.AUDIT_PLU_OBJ_NAME:
                    retval = "audit_log_id";
                    break;
                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    retval = "user_id";
                    break;
                case SearchObjects.VDC_POOL_OBJ_NAME:
                case SearchObjects.VDC_POOL_PLU_OBJ_NAME:
                    retval = "vm_pool_id";
                    break;
                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    retval = "vds_group_id";
                    break;
                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                    retval = "id";
                    break;
                case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
                    retval = "id";
                    break;

                default:
                    break;
            }
            return retval;
        }


        public IAutoCompleter getFieldRelationshipAutoCompleter(string obj, string fieldName)
        {
            IAutoCompleter retval = null;
            IConditionFieldAutoCompleter curConditionFieldAC = getFieldAutoCompleter(obj);
            if (curConditionFieldAC != null)
            {
                retval = curConditionFieldAC.getFieldRelationshipAutoCompleter(fieldName);
            }
            return retval;
        }


        public IAutoCompleter getObjectRelationshipAutoCompleter(string obj)
        {
            IAutoCompleter retval;
            retval = new StringConditionRelationAutoCompleter();
            return retval;
        }

        public IConditionValueAutoCompleter getFieldValueAutoCompleter(string obj, string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            IConditionFieldAutoCompleter curConditionFieldAC = getFieldAutoCompleter(obj);
            if (curConditionFieldAC != null)
            {
                retval = curConditionFieldAC.getFieldValueAutoCompleter(fieldName);
            }
            return retval;
        }

        public string getDefaultSort(string obj)
        {
            string retval = string.Empty;
            switch (obj)
            {
                case SearchObjects.VDS_OBJ_NAME:
                case SearchObjects.VDS_PLU_OBJ_NAME:
                    retval = "vds_name ASC ";
                    break;
                case SearchObjects.VM_OBJ_NAME:
                case SearchObjects.VM_PLU_OBJ_NAME:
                    retval = "vm_name ASC ";
                    break;
                case SearchObjects.AUDIT_OBJ_NAME:
                case SearchObjects.AUDIT_PLU_OBJ_NAME:
                    retval = "audit_log_id DESC ";
                    break;
                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    retval = "name ASC ";
                    break;
                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    retval = "name ASC ";
                    break;
                case SearchObjects.VDC_POOL_OBJ_NAME:
                case SearchObjects.VDC_POOL_PLU_OBJ_NAME:
                    retval = "vm_pool_name ASC ";
                    break;
                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                    retval = "name ASC ";
                    break;
                case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
                    retval = "storage_name ASC ";
                    break;
                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    retval = "name ASC ";
                    break;
                default:
                    break;
            }
            return retval;
        }
    }
}
