using System;
using System.Collections.Generic;
using System.Text;
using VdcUtils;

namespace SearchBackend
{
    class EnumValueAutoCompleter : BaseAutoCompleter, IConditionValueAutoCompleter
    {
        readonly Dictionary<string, int> mEnumValues = new Dictionary<string, int>();
        public EnumValueAutoCompleter(Type enumerationType)
        {
            
           foreach(int val in Enum.GetValues(enumerationType))
           {
               string ValName = Enum.GetName(enumerationType, val).ToUpper();
               try
               {
                   mEnumValues.Add(ValName, val);
                   mVerbs.Add(ValName, ValName);
               }
               catch(Exception e)
               {
                   QLogger.Instance.ErrorFormat("EnumValueAutoCompleter. Failed to add {0}.Exception :{1} ",ValName,e);
               }
               
           }
           buildCompletions();
        }

        public string convertFieldEnumValueToActualValue(string fieldValue)
        {
            string retval = string.Empty;
            if (mEnumValues.ContainsKey(fieldValue.ToUpper()))
            {
                retval = mEnumValues[fieldValue.ToUpper()].ToString();
            }
            return retval;
        }

    }
    
    class BitValueAutoCompleter : BaseAutoCompleter, IConditionValueAutoCompleter
    {
        readonly Dictionary<string, int> mBitValues = new Dictionary<string, int>();
        public BitValueAutoCompleter()
        {
            mBitValues.Add("TRUE", 1);
            mVerbs.Add("TRUE", "TRUE");
            mBitValues.Add("FALSE", 0);
            mVerbs.Add("FALSE", "FALSE");
            buildCompletions();
        }

        public string convertFieldEnumValueToActualValue(string fieldValue)
        {
            string retval = string.Empty;
            if (mBitValues.ContainsKey(fieldValue.ToUpper()))
            {
                retval = mBitValues[fieldValue.ToUpper()].ToString();
            }
            return retval;
        }

    }
   
}
