﻿using System;
using System.Runtime.Serialization;

namespace VdcCommon.BusinessEntities
{
    #region IsVmWithSameNameExistParameters
    
    public partial class IsVmWithSameNameExistParameters : VdcQueryParametersBase
    {
        public IsVmWithSameNameExistParameters() { }
        public IsVmWithSameNameExistParameters(string vmName)
        {
            VmName = vmName;
        }
        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    #endregion IsVmWithSameNameExistParameters

    #region GetVmByVmIdParameters
    
    public partial class GetVmByVmIdParameters : VdcQueryParametersBase
    {
        public GetVmByVmIdParameters() { }

        public GetVmByVmIdParameters(Guid id)
        {
            Id = id;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            switch (queryType)
            {
                case(VdcQueryType.GetVmByVmId):
                    return RegisterableQueryReturnDataType.IQUERYABLE;
                case(VdcQueryType.GetVmInterfacesByVmId):
                    return RegisterableQueryReturnDataType.LIST_IQUERYABLE;
                default:
                    return RegisterableQueryReturnDataType.UNDEFINED;
            }
        }
    }
    #endregion GetVmByVmIdParameters

    #region GetVmsRunningOnVDSParameters
    
    public partial class GetVmsRunningOnVDSParameters : VdcQueryParametersBase
    {
        public GetVmsRunningOnVDSParameters() { }

        public GetVmsRunningOnVDSParameters(Guid id)
        {
            Id = id;
        }
    }
    #endregion GetVmsRunningOnVDSParameters
    
    #region GetVmsRunningOnVDSCountParameters
    
    public partial class GetVmsRunningOnVDSCountParameters : VdcQueryParametersBase
    {
        public GetVmsRunningOnVDSCountParameters() { }

        public GetVmsRunningOnVDSCountParameters(Guid id)
        {
            Id = id;
        }
    }
    #endregion GetVmsRunningOnVDSCountParameters
    
    #region GetAllVmSnapshotsParameters
    
    public partial class GetAllVmSnapshotsParameters : VdcQueryParametersBase
    {
        public GetAllVmSnapshotsParameters() { }
        public GetAllVmSnapshotsParameters(Guid id)
        {
            Id = id;
        }
    }
    #endregion GetAllVmSnapshotsParameters

	#region GetDedicatedVmParameters
	
    public partial class GetDedicatedVmParameters : VdcQueryParametersBase
	{
        public GetDedicatedVmParameters() { }

        public GetDedicatedVmParameters(Guid id)
		{
			Id = id;
		}

        
	}
	#endregion GetDedicatedVmParameters



}
