﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using VdcCommon.BusinessEntities;
//using VdcCommon.BusinessEntities.Business_Entities;
using VdcCommon.VdcAction;

namespace VdcCommon.BusinessEntities
{
	[DataContract]
	[KnownType(typeof(VM))]
	[KnownType(typeof(VdsIdVDSCommandParametersBase))]
	[KnownType(typeof(ActivateVdsVDSCommandParameters))]
	[KnownType(typeof(AddVdsVDSCommandParameters))]
	[KnownType(typeof(RemoveVdsVDSCommandParameters))]
	[KnownType(typeof(CreateVmVDSCommandParameters))]
	[KnownType(typeof(VdsAndVmIDVDSParametersBase))]
	[KnownType(typeof(DestroyVmVDSCommandParameters))]
	[KnownType(typeof(PauseVDSCommandParameters))]
	[KnownType(typeof(HibernateVDSCommandParameters))]
	[KnownType(typeof(ResumeVDSCommandParameters))]
	[KnownType(typeof(MigrateVDSCommandParameters))]
	[KnownType(typeof(ChangeDiskVDSCommandParameters))]
	[KnownType(typeof(VmLogonVDSCommandParameters))]
	[KnownType(typeof(VmLogoffVDSCommandParameters))]
	[KnownType(typeof(VmLockVDSCommandParameters))]
	[KnownType(typeof(VmMonitorCommandVDSCommandParameters))]
	[KnownType(typeof(SetVmTicketVDSCommandParameters))]
	[KnownType(typeof(SetVdsStatusVDSCommandParameters))]
	[KnownType(typeof(SetVmStatusVDSCommandParameters))]
	[KnownType(typeof(FailedToRunVmVDSCommandParameters))]
	[KnownType(typeof(IsVmDuringInitiatingVDSCommandParameters))]
	[KnownType(typeof(CreateImageVDSCommandParameters))]
	[KnownType(typeof(ImageIdVDSCommandParametersBase))]
	[KnownType(typeof(DestroyImageVDSCommandParameters))]
	[KnownType(typeof(GetImageInfoVDSCommandParameters))]
	[KnownType(typeof(CopyImageVDSCommandParameters))]
	[KnownType(typeof(CreateSnapshotVDSCommandParameters))]
	[KnownType(typeof(MergeSnapshotsVDSCommandParameters))]
	[KnownType(typeof(SetImageDescriptionVDSCommandParameters))]
	[KnownType(typeof(SetImageLegalityVDSCommandParameters))]
	[KnownType(typeof(ResetIrsVDSCommandParameters))]
	[KnownType(typeof(GetImportCandidatesVDSCommandParameters))]
	[KnownType(typeof(GetCandidateInfoVDSCommandParameters))]
	[KnownType(typeof(ImportCandidateVDSCommandParameters))]
	[KnownType(typeof(ExportCandidateVDSCommandParameters))]
	[KnownType(typeof(StartSpiceVDSCommandParameters))]
	[KnownType(typeof(RunVmHyperChannelCommandVDSCommandParameters))]
	[KnownType(typeof(ShutdownVdsVDSCommandParameters))]
	[KnownType(typeof(IrsBaseVDSCommandParameters))]
	[KnownType(typeof(UpdateVdsVMsClearedVDSCommandParameters))]
	[KnownType(typeof(NetworkVdsmVDSCommandParameters))]
	[KnownType(typeof(string[]))]
	[KnownType(typeof(ConnectStorageServerVDSCommandParameters))]
	[KnownType(typeof(GetStorageConnectionsListVDSCommandParameters))]
	[KnownType(typeof(ValidateStorageDomainVDSCommandParameters))]
	[KnownType(typeof(CreateStorageDomainVDSCommandParameters))]
	[KnownType(typeof(ActivateStorageDomainVDSCommandParameters))]
	[KnownType(typeof(DeactivateStorageDomainVDSCommandParameters))]
	[KnownType(typeof(DetachStorageDomainVDSCommandParameters))]
	[KnownType(typeof(AttachStorageDomainVDSCommandParameters))]
	[KnownType(typeof(FormatStorageDomainVDSCommandParameters))]
	[KnownType(typeof(SetStorageDomainDescriptionVDSCommandParameters))]
	[KnownType(typeof(GetStorageDomainInfoVDSCommandParameters))]
	[KnownType(typeof(GetStorageDomainStatsVDSCommandParameters))]
	[KnownType(typeof(GetStorageDomainsListVDSCommandParameters))]
	[KnownType(typeof(CreateStoragePoolVDSCommandParameters))]
	[KnownType(typeof(SetStoragePoolDescriptionVDSCommandParameters))]
	[KnownType(typeof(ConnectStoragePoolVDSCommandParameters))]
	[KnownType(typeof(DisconnectStoragePoolVDSCommandParameters))]
	[KnownType(typeof(GetStoragePoolInfoVDSCommandParameters))]
	[KnownType(typeof(DeleteImageGroupVDSCommandParameters))]
	[KnownType(typeof(MoveImageGroupVDSCommandParameters))]
	[KnownType(typeof(GetImageDomainsListVDSCommandParameters))]
	[KnownType(typeof(CreateVGVDSCommandParameters))]
	[KnownType(typeof(RemoveVGVDSCommandParameters))]
	[KnownType(typeof(GetVGInfoVDSCommandParameters))]
	[KnownType(typeof(GetDeviceInfoVDSCommandParameters))]
	[KnownType(typeof(SetMaxHostsVDSCommandParameters))]
	[KnownType(typeof(DiscoverSendTargetsVDSCommandParameters))]
	[KnownType(typeof(RefreshStoragePoolVDSCommandParameters))]
	[KnownType(typeof(SpmStartVDSCommandParameters))]
	[KnownType(typeof(SpmStopVDSCommandParameters))]
	[KnownType(typeof(SpmStatusVDSCommandParameters))]
	[KnownType(typeof(FenceSpmStorageVDSCommandParameters))]
	[KnownType(typeof(HSMTaskGuidBaseVDSCommandParameters))]
	[KnownType(typeof(SPMTaskGuidBaseVDSCommandParameters))]
	[KnownType(typeof(UpdateVMVDSCommandParameters))]
	[KnownType(typeof(RemoveVMVDSCommandParameters))]
    [KnownType(typeof(FenceVdsVDSCommandParameters))]
    [KnownType(typeof(UpdateVmDynamicDataVDSCommandParameters))]
	[KnownType(typeof(UpdateVdsDynamicDataVDSCommandParameters))]
	[KnownType(typeof(GetVmsInfoVDSCommandParameters))]
	[KnownType(typeof(GetDeviceListVDSCommandParameters))]
	[KnownType(typeof(ExtendStorageDomainVDSCommandParameters))]
	public class VDSParametersBase
	{
        [DataMember]
        private bool _runAsync = true;

        public bool RunAsync
        {
            get
            {
                return _runAsync;
            }
            set
            {
                _runAsync = value;
            }
        }
	}

	[DataContract]
	public class VdsIdVDSCommandParametersBase : VDSParametersBase
	{
		public VdsIdVDSCommandParametersBase(int vdsId)
		{
			_vdsId = vdsId;
		}

		[DataMember]
		private readonly int _vdsId;

		public int VdsId
		{
			get { return _vdsId; }
		}
	}
    [DataContract]
    public class VdsIdAndVdsVDSCommandParametersBase : VdsIdVDSCommandParametersBase
    {
        public VDS Vds { get; set; }
        public VdsIdAndVdsVDSCommandParametersBase(VDS vds) : base(vds.vds_id)
        {
            Vds = vds;
        }
        public VdsIdAndVdsVDSCommandParametersBase(int vdsId) : base(vdsId)
        {
        }
    }
	[DataContract]
	public class ActivateVdsVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public ActivateVdsVDSCommandParameters(int vdsId)
			: base(vdsId)
		{
		}
	}
	[DataContract]
	public class AddVdsVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public AddVdsVDSCommandParameters(int vdsId)
			: base(vdsId)
		{
		}
	}
	[DataContract]
	public class RemoveVdsVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public RemoveVdsVDSCommandParameters(int vdsId)
			: base(vdsId)
		{
		}
	}
	[DataContract]
	public class CreateVmVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		public CreateVmVDSCommandParameters(int vdsId, VM vm)
			: base(vdsId, vm.vm_guid)
		{
			_vm = vm;
		}

		[DataMember]
		private readonly VM _vm;

		public VM Vm
		{
			get { return _vm; }
		}
	}
	[DataContract]
	public class VdsAndVmIDVDSParametersBase : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly Guid _vmId;

		public VdsAndVmIDVDSParametersBase(int vdsId, Guid vmId)
			: base(vdsId)
		{
			_vmId = vmId;
		}

		public Guid VmId
		{
			get { return _vmId; }
		}
	}
	[DataContract]
	public class DestroyVmVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		public DestroyVmVDSCommandParameters(int vdsId, Guid vmId, bool force, bool gracefully, int secondsToWait)
			: base(vdsId, vmId)
		{
			_force = force;
			_gracefully = gracefully;
			_secondsToWait = secondsToWait;
		}

		[DataMember]
		private readonly bool _force;
		[DataMember]
		private readonly bool _gracefully;
		[DataMember]
		private readonly int _secondsToWait;

		public bool Force
		{
			get { return _force; }
		}
		public int SecondsToWait
		{
			get { return _secondsToWait; }
		}
		public bool Gracefully
		{
			get { return _gracefully; }
		}
	}

    [DataContract]
    public class FenceVdsVDSCommandParameters : VdsIdVDSCommandParametersBase
    {
        public FenceVdsVDSCommandParameters(int vdsId, int targetVdsId, string ip, string port, string type, string user, string password,  string options, FenceActionType action)
            : base(vdsId)
        {
            _targetVdsId = targetVdsId;
            _ip = ip;
            _port = port;
            _type = type;
            _user = user;
            _password = password;
            _action = action;
            _options = options;
        }

        [DataMember]
        private readonly int _targetVdsId;
        [DataMember]
        private readonly string _ip;
        [DataMember]
        private readonly string _port;
        [DataMember]
        private readonly string _type;
        [DataMember]
        private readonly string _user;
        [DataMember]
        private readonly string _password;
        [DataMember]
        private readonly string _options = string.Empty;
        [DataMember]
        private readonly FenceActionType _action;

        public int TargetVdsID
        {
            get { return _targetVdsId; }
        }
        public string Ip
        {
            get { return _ip; }
        }
        public string Port
        {
            get { return _port; }
        }
        public string Type
        {
            get { return _type; }
        }
        public string User
        {
            get { return _user; }
        }
        public string Password
        {
            get { return _password; }
        }
        public string Options
        {
            get { return _options; }
        }
        public FenceActionType Action
        {
            get { return _action; }
        }
    }

	[DataContract]
	public class PauseVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		public PauseVDSCommandParameters(int vdsId, Guid vmId)
			: base(vdsId, vmId)
		{
		}
	}
	[DataContract]
	public class HibernateVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		public HibernateVDSCommandParameters(int vdsId, Guid vmId, string hibernationVolHandle)
			: base(vdsId, vmId)
		{
			HibernationVolHandle = hibernationVolHandle;
		}
		public string HibernationVolHandle
		{
			get;
			private set;
		}
	}
	[DataContract]
	public class ResumeVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		public ResumeVDSCommandParameters(int vdsId, Guid vmId)
			: base(vdsId, vmId)
		{
		}
	}
	[DataContract]
	public class MigrateVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly string _srcHost;
		[DataMember]
		private readonly int _dstVdsId;
		[DataMember]
		private readonly string _dstHost;
		[DataMember]
		private readonly MigrationMethod _migrationMethod;

		public MigrateVDSCommandParameters(int vdsId, Guid vmId, string srcHost, int dstVdsId, string dstHost, MigrationMethod migrationMethod)
			: base(vdsId, vmId)
		{
			_srcHost = srcHost;
			_dstVdsId = dstVdsId;
			_dstHost = dstHost;
			_migrationMethod = migrationMethod;
		}

		public string SrcHost
		{
			get
			{
				return _srcHost;
			}
		}
		public int DstVdsId
		{
			get
			{
				return _dstVdsId;
			}
		}
		public string DstHost
		{
			get
			{
				return _dstHost;
			}
		}
		public MigrationMethod MigrationMethod
		{
			get
			{
				return _migrationMethod;
			}
		}
	}
	[DataContract]
	public class ChangeDiskVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly string _diskPath;

		public ChangeDiskVDSCommandParameters(int vdsId, Guid vmId, string diskPath)
			: base(vdsId, vmId)
		{
			_diskPath = diskPath;
		}

		public string DiskPath
		{
			get
			{
				return _diskPath;
			}
		}
	}
	[DataContract]
	public class VmLogonVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly string _domain;
		[DataMember]
		private readonly string _password;
		[DataMember]
		private readonly string _userName;

		public VmLogonVDSCommandParameters(int vdsId, Guid vmId, string domain, string userName, string password)
			: base(vdsId, vmId)
		{
			_domain = domain;
			_password = password;
			_userName = userName;
		}

		public string Domain
		{
			get
			{
				return _domain;
			}
		}
		public string Password
		{
			get
			{
				return _password;
			}
		}
		public string UserName
		{
			get
			{
				return _userName;
			}
		}
	}
	[DataContract]
	public class VmLogoffVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly bool _force;

		public VmLogoffVDSCommandParameters(int vdsId, Guid vmId, bool force)
			: base(vdsId, vmId)
		{
			_force = force;
		}

		public bool Force
		{
			get
			{
				return _force;
			}
		}
	}
	[DataContract]
	public class VmLockVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		public VmLockVDSCommandParameters(int vdsId, Guid vmId)
			: base(vdsId, vmId)
		{
		}
	}
	[DataContract]
	public class VmMonitorCommandVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly string _command;

		public VmMonitorCommandVDSCommandParameters(int vdsId, Guid vmId, string command)
			: base(vdsId, vmId)
		{
		    _command = command;
		}

		public string Command
		{
			get
			{
				return _command;
			}
		}
	}
	[DataContract]
	public class SetVmTicketVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly string _ticket;
		[DataMember]
		private readonly int _validTime;

		public SetVmTicketVDSCommandParameters(int vdsId, Guid vmId, string ticket, int validTime)
			: base(vdsId, vmId)
		{
			_ticket = ticket;
			_validTime = validTime;
		}

		public string Ticket
		{
			get
			{
				return _ticket;
			}
		}
		public int ValidTime
		{
			get
			{
				return _validTime;
			}
		}
	}
	[DataContract]
	public class SetVdsStatusVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly VDSStatus _status;

		public SetVdsStatusVDSCommandParameters(int vdsId, VDSStatus status)
			: base(vdsId)
		{
			_status = status;
		}

		public VDSStatus Status
		{
			get
			{
				return _status;
			}
		}
	}
	[DataContract]
	public class SetVmStatusVDSCommandParameters : VDSParametersBase
	{
		[DataMember]
		private readonly Guid _vmId;
		[DataMember]
		private readonly VMStatus _status;

		public SetVmStatusVDSCommandParameters(Guid vmId, VMStatus status)
		{
			_vmId = vmId;
			_status = status;
		}

		public Guid VmId
		{
			get
			{
				return _vmId;
			}
		}

		public VMStatus Status
		{
			get
			{
				return _status;
			}
		}

	}
	[DataContract]
	public class FailedToRunVmVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public FailedToRunVmVDSCommandParameters(int vdsId)
			: base(vdsId)
		{
		}
	}
	[DataContract]
	public class IsVmDuringInitiatingVDSCommandParameters : VDSParametersBase
	{
		public IsVmDuringInitiatingVDSCommandParameters(Guid vmId)
		{
			_vmId = vmId;
		}

		[DataMember]
		private readonly Guid _vmId;

		public Guid VmId
		{
			get { return _vmId; }
		}
	}
	[DataContract]
	public class StartSpiceVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly string _vdsIp;
		[DataMember]
		private readonly string _ticket;
		[DataMember]
		private readonly int _guestPort;

		public StartSpiceVDSCommandParameters(int vdsId, string vdsIp, int guestPort, string ticket)
			: base(vdsId)
		{
			_vdsIp = vdsIp;
			_ticket = ticket;
			_guestPort = guestPort;
		}

		public string Ticket
		{
			get
			{
				return _ticket;
			}
		}
		public int GuestPort
		{
			get
			{
				return _guestPort;
			}
		}
		public string VdsIp
		{
			get
			{
				return _vdsIp;
			}
		}
	}
	[DataContract]
	public class RunVmHyperChannelCommandVDSCommandParameters : VdsAndVmIDVDSParametersBase
	{
		[DataMember]
		private readonly string _hcCommand;

		public RunVmHyperChannelCommandVDSCommandParameters(int vdsId, Guid vmId, string hcCommand)
			: base(vdsId, vmId)
		{
			_hcCommand = hcCommand;
		}

		public string HcCommand
		{
			get
			{
				return _hcCommand;
			}
		}
	}
	[DataContract]
	public class ShutdownVdsVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		private readonly bool _reboot;

		public ShutdownVdsVDSCommandParameters(int vdsId, bool reboot)
			: base(vdsId)
		{
			_reboot = reboot;
		}

		public bool Reboot
		{
			get
			{
				return _reboot;
			}
		}
	}
	[DataContract]
	public class UpdateVdsVMsClearedVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public UpdateVdsVMsClearedVDSCommandParameters(int vdsId)
			: base(vdsId)
		{
		}
	}
	[DataContract]
	public class UpdateVmDynamicDataVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		public VmDynamic VmDynamic
		{
			get;
			private set;
		}

		public UpdateVmDynamicDataVDSCommandParameters(int vdsId, VmDynamic vmDynamic)
			: base(vdsId)
		{
			VmDynamic = vmDynamic;
		}
	}
	[DataContract]
	public class UpdateVdsDynamicDataVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		public VdsDynamic VdsDynamic
		{
			get;
			private set;
		}

		public UpdateVdsDynamicDataVDSCommandParameters(VdsDynamic vdsDynamic)
			: base(vdsDynamic.vds_id)
		{
			VdsDynamic = vdsDynamic;
		}
	}
	[DataContract]
	public class NetworkVdsmVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
        [DataMember]
        public string NetworkName
        { get; private set; }
        [DataMember]
        public string OldNetworkName
        { get; set; }
        [DataMember]
        public string HostAddr
        { get; set; }
        [DataMember]
        public bool CheckConnectivity
        { get; set; }
        [DataMember]
        public int ConnectionTimeout
        { get; set; }
        [DataMember]
        public int? VlanId
        { get; private set; }
        [DataMember]
        public string BondName
        { get; private set; }
        [DataMember]
        public string[] Nics
        { get; private set; }
        [DataMember]
        public string InetAddr
        { get; private set; }
        [DataMember]
        public string NetworkMask
        { get; private set; }
        [DataMember]
        public string Gateway
        { get; private set; }
        [DataMember]
        public bool Stp
        { get; private set; }
        [DataMember]
        public string BondingOptions
        { get; private set; }
        [DataMember]
        public NetworkBootProtocol BootProtocol
        { get; private set; }
		public NetworkVdsmVDSCommandParameters(int vdsId, string networkName, int? vlanId, string bondName, string[] nics, 
            string inetAddr, string netMask, string gateway, bool stp, string bondingOptions, NetworkBootProtocol bootProtocol)
			: base(vdsId)
		{
            NetworkName = networkName;
            VlanId = vlanId;
            BondName = bondName;
            Nics = nics;
            InetAddr = inetAddr;
            NetworkMask = netMask;
            Gateway = gateway;
            this.Stp = stp;
            this.BondingOptions = bondingOptions;
            this.BootProtocol = bootProtocol;
		} 
	}

	#region Storage Connections
	[DataContract]
	public class GetStorageConnectionsListVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public Guid StoragePoolId { get; private set; }
		public GetStorageConnectionsListVDSCommandParameters(int vdsId, Guid storagePoolId)
			: base(vdsId)
		{
			StoragePoolId = storagePoolId;
		}
	}
	[DataContract]
	public class ConnectStorageServerVDSCommandParameters : GetStorageConnectionsListVDSCommandParameters
	{
		[DataMember]
		public StorageType StorageType { get; private set; }
		[DataMember]
		public List<storage_server_connections> ConnectionList { get; private set; }

		public ConnectStorageServerVDSCommandParameters(int vdsId, Guid storagePoolId, StorageType storageType, List<storage_server_connections> connectionList)
			: base (vdsId, storagePoolId)
		{
			StorageType = storageType;
			ConnectionList = connectionList;
		}
	}
	
	#endregion
	#region Storage Domains and Pools
	[DataContract]
	public class ValidateStorageDomainVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		public Guid StorageDomainId { get; private set; }

		public ValidateStorageDomainVDSCommandParameters(int vdsId, Guid storageDomainId)
			: base (vdsId)
		{
			StorageDomainId = storageDomainId;
		}
	}
	[DataContract]
	public class ConnectStoragePoolVDSCommandParameters : GetStorageConnectionsListVDSCommandParameters
	{
		public ConnectStoragePoolVDSCommandParameters(int vdsId, Guid storagePoolId, 
            int vds_spm_id, Guid masterDomainId, int masterVersion)
			: base (vdsId, storagePoolId)
		{
			this.vds_spm_id = vds_spm_id;
		    MasterDomainId = masterDomainId;
		    MasterVersion = masterVersion;
		}

		[DataMember]
		public int vds_spm_id { get; private set; }
        [DataMember]
        public Guid MasterDomainId
        {
            get; private set;
        }
        [DataMember]
        public int MasterVersion
        {
            get; private set;
        }
	}
	[DataContract]
	public class FormatStorageDomainVDSCommandParameters : ValidateStorageDomainVDSCommandParameters
	{
		public FormatStorageDomainVDSCommandParameters(int vdsId, Guid storageDomainId)
			: base(vdsId, storageDomainId)
		{
		}
	}
	[DataContract]
	public class DisconnectStoragePoolVDSCommandParameters : ConnectStoragePoolVDSCommandParameters
	{
		public DisconnectStoragePoolVDSCommandParameters(int vdsId, Guid storagePoolId, 
            int vds_spm_id)
			: base(vdsId, storagePoolId, vds_spm_id,Guid.Empty,0)
		{
		}
	}
    [DataContract]
    public class CreateStorageDomainVDSCommandParameters : VdsIdVDSCommandParametersBase
    {
        [DataMember]
        public storage_domain_static StorageDomain
        {
            get; private set;
        }
        [DataMember]
        public string Args { get; private set; }

        public CreateStorageDomainVDSCommandParameters(int vdsId,
                                                      storage_domain_static storageDomain,
                                                        string args)
            : base(vdsId)
        {
            StorageDomain = storageDomain;
            Args = args;
        }
    }
	[DataContract]
	public class CreateStoragePoolVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		public Guid StoragePoolId { get; private set; }
		[DataMember]
		public StorageType StorageType { get; private set; }
		[DataMember]
		public string StoragePoolName { get; private set; }
		[DataMember]
		public Guid MasterDomainId { get; private set; }
		[DataMember]
		public List<Guid> DomainsIdList { get; private set; }
		[DataMember]
		public int MasterVersion { get; private set; }

		public CreateStoragePoolVDSCommandParameters(int vdsId, StorageType storageType, Guid storagePoolId, string poolName,
			Guid masterDomainId, List<Guid> domainsIdList, int masterVersion)
			: base(vdsId)
		{
			StoragePoolId = storagePoolId;
			StorageType = storageType;
			StoragePoolName = poolName;
			MasterDomainId = masterDomainId;
			DomainsIdList = domainsIdList;
			MasterVersion = masterVersion;
		}
	}
	[DataContract]
	public class GetStorageDomainStatsVDSCommandParameters : ValidateStorageDomainVDSCommandParameters
	{
		public GetStorageDomainStatsVDSCommandParameters(int vdsId, Guid storageDomainId)
			: base(vdsId, storageDomainId)
		{
		}
	}
	[DataContract]
	public class HSMGetStorageDomainInfoVDSCommandParameters : ValidateStorageDomainVDSCommandParameters
	{
		public HSMGetStorageDomainInfoVDSCommandParameters(int vdsId, Guid storageDomainId)
			: base(vdsId, storageDomainId)
		{
		}
	}
	[DataContract]
	public class HSMGetStorageDomainsListVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
        public HSMGetStorageDomainsListVDSCommandParameters(int vdsId, Guid storagePoolId, StorageType storageType, 
            StorageDomainType storageDomainType, string path)
			: base(vdsId)
		{
			StoragePoolId = storagePoolId;
            StorageType = storageType;
            StorageDomainType = storageDomainType;
            Path = path;
		}
		[DataMember]
		public Guid StoragePoolId { get; private set; }
        [DataMember]
        public StorageType StorageType { get; private set; }
        [DataMember]
        public StorageDomainType StorageDomainType { get; private set; }
        [DataMember]
        public string Path { get; private set; }
	}
    [DataContract]
    public class HSMGetIsoListParameters : VdsIdVDSCommandParametersBase
    {
        public HSMGetIsoListParameters(int vdsId, Guid storagePoolId)
            : base(vdsId)
        {
            StoragePoolId = storagePoolId;
        }
        [DataMember]
        public Guid StoragePoolId { get; private set; }
    }
	#endregion
	#region SAN API
	[DataContract]
	public class CreateVGVDSCommandParameters : ValidateStorageDomainVDSCommandParameters
	{
		public CreateVGVDSCommandParameters(int vdsId, Guid storageDomainId, List<string> deviceList)
			: base(vdsId, storageDomainId)
		{
			DeviceList = deviceList;
		}
		[DataMember]
		public List<string> DeviceList { get; private set; }
	}
	[DataContract]
	public class RemoveVGVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public RemoveVGVDSCommandParameters(int vdsId, string vgId)
			: base(vdsId)
		{
			VGID = vgId;
		}
		[DataMember]
		public string VGID { get; private set; }
	}
	[DataContract]
	public class GetVGInfoVDSCommandParameters : RemoveVGVDSCommandParameters
	{
		public GetVGInfoVDSCommandParameters(int vdsId, string vgId)
			: base(vdsId, vgId)
		{
		}
	}
	[DataContract]
	public class GetDeviceInfoVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public GetDeviceInfoVDSCommandParameters(int vdsId, string lunId)
			: base(vdsId)
		{
			LUNID = lunId;
		}
		[DataMember]
		public string LUNID { get; private set; }
	}
	[DataContract]
	public class DiscoverSendTargetsVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public DiscoverSendTargetsVDSCommandParameters(int vdsId, storage_server_connections connection)
			: base(vdsId)
		{
			Connection = connection;
		}
		[DataMember]
		public storage_server_connections Connection { get; private set; }
	}
	[DataContract]
	public class GetDeviceListVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public GetDeviceListVDSCommandParameters(int vdsId, StorageType storageType)
			: base(vdsId)
		{
			StorageType = storageType;
		}
		[DataMember]
		public StorageType StorageType { get; private set; }
	}
	#endregion
	[DataContract]
	public class RefreshStoragePoolVDSCommandParameters : GetStorageConnectionsListVDSCommandParameters
	{
		public RefreshStoragePoolVDSCommandParameters(int vdsId, Guid storagePoolId, Guid masterStorageDomainId, int masterVersion)
			: base(vdsId, storagePoolId)
		{
			MasterStorageDomainId = masterStorageDomainId;
			MasterVersion = masterVersion;
		}
		[DataMember]
		public Guid MasterStorageDomainId { get; private set; }
		[DataMember]
		public int MasterVersion { get; private set; }
	}
	#region Clustering related API
	[DataContract]
	public class FenceSpmStorageVDSCommandParameters : GetStorageConnectionsListVDSCommandParameters
	{
		public FenceSpmStorageVDSCommandParameters(int vdsId, Guid storagePoolId, int prevID, string prevLVER)
			: base(vdsId, storagePoolId)
		{
			PrevId = prevID;
			PrevLVER = prevLVER ?? "-1";
		}
		[DataMember]
		public int PrevId { get; private set; }
		[DataMember]
		public string PrevLVER { get; private set; }
	}
	[DataContract]
	public class SpmStartVDSCommandParameters : FenceSpmStorageVDSCommandParameters
	{
		public SpmStartVDSCommandParameters(int vdsId, Guid storagePoolId, int prevID, string prevLVER, RecoveryMode recoveryMode, bool SCSIfencing)
			: base(vdsId, storagePoolId, prevID, prevLVER)
		{
			RecoveryMode = recoveryMode;
			SCSIFencing = SCSIfencing;
		}
		[DataMember]
		public RecoveryMode RecoveryMode { get; private set; }
		[DataMember]
		public bool SCSIFencing { get; private set; }
	}

	[DataContract]
	public class SpmStopVDSCommandParameters : GetStorageConnectionsListVDSCommandParameters
	{
		public SpmStopVDSCommandParameters(int vdsId, Guid storagePoolId)
			: base(vdsId, storagePoolId)
		{
		}
	}

	[DataContract]
	public class SpmStatusVDSCommandParameters : GetStorageConnectionsListVDSCommandParameters
	{
		public SpmStatusVDSCommandParameters(int vdsId, Guid storagePoolId)
			: base(vdsId, storagePoolId)
		{
		}
	}
	[DataContract]
	public class ReconstructMasterVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		[DataMember]
		public Guid StoragePoolId { get; private set; }
		[DataMember]
		public string StoragePoolName { get; private set; }
		[DataMember]
		public Guid MasterDomainId { get; private set; }
		[DataMember]
		public List<storage_pool_iso_map> DomainsList { get; private set; }
		[DataMember]
		public int MasterVersion { get; private set; }

		public ReconstructMasterVDSCommandParameters(int vdsId, Guid storagePoolId, string storagePoolName,
			Guid masterDomainId, List<storage_pool_iso_map> domainsList, int masterVersion)
			: base(vdsId)
		{
			StoragePoolId = storagePoolId;
			StoragePoolName = storagePoolName;
			MasterDomainId = masterDomainId;
			DomainsList = domainsList;
			MasterVersion = masterVersion;
		}
	}
	#endregion
	#region AsyncTasks
	[DataContract]
	public class HSMTaskGuidBaseVDSCommandParameters : VdsIdVDSCommandParametersBase
	{
		public HSMTaskGuidBaseVDSCommandParameters(int vdsId, Guid taskId)
			: base(vdsId)
		{
			TaskId = taskId;
		}
		[DataMember]
		public Guid TaskId { get; private set; }
	}
	#endregion
    #region Import / Export
	[DataContract]
    public class GetVmsInfoVDSCommandParameters : IrsBaseVDSCommandParameters
    {
        [DataMember]
        public Guid StorageDomainId { get; set; }
        [DataMember]
        public List<Guid> VmIdList { get; set; }
        public GetVmsInfoVDSCommandParameters(Guid storagePoolId)
            : base(storagePoolId)
        {
        } 

    }
    #endregion
}
