'''
Created on Apr 26, 2010

@author: mpastern@redhat.com
'''
import re
import org.ovirt.engine.ui.sdk.containers.errorsContainer as Exceptions
from org.ovirt.engine.ui.sdk.internals import config

class Broker:
    def __init__(self, name, methods):
        #self.id = type(self).__hash__(self)
        self.name = name
        self.methods = methods
    def __eq__(self, other=None):
        return other !=None and self.name == other.name
    def __ne__(self, other):
        return not self.__eq__(other)
    def getName(self):
        return self.name
    def getMethods(self):
        return self.methods
    def getMethod(self, name='', params={}):
        for k in range(len(self.methods)):
            if(len(params) == 0):
                if(self.methods[k].getName() == name):
                    return self.methods[k]
            else:
                if(self.methods[k].getName() == name and self.methods[k].getParams() == params):
                    return self.methods[k]
        return None
    def show(self, indent=False,cliManner=False):
        for method in self.methods:
            mtd = ''
            if(indent): mtd += '\t'
            mtd += method.__str__(cliManner)
            print mtd
    def getId(self):
        return self.id
    def getMethodsNames(self):
        names = []
        for method in self.methods:
            names.append(method.getName())
        return names
#    def __eq__(self, br):
#        if(not br == None):
#            if(br.getName() == self.name and br.getMethods() == self.methods):
#                return True           
#        return False
    def  __nonzero__(self):
        if(not len(self.getMethods())==0):
            return 1
        return 0                  
    def __getattr__(self, name):
        """
        Get a method by name and return it in an I{execution wrapper}.
        @param name: The name of a method.
        @type name: str
        @return: An I{execution wrapper} for the specified method name.
        @rtype: L{Method}
        """
        return self[name]
    def __getitem__(self, name):
        method = self.getMethod(name)
        if(method == None):
            raise Exceptions.MethodNotFoundInBroker(name,self.name)
        else:
            return method
    def __str__(self):
        return self.name
    def __lt__(self,other):
        return self.name < other.getName()
    
class EntityDrivenBrokersContainer(object):
    __cahe = {}
    __brokers = []
    __config=None
    def __init__(self, cahe):
        self.__config = config.getConfig()
        self.__cahe = cahe
        self.__create(cahe)
    def __getattr__(self, name):
        broker = self.getBrokerByName(name)
        if(broker):
            return broker            
        else:
            raise Exceptions.BrokerNotFound(name)
    def show(self,entity='Broker',cliManner=False):
        for broker in self.__brokers:
            if(self.__config["showEntitiesAnnotation"]<>None and self.__config["showEntitiesAnnotation"]==True):
                print '\n'+entity+': \'' + broker.name + '\''
            else:
                print broker.name + ':'
            broker.show(True,cliManner)
    def showArgumented(self,entityRepresentor='Broker'):
        for broker in self.__brokers:
            print '\n'+entityRepresentor+': \'' + broker.name + '\''
            broker.show(True)  
    def brokers(self):        
        return self.__brokers    
    def getBrokerByName(self,name):
        for broker in self.__brokers:
            if(broker.getName() == name):
                return broker
        return None
    def get(self, name=''):               
        for broker in self.__brokers:
            if(broker.name == name):
                return broker
        raise Exceptions.BrokerNotFound(name)
    
    def __create(self, cahe):
        for k in self.__cahe.keys():
            self.__brokers.append(self.__createBroker(k, self.__cahe[k]))        
        
        self.__brokers = sorted(self.__brokers)

    def __createBroker(self, name, methods):
        dClass = eval("Broker")
        return dClass(name, methods)
    
    def getMethodsNames(self):
        names = []
        for broker in self.__brokers:
            for name in broker.getMethodsNames():
                names.append(name)                 
        return names

class BrokersConstructor(object):
    '''
        Constructs brokers.
    '''
    __classContainer = {}
    def __init__(self, object=None):
        for method in object.getMethodsSignatures():
            self.__storeMethodSignature(method)
        BrokersConstructor.__init__ = BrokersConstructor.__nomore__ 
        
    def __nomore__(self, ignored):
        raise Exceptions.NoFurtherEntries(type(self).__name__)

    def __storeMethodSignature(self, method):        
        typeName = self.__many2single(self.__getNounName(method))
        if(not self.__classContainer.has_key(typeName)):
            self.__classContainer[typeName] = []
        method.setAncestor(typeName)
        self.__classContainer[typeName].append(method)    
    def __many2single(self, typeName=''):
        if typeName.endswith('s'):
            newTypeName = typeName[0:(len(typeName) - 1)]
            if(self.__classContainer.has_key(newTypeName)):
                return newTypeName
        return typeName
    def __getNounName(self, method):        
        className = ''
        i = 0
        j = 0
        methodName = method.getName()

#TODO: cleanup -> __getNounName         
        if(re.search('DataCenter', methodName)):# and (str(methodName).endswith('DataCenter')or(str((methodName[0:len (methodName)-1])).endswith('DataCenter')))):
            return 'DataCenter'
        if(re.search('VMPool', methodName)):# and (str(methodName).endswith('DataCenter')or(str((methodName[0:len (methodName)-1])).endswith('DataCenter')))):
            return 'VMPool'
        if(re.search('VMcd', methodName)):# and (str(methodName).endswith('DataCenter')or(str((methodName[0:len (methodName)-1])).endswith('DataCenter')))):
            return 'VM'        
        if(re.search('searchAdUserOrGroup', methodName) or \
           re.search('removePermissionById', methodName) or\
           re.search('getPermissions', methodName)):
            return 'User'
        if(re.search('getAllRoles', methodName)):
           return 'Role'
        if(re.search('addFCPorISCSIStorageDomain', methodName) \
           or re.search('addNFSStorageDomain', methodName) or \
           re.search('getPreConfiguredStorageDomainsById', methodName)):
           return 'Storage'
        if(re.search('addBondToHostById', methodName) or\
           re.search('removeBondFromHostById', methodName)):
           return 'Network'
        
        for nextChar in methodName[1:len(methodName)]:
            if re.search("[@A-Z]", nextChar):
                className += nextChar
                for c in methodName[(i + 2):len (methodName)]: 
                        j += 1
                        #if (not re.search("[@A-Z]", c) and not c == '(') or (((j + 2) < len(methodName)) and re.search("[@A-Z]", c) and (re.search("[@A-Z]", methodName[j + 2])or(methodName[j + 2] == "(")or(((j + 3) < len(methodName)) and re.search("[@A-Z]", c) and (not re.search("[@A-Z]", methodName[j + 2]))and (re.search("[@A-Z]", methodName[j])) and (methodName[j + 3] == "(")))):
                        if (not re.search("[@A-Z]", c) and ((j + 2) <= len(methodName))) or (re.search("[@A-Z]", c) and ((j + 2) == len(methodName))) or (re.search("[@A-Z]", c) and ((j + 3) == len(methodName))and(not re.search("[@A-Z]", methodName[j+2]))) or (((j + 2) < len(methodName)) and re.search("[@A-Z]", c) and (re.search("[@A-Z]", methodName[j + 2])or(methodName[j + 2] == "(")or(((j + 3) < len(methodName)) and re.search("[@A-Z]", c) and (not re.search("[@A-Z]", methodName[j + 2]))and (re.search("[@A-Z]", methodName[j])) and (methodName[j + 3] == "(")))):
                            className += c 
                        else:
                            return unicode.encode(className)                 
                return unicode.encode(className)
            i += 1
            j = i
        return None    
    def getContainer(self):
        return EntityDrivenBrokersContainer(self.__classContainer)
