#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Tue May 24 08:53:39 2011 by generateDS.py version 2.4c.
#

import sys
import getopt
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
STRING_CLEANUP_PAT = re_.compile(r"[\n\r\s]+")

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class datasources(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, local_tx_datasource=None):
        if local_tx_datasource is None:
            self.local_tx_datasource = []
        else:
            self.local_tx_datasource = local_tx_datasource
    def factory(*args_, **kwargs_):
        if datasources.subclass:
            return datasources.subclass(*args_, **kwargs_)
        else:
            return datasources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_local_tx_datasource(self): return self.local_tx_datasource
    def set_local_tx_datasource(self, local_tx_datasource): self.local_tx_datasource = local_tx_datasource
    def add_local_tx_datasource(self, value): self.local_tx_datasource.append(value)
    def insert_local_tx_datasource(self, index, value): self.local_tx_datasource[index] = value
    def export(self, outfile, level, namespace_='tns:', name_='datasources', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, [], namespace_, name_='datasources')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='datasources'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='datasources', fromsubclass_=False):
        for local_tx_datasource_ in self.local_tx_datasource:
            local_tx_datasource_.export(outfile, level, namespace_, name_='local-tx-datasource')
    def hasContent_(self):
        if (
            self.local_tx_datasource
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='datasources'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('local_tx_datasource=[\n')
        level += 1
        for local_tx_datasource_ in self.local_tx_datasource:
            showIndent(outfile, level)
            outfile.write('model_.local_tx_datasource(\n')
            local_tx_datasource_.exportLiteral(outfile, level, name_='local-tx-datasource')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'local-tx-datasource': 
            obj_ = local_tx_datasource.factory()
            obj_.build(child_)
            self.local_tx_datasource.append(obj_)
# end class datasources


class local_tx_datasource(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, jndi_name=None, connection_url=None, driver_class=None, max_pool_size=None, check_valid_connection_sql=None, security_domain=None, user_name=None, password=None):
        self.jndi_name = jndi_name
        self.connection_url = connection_url
        self.driver_class = driver_class
        self.max_pool_size = max_pool_size
        self.check_valid_connection_sql = check_valid_connection_sql
        self.security_domain = security_domain
        self.user_name = user_name
        self.password = password
    def factory(*args_, **kwargs_):
        if local_tx_datasource.subclass:
            return local_tx_datasource.subclass(*args_, **kwargs_)
        else:
            return local_tx_datasource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_jndi_name(self): return self.jndi_name
    def set_jndi_name(self, jndi_name): self.jndi_name = jndi_name
    def get_connection_url(self): return self.connection_url
    def set_connection_url(self, connection_url): self.connection_url = connection_url
    def get_driver_class(self): return self.driver_class
    def set_driver_class(self, driver_class): self.driver_class = driver_class
    def get_max_pool_size(self): return self.max_pool_size
    def set_max_pool_size(self, max_pool_size): self.max_pool_size = max_pool_size
    def get_check_valid_connection_sql(self): return self.check_valid_connection_sql
    def set_check_valid_connection_sql(self, check_valid_connection_sql): self.check_valid_connection_sql = check_valid_connection_sql
    def get_security_domain(self): return self.security_domain
    def set_security_domain(self, security_domain): self.security_domain = security_domain
    def get_user_name(self): return self.user_name
    def set_user_name(self, user_name): self.user_name = user_name
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def export(self, outfile, level, namespace_='tns:', name_='local-tx-datasource', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, [], namespace_, name_='local-tx-datasource')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='local-tx-datasource'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='local-tx-datasource', fromsubclass_=False):
        if self.jndi_name is not None:
            showIndent(outfile, level)
            outfile.write('<%sjndi-name>%s</%sjndi-name>\n' % (namespace_, self.gds_format_string(quote_xml(self.jndi_name).encode(ExternalEncoding), input_name='jndi-name'), namespace_))
        if self.connection_url is not None:
            showIndent(outfile, level)
            outfile.write('<%sconnection-url>%s</%sconnection-url>\n' % (namespace_, self.gds_format_string(quote_xml(self.connection_url).encode(ExternalEncoding), input_name='connection-url'), namespace_))
        if self.driver_class is not None:
            showIndent(outfile, level)
            outfile.write('<%sdriver-class>%s</%sdriver-class>\n' % (namespace_, self.gds_format_string(quote_xml(self.driver_class).encode(ExternalEncoding), input_name='driver-class'), namespace_))
        if self.max_pool_size is not None:
            showIndent(outfile, level)
            outfile.write('<%smax-pool-size>%s</%smax-pool-size>\n' % (namespace_, self.gds_format_string(quote_xml(self.max_pool_size).encode(ExternalEncoding), input_name='max-pool-size'), namespace_))
        if self.check_valid_connection_sql is not None:
            showIndent(outfile, level)
            outfile.write('<%scheck-valid-connection-sql>%s</%scheck-valid-connection-sql>\n' % (namespace_, self.gds_format_string(quote_xml(self.check_valid_connection_sql).encode(ExternalEncoding), input_name='check-valid-connection-sql'), namespace_))
        if self.security_domain is not None:
            showIndent(outfile, level)
            outfile.write('<%ssecurity-domain>%s</%ssecurity-domain>\n' % (namespace_, self.gds_format_string(quote_xml(self.security_domain).encode(ExternalEncoding), input_name='security-domain'), namespace_))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('<%suser-name>%s</%suser-name>\n' % (namespace_, self.gds_format_string(quote_xml(self.user_name).encode(ExternalEncoding), input_name='user-name'), namespace_))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('<%spassword>%s</%spassword>\n' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_))
    def hasContent_(self):
        if (
            self.jndi_name is not None or
            self.connection_url is not None or
            self.driver_class is not None or
            self.max_pool_size is not None or
            self.check_valid_connection_sql is not None or
            self.security_domain is not None or
            self.user_name is not None or
            self.password is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='local-tx-datasource'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.jndi_name is not None:
            showIndent(outfile, level)
            outfile.write('jndi_name=%s,\n' % quote_python(self.jndi_name).encode(ExternalEncoding))
        if self.connection_url is not None:
            showIndent(outfile, level)
            outfile.write('connection_url=%s,\n' % quote_python(self.connection_url).encode(ExternalEncoding))
        if self.driver_class is not None:
            showIndent(outfile, level)
            outfile.write('driver_class=%s,\n' % quote_python(self.driver_class).encode(ExternalEncoding))
        if self.max_pool_size is not None:
            showIndent(outfile, level)
            outfile.write('max_pool_size=%s,\n' % quote_python(self.max_pool_size).encode(ExternalEncoding))
        if self.check_valid_connection_sql is not None:
            showIndent(outfile, level)
            outfile.write('check_valid_connection_sql=%s,\n' % quote_python(self.check_valid_connection_sql).encode(ExternalEncoding))
        if self.security_domain is not None:
            showIndent(outfile, level)
            outfile.write('security_domain=%s,\n' % quote_python(self.security_domain).encode(ExternalEncoding))
        if self.user_name is not None:
            showIndent(outfile, level)
            outfile.write('user_name=%s,\n' % quote_python(self.user_name).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'jndi-name':
            jndi_name_ = child_.text
            jndi_name_ = self.gds_validate_string(jndi_name_, node, 'jndi_name')
            self.jndi_name = jndi_name_
        elif nodeName_ == 'connection-url':
            connection_url_ = child_.text
            connection_url_ = self.gds_validate_string(connection_url_, node, 'connection_url')
            self.connection_url = connection_url_
        elif nodeName_ == 'driver-class':
            driver_class_ = child_.text
            driver_class_ = self.gds_validate_string(driver_class_, node, 'driver_class')
            self.driver_class = driver_class_
        elif nodeName_ == 'max-pool-size':
            max_pool_size_ = child_.text
            max_pool_size_ = self.gds_validate_string(max_pool_size_, node, 'max_pool_size')
            self.max_pool_size = max_pool_size_
        elif nodeName_ == 'check-valid-connection-sql':
            check_valid_connection_sql_ = child_.text
            check_valid_connection_sql_ = self.gds_validate_string(check_valid_connection_sql_, node, 'check_valid_connection_sql')
            self.check_valid_connection_sql = check_valid_connection_sql_
        elif nodeName_ == 'security-domain':
            security_domain_ = child_.text
            security_domain_ = self.gds_validate_string(security_domain_, node, 'security_domain')
            self.security_domain = security_domain_
        elif nodeName_ == 'user-name':
            user_name_ = child_.text
            user_name_ = self.gds_validate_string(user_name_, node, 'user_name')
            self.user_name = user_name_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
# end class local_tx_datasource


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'datasources'
        rootClass = datasources
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_=rootTag, 
##         namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'datasources'
        rootClass = datasources
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="datasources",
##         namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'datasources'
        rootClass = datasources
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('#from jbossds import *\n\n')
##     sys.stdout.write('import jbossds as model_\n\n')
##     sys.stdout.write('rootObj = model_.rootTag(\n')
##     rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##     sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "datasources",
    "local_tx_datasource"
    ]
