package org.ovirt.engine.api.restapi.resource;

import java.util.List;

import com.redhat.rhevm.api.model.Group;
import com.redhat.rhevm.api.resource.AssignedTagsResource;
import org.ovirt.engine.core.common.businessentities.tags;
import org.ovirt.engine.core.common.action.AttachEntityToTagParameters;
import org.ovirt.engine.core.common.action.TagsActionParametersBase;
import org.ovirt.engine.core.common.action.VdcActionType;
import org.ovirt.engine.core.common.queries.GetTagsByUserGroupIdParameters;
import org.ovirt.engine.core.common.queries.VdcQueryType;

public class BackendGroupTagsResource
    extends AbstractBackendAssignedTagsResource
    implements AssignedTagsResource {

    public BackendGroupTagsResource(String parentId) {
        super(Group.class, parentId, VdcActionType.AttachUserGroupToTag, VdcActionType.DetachUserGroupFromTag);
    }

    public List<tags> getCollection() {
        return getBackendCollection(VdcQueryType.GetTagsByUserGroupId, new GetTagsByUserGroupIdParameters(parentId));
    }

    protected TagsActionParametersBase getAttachParams(String id) {
        return new AttachEntityToTagParameters(asGuid(id), asList(asGuid(parentId)));
    }
}
