package org.ovirt.engine.core.bll;

import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ovirt.engine.core.common.config.Config;
import org.ovirt.engine.core.common.queries.VdcQueryParametersBase;
import org.ovirt.engine.core.compat.RpmVersion;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ Config.class })
public class GetoVirtISOsTest extends BaseMockitoTest {

    private static final String OVIRT_INIT_SUPPORTED_VERSION = "5.8";
    private static final String OVIRT_ISO_PREFIX = "rhevh";
    private static final String OVIRT_ISOS_REPOSITORY_PATH = "src/test/resources/ovirt-isos";

    @Before
    public void setUp() {
        ConfigMocker cfgMocker = new ConfigMocker();
        cfgMocker.mockOVirtISOsRepositoryPath(OVIRT_ISOS_REPOSITORY_PATH);
        cfgMocker.mockConfigOvirtIsoPrefix(OVIRT_ISO_PREFIX);
        cfgMocker.mockConfigOvirtInitialSupportedIsoVersion(OVIRT_INIT_SUPPORTED_VERSION);
    }

    @Test
    public void testQuery() {
        VdcQueryParametersBase params = new VdcQueryParametersBase();
        GetoVirtISOsQuery<VdcQueryParametersBase> query = new GetoVirtISOsQuery<VdcQueryParametersBase>(params);
        query.ExecuteCommand();

        checkSucceeded(query, true);
        checkReturnValue(query);
    }

    @SuppressWarnings("unchecked")
    private void checkReturnValue(GetoVirtISOsQuery<VdcQueryParametersBase> query) {
        List<RpmVersion> isosList = (List<RpmVersion>) query.getQueryReturnValue().getReturnValue();
        assertTrue(!isosList.isEmpty());
    }

}
