package org.ovirt.engine.core.bll.adbroker;

import org.ovirt.engine.core.utils.kerberos.AuthenticationResult;

public class RhevmDirectoryServiceException extends Exception {

    /**
     *
     */
    private static final long serialVersionUID = 2854926242091038897L;
    private AuthenticationResult result;

    public RhevmDirectoryServiceException(AuthenticationResult result) {
        this.result = result;
    }

    public AuthenticationResult getResult() {
        return result;
    }

    public RhevmDirectoryServiceException(AuthenticationResult result,String message) {
        super(message);
        this.result = result;
    }

    public RhevmDirectoryServiceException(AuthenticationResult result,Throwable cause) {
        super(cause);
        this.result = result;
    }

    public RhevmDirectoryServiceException(AuthenticationResult result,String message, Throwable cause) {
        super(message, cause);
        this.result = result;
    }
}
