USE [$(dbname)]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET NOCOUNT ON
GO


print 'Upgrade script Started...'
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'iscsi_initiator_name'))
begin
	ALTER TABLE vds_dynamic ADD [iscsi_initiator_name] nvarchar(max) NULL

end
go

-- vm_templates boot_options
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'initrd_url'))
begin
	ALTER TABLE vm_templates ADD [initrd_url] nvarchar(max) NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'kernel_url'))
begin
	ALTER TABLE vm_templates ADD [kernel_url] nvarchar(max) NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'kernel_params'))
begin
	ALTER TABLE vm_templates ADD [kernel_params] nvarchar(max) NULL
end
go

-- vm_static boot_options
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'initrd_url'))
begin
	ALTER TABLE vm_static ADD [initrd_url] nvarchar(max) NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'kernel_url'))
begin
	ALTER TABLE vm_static ADD [kernel_url] nvarchar(max) NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'kernel_params'))
begin
	ALTER TABLE vm_static ADD [kernel_params] nvarchar(max) NULL
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_dynamic' and COLUMN_NAME = 'pause_status'))
begin
	ALTER TABLE vm_dynamic ADD [pause_status]  int not NULL CONSTRAINT [DF_vm_dynamic_pause_status]  DEFAULT ((0))
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_dynamic' and COLUMN_NAME = 'exit_status'))
begin
	ALTER TABLE vm_dynamic ADD [exit_status] int not NULL CONSTRAINT [DF_vm_dynamic_exit_status]  DEFAULT ((0))
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_dynamic' and COLUMN_NAME = 'exit_message'))
begin
	ALTER TABLE vm_dynamic ADD [exit_message] nvarchar(max) 
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_groups' and COLUMN_NAME = 'migrate_on_error'))
begin
	ALTER TABLE vds_groups ADD [migrate_on_error] int default 1 not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_groups' and COLUMN_NAME = 'transparent_hugepages'))
begin
	ALTER TABLE vds_groups ADD [transparent_hugepages] bit default 0 not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'transparent_hugepages_state'))
begin
	ALTER TABLE vds_dynamic ADD [transparent_hugepages_state] int default 0 not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'anonymous_hugepages'))
begin
	ALTER TABLE vds_dynamic ADD [anonymous_hugepages] int default 0 not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = '_update_date'))
begin
	ALTER TABLE vds_dynamic ADD [_update_date] datetime null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'LUNs' and COLUMN_NAME = 'serial'))
begin
	ALTER TABLE LUNs ADD [serial] nvarchar(max) null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'LUNs' and COLUMN_NAME = 'lun_mapping'))
begin
	ALTER TABLE LUNs ADD [lun_mapping] int null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'LUNs' and COLUMN_NAME = 'vendor_id'))
begin
	ALTER TABLE LUNs ADD [vendor_id] nvarchar(50) null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'LUNs' and COLUMN_NAME = 'product_id'))
begin
	ALTER TABLE LUNs ADD [product_id] nvarchar(50) null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'LUNs' and COLUMN_NAME = 'device_size'))
begin
	ALTER TABLE LUNs ADD [device_size] int default 0
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'migration_support'))
begin
	ALTER TABLE vm_static ADD [migration_support]  int DEFAULT 0 not NULL
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'LUNs' and COLUMN_NAME = 'serial'))
begin
	ALTER TABLE LUNs ADD [serial] nvarchar(max) null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'audit_log' and COLUMN_NAME = 'vds_group_id'))
begin
	ALTER TABLE audit_log ADD [vds_group_id] uniqueidentifier NULL

end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'audit_log' and COLUMN_NAME = 'vds_group_name'))
begin
	ALTER TABLE audit_log ADD [vds_group_name] nvarchar(255) NULL

end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'disk_image_dynamic' and COLUMN_NAME = 'guest_disk_size_bytes'))
begin
	ALTER TABLE disk_image_dynamic ADD guest_disk_size_bytes bigint NULL

end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'disk_image_dynamic' and COLUMN_NAME = 'guest_used_disk_size_bytes'))
begin
	ALTER TABLE disk_image_dynamic ADD guest_used_disk_size_bytes bigint NULL

end
go



-- interface_statistics separation to vm_interface_statistics and vds_interface_statistics
if (not exists (select * from sys.tables WHERE name = 'vm_interface_statistics'))
begin
	CREATE TABLE [dbo].[vm_interface_statistics](
		[id] [uniqueidentifier] NOT NULL,
		[rx_rate] [decimal](18, 0) NULL,
		[vm_id] [uniqueidentifier] NULL,
		[tx_rate] [decimal](18, 0) NULL,
		[rx_drop] [decimal](18, 0) NULL,
		[tx_drop] [decimal](18, 0) NULL,
		[iface_status] int,
	 CONSTRAINT [PK_vms_interface_statistics] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]
end
go

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_vm_interface_statistics_vm_static' AND TABLE_NAME='vm_interface_statistics')
begin
	ALTER TABLE [vm_interface_statistics] ADD CONSTRAINT [fk_vm_interface_statistics_vm_static] 
		FOREIGN KEY ([vm_id]) REFERENCES [vm_static] (vm_guid) ON DELETE CASCADE
end
go

if (not exists (select * from sys.tables WHERE name = 'vds_interface_statistics'))
begin
	CREATE TABLE [dbo].[vds_interface_statistics](
		[id] [uniqueidentifier] NOT NULL,
		[rx_rate] [decimal](18, 0) NULL,
		[vds_id] [uniqueidentifier] NULL,
		[tx_rate] [decimal](18, 0) NULL,
		[rx_drop] [decimal](18, 0) NULL,
		[tx_drop] [decimal](18, 0) NULL,
		[iface_status] int,
	 CONSTRAINT [PK_vds_interface_statistics] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]
end
go

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_vds_interface_statistics_vds_static' AND TABLE_NAME='vds_interface_statistics')
begin
	ALTER TABLE [vds_interface_statistics] ADD CONSTRAINT [fk_vds_interface_statistics_vds_static] 
		FOREIGN KEY ([vds_id]) REFERENCES [vds_static] (vds_id) ON DELETE CASCADE
end
go

if (not exists (select * from sys.tables WHERE name = 'repo_file_meta_data'))
begin
	CREATE TABLE [dbo].[repo_file_meta_data](
			[repo_domain_id] [uniqueidentifier] NOT NULL,
			[repo_file_name] [nvarchar](256) NOT NULL,
			[size] bigint default 0,
			[date_created] datetime default getdate(),
			[last_refreshed] bigint default 0,
			[file_type] int default 0
		 CONSTRAINT [PK_repo_file_meta_data] PRIMARY KEY ([repo_domain_id],[repo_file_name])
	) ON [PRIMARY]
end
go

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_repo_file_meta_data_storage_domain_static' AND TABLE_NAME='repo_file_meta_data')
begin
	ALTER TABLE [repo_file_meta_data] ADD CONSTRAINT [FK_repo_file_meta_data_storage_domain_static] 
		FOREIGN KEY ([repo_domain_id]) REFERENCES [storage_domain_static] ([id]) ON DELETE CASCADE
end
go

-- populate vm/vds interface statistics tables from original
if (exists (select * from sys.tables WHERE name = 'interface_statistics'))
begin
	-- VM's and templates
	insert vm_interface_statistics (id, vm_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status)
     (select id, vm_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status from interface_statistics
        where vm_id is not null or (vm_id is null and vds_id is null))
	-- VDS
	insert vds_interface_statistics (id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status)
     (select id, vds_id, rx_rate, tx_rate, rx_drop, tx_drop, iface_status from interface_statistics
		where vds_id is not null)

end
go

-- Fixing problem of INT to UUID upgrade where constraints that were configured to SET NULL on delete
-- turn to ON DELETE RESTRICT (default behaviour)

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='Fk_vds_groups_storage_pool_id' AND TABLE_NAME='vds_groups')
BEGIN
	ALTER TABLE [dbo].[vds_groups] DROP CONSTRAINT [Fk_vds_groups_storage_pool_id]
	ALTER TABLE [dbo].[vds_groups] ADD CONSTRAINT [Fk_vds_groups_storage_pool_id]
		FOREIGN KEY ([storage_pool_id]) REFERENCES [dbo].[storage_pool] ([id]) ON DELETE SET NULL
END
go

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_network_storage_pool' AND TABLE_NAME='network')
BEGIN
	ALTER TABLE [dbo].[network] DROP CONSTRAINT [FK_network_storage_pool]
	ALTER TABLE [dbo].[network] ADD CONSTRAINT [FK_network_storage_pool]
		FOREIGN KEY ([storage_pool_id]) REFERENCES [dbo].[storage_pool] ([id])ON DELETE SET NULL
END
go

------------------------------------------
--				MLA
------------------------------------------
	
-- add object id and type to permissions, default is system for current permissions
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'permissions' and COLUMN_NAME = 'object_id'))
begin
	ALTER TABLE permissions ADD [object_id] uniqueidentifier not null CONSTRAINT [DF_permissions_object_id_system]  DEFAULT dbo.getGlobalIds('system')
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'permissions' and COLUMN_NAME = 'object_type_id'))
begin
	ALTER TABLE permissions ADD [object_type_id] int not null  CONSTRAINT [DF_permissions_object_type_id_system] DEFAULT 1
end
go

-- add FK to roles table
IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_permissions_roles' AND TABLE_NAME='permissions')
begin
	ALTER TABLE [dbo].[permissions] ADD  CONSTRAINT [fk_permissions_roles] FOREIGN KEY([role_id])
	REFERENCES [dbo].[roles] ([id]) ON DELETE CASCADE 
end
GO

-- add index objects
if not exists (SELECT name FROM sysindexes WHERE name = N'IDX_permissions_ad_element_id')
begin
	CREATE NONCLUSTERED  INDEX IDX_permissions_ad_element_id
		ON permissions (ad_element_id ASC)
end
go

if not exists (SELECT name FROM sysindexes WHERE name = N'IDX_repo_file_file_type')
begin
	CREATE NONCLUSTERED  INDEX IDX_repo_file_file_type
		ON repo_file_meta_data (file_type)
end
go

if not exists (SELECT name FROM sysindexes WHERE name = N'IDX_permissions_object_id')
begin
	CREATE NONCLUSTERED  INDEX IDX_permissions_object_id
		ON permissions (object_id ASC)
end
go

if not exists (SELECT name FROM sysindexes WHERE name = N'IDX_permissions_role_id')
begin
	CREATE NONCLUSTERED  INDEX IDX_permissions_role_id
		ON permissions (role_id ASC)
end
go


-- Before creating the index make sure that there are no
-- duplicates (everything equal except the id) in the
-- permissions table:
if exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'permissions' and COLUMN_NAME = 'is_readonly')
begin
	declare @sql nvarchar(max)
	set @sql='delete ' +
	  'p1 ' +
	'from ' +
	  'permissions p1, ' +
	  'permissions p2 ' +
	'where ' +
	  'p1.role_id = p2.role_id and ' +
	  'p1.ad_element_id = p2.ad_element_id and ' +
	  'p1.is_readonly = p2.is_readonly and ' +
	  'p1.object_id = p2.object_id and ' +
	  'p1.object_type_id = p2.object_type_id and ' +
	  'p1.id > p2.id'
	exec sp_executesql @sql
end
go

if not exists (SELECT name FROM sysindexes WHERE name = N'IDX_combined_ad_role_object')
begin
	CREATE UNIQUE NONCLUSTERED INDEX [IDX_combined_ad_role_object] ON [dbo].[permissions] 
	(
		[ad_element_id] ASC,
		[role_id] ASC,
		[object_id] ASC
	)
end
go

	-- roles
-- add role_type to roles
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'roles' and COLUMN_NAME = 'role_type'))
begin
	ALTER TABLE roles ADD [role_type] int not null  DEFAULT 2
end
go

declare @adminRoleType int
select @adminRoleType = role_type from roles where id = '00000000-0000-0000-0000-000000000001';
-- if superUser role type is not admin we are after upgrade
if (@adminRoleType is null or @adminRoleType != 1)
begin
	-- first make powerUser, rhevmUser and templateUser - type user
	update roles set role_type = 2
		where id in ('00000000-0000-0000-0001-000000000002', '00000000-0000-0000-0001-000000000001', 'DEF00009-0000-0000-0000-DEF000000009')

	-- update other roles to admin (all predefined and custom)
	update roles set role_type = 1
		where id not in ('00000000-0000-0000-0001-000000000002', '00000000-0000-0000-0001-000000000001', 'DEF00009-0000-0000-0000-DEF000000009')
end
go

	-- roles_groups
-- new table roles_groups
if (not exists (select * from sys.tables WHERE name = 'roles_groups'))
begin
	CREATE TABLE [roles_groups]
	(
	[role_id] uniqueidentifier not null,
	[action_group_id] int not null,
	constraint pk_roles_groups primary key ([role_id],[action_group_id])
	)
	ALTER TABLE [roles_groups] ADD CONSTRAINT [fk_roles_groups_action_id] FOREIGN KEY ([role_id]) REFERENCES [roles] (id) ON DELETE CASCADE
	
	CREATE NONCLUSTERED  INDEX IDX_roles_groups_action_group_id
		ON roles_groups (action_group_id ASC)
end
go

if (not exists (select * from sys.tables WHERE name = 'dwh_history_timekeeping'))
begin
CREATE TABLE [dbo].[dwh_history_timekeeping](
	[var_name] varchar(50) NOT NULL,
	[var_value] varchar(255) NULL,
	[var_datetime] datetime NULL
)
end
GO

if (not exists (select 1 from [dbo].[dwh_history_timekeeping] WHERE var_name = 'lastSync'))
begin
Insert into [dbo].[dwh_history_timekeeping] VALUES('lastSync',NULL,cast('01/01/2000 12:00:00 PM' as datetime))
end
GO

-- permissions data migration
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'permissions' and COLUMN_NAME = 'is_readonly') and 
    exists (select * from sys.tables WHERE name = 'tags_permissions_map'))
begin
	declare @sql nvarchar(max)
	-- users attached to pools and vms
	-- using dynamic sql because using tags_permissions_map which will be deleted after first upgrade runs
	set @sql = 'insert into permissions (id, role_id, ad_element_id, object_id, object_type_id, is_readonly)
	(
 	select
		newid() as id,
		''00000000-0000-0000-0001-000000000001'' as role_id,
		user_id as ad_element_id,
		vm_pool_id as object_id,
		5 as object_type_id,
		0 as is_readonly
	from
		dbo.users_and_groups_to_vm_pool_map_view

	union

	select
		newid() as id,
		''00000000-0000-0000-0001-000000000001'' as role_id,
		p.ad_element_id as ad_element_id,
		m.vm_id as object_id,
		2 as object_type_id,
		0 as is_readonly
	from
		tags as t,
		permissions as p,
		tags_vm_map as m
	where
		replace(t.description, ''User tag: '', '''') = p.ad_element_id and
		t.tag_id = m.tag_id and
		p.role_id = ''00000000-0000-0000-0001-000000000001''
	)'
	exec sp_executesql @sql
	-- remove vdi role
	delete roles where id = '00000000-0000-0000-0001-000000000003'
	-- remove permissions of rhevmUser and powerUser
	delete permissions where 
	role_id in ('00000000-0000-0000-0001-000000000002','00000000-0000-0000-0001-000000000001')
	and object_type_id = 1
end
go


-- make every template in the system a public template
-- grant permissions with role id TEMPLATE_USER on EVEYONE user for each template
declare @EVERYONE uniqueidentifier
declare @TEMPLATE_USER uniqueidentifier
declare @TEMPLATE_USER_STR char(36)
declare @EVERYONE_STR char(36)

set @EVERYONE = dbo.getGlobalIds('everyone')
set @TEMPLATE_USER = 'DEF00009-0000-0000-0000-DEF000000009'
set @TEMPLATE_USER_STR = convert(char(36),@TEMPLATE_USER)
set @EVERYONE_STR = convert(char(36),@EVERYONE)

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'permissions' and COLUMN_NAME = 'is_readonly'))
begin

	-- change the default value of permissions.object_id to NOT NULL instead of @SYSTEM_ID
	-- update every permission on custom roles to system object
	update permissions set object_id = dbo.getGlobalIds('system'), object_type_id = 1
			where
	role_id not in ('00000000-0000-0000-0001-000000000002', '00000000-0000-0000-0001-000000000001')

	-- this must be added to prevent FK violation altough it will be removed and reacreated 
	-- again after running the insert_perdefined_roles.sql script
	declare @sql nvarchar(max)
	set @sql =
	'INSERT INTO [roles] (id, name, description, is_readonly, role_type) 
		VALUES (''' + @TEMPLATE_USER_STR + ''',''TemplateUser'','''',1,2)
	insert into permissions (id, role_id, ad_element_id, object_id, object_type_id,is_readonly)
	(select newid() as id,''' +  @TEMPLATE_USER_STR + ''' as role_id,''' + 
				@EVERYONE_STR + ''' as ad_element_id, vmt_guid as object_id, 4 as object_type_id, 0 as is_readonly
		from dbo.vm_templates )'	
	exec sp_executesql @sql
end


if (exists (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='DF_permissions_object_id_system' AND TABLE_NAME='permissions'))
begin
	ALTER TABLE permissions DROP CONSTRAINT [DF_permissions_object_id_system] 
end
go

if (exists (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='DF_permissions_object_type_id_system' AND TABLE_NAME='permissions'))
begin
	ALTER TABLE permissions DROP CONSTRAINT [DF_permissions_object_type_id_system] 
end
go

------------------------------------------
--				END of MLA
------------------------------------------

UPDATE vds_dynamic
SET vm_count = 0 WHERE vm_count IS NULL

ALTER TABLE vds_dynamic
ALTER COLUMN vm_count int NOT NULL
go

-- add last_admin_check_status column to users table
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'users' and COLUMN_NAME = 'last_admin_check_status'))
begin
	ALTER table users add [last_admin_check_status] Bit default 0 NOT NULL
end
go


-- add bonding options
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_interface' and COLUMN_NAME = 'bond_opts'))
begin
	ALTER table vds_interface add [bond_opts] nvarchar(max) default NULL
end
go

--add vds hooks
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'hooks'))
begin
	ALTER table vds_dynamic add [hooks] nvarchar(max) default NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_static' and COLUMN_NAME = 'ip' and CHARACTER_MAXIMUM_LENGTH = 255))
begin
        alter table vds_static alter column ip nvarchar(255)
end
GO

--add non operational status reasons
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'non_operational_reason'))
begin
	ALTER table vds_dynamic add [non_operational_reason] int default 0 NOT NULL
end
go

--add min allocated memory for VM to be used in VM Migration calculations
--this actually indicates how much memory at least VM need to run, value is in MB
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'min_allocated_mem'))
begin
	ALTER table vm_static add [min_allocated_mem] int default 0 NOT NULL
end
go

-- Update new created min_allocated_mem to be : (mem_size_mb * 100.0 / max_vds_memory_over_commit)
-- where the mem_size_mb is the VM memory and max_vds_memory_over_commit is the memory over commit
-- settings for the VM cluster, the result is rounded UP using the CEILING function
-- if max_vds_memory_over_commit then min_allocated_mem is set to mem_size_mb

update vm_static set min_allocated_mem =
	(case  
		when (max_vds_memory_over_commit > 0) 
			then CEILING (mem_size_mb * 100.0 / max_vds_memory_over_commit)   
	
		else mem_size_mb 
	end)
    from vds_groups
	
go

-- Adding pending vmem size to persist VM mem used on migration before VM is up
-- This is used in teh same manner of the pending vcpus count  
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'pending_vmem_size'))
begin
	ALTER table vds_dynamic add [pending_vmem_size] int default 0 NOT NULL
end
go

-- change max_vds_memory_over_commit to 100 instead of 0
-- clean the constraint from vds_groups
declare @constraint_name nvarchar(128)
SELECT TOP 1 @constraint_name =  name 
FROM sysobjects 
WHERE  object_name(parent_obj)='vds_groups' and xtype = 'D' and (
	name like 'DF__vds_group%__max_v%' or 
	name like 'DF_vds_groups_mem_over_commit' or 
	name like 'DF__vds_group__max_vds_memory_over_commit')
IF (@constraint_name IS NOT NULL)
	BEGIN
		declare @sql nvarchar(max)
		set @sql = 'ALTER TABLE vds_groups DROP CONSTRAINT ' + @constraint_name
		exec sp_executesql @sql
	END
GO
-- clean the constraint from vds_groups___old
declare @constraint_name nvarchar(128)
SELECT TOP 1 @constraint_name =  name 
FROM sysobjects 
WHERE  object_name(parent_obj)='vds_groups___old' and xtype = 'D' and (
	name like 'DF__vds_group%__max_v%' or 
	name like 'DF_vds_groups_mem_over_commit' or 
	name like 'DF__vds_group__max_vds_memory_over_commit')
IF (@constraint_name IS NOT NULL)
	BEGIN
		declare @sql nvarchar(max)
		set @sql = 'ALTER TABLE vds_groups___old DROP CONSTRAINT ' + @constraint_name
		exec sp_executesql @sql
	END
GO
-- recreate contraint on vds_groups (no need to recreate on vds_groups___old since it is not used and will be dropped in 2.4)
ALTER TABLE vds_groups ADD CONSTRAINT [DF_vds_groups_mem_over_commit] DEFAULT (100) FOR max_vds_memory_over_commit
GO
UPDATE vds_groups SET max_vds_memory_over_commit = 100 WHERE max_vds_memory_over_commit = 0
GO
------------------------------------------------------------------
-- CPU name changes in cluster (vds_group table)
------------------------------------------------------------------
-- Intel Xeon Core 2 -> Intel Conroe Family
-- Intel Xeon 45nm Core2 -> Intel Penryn Family
-- Intel Xeon Core i7 -> Intel Nehalem Family
------------------------------------------------------------------
update vds_groups set cpu_name=(
case 
	when cpu_name=('Intel Xeon Core2') then 'Intel Conroe Family'
	when cpu_name=('Intel Xeon 45nm Core2') then 'Intel Penryn Family'
	when cpu_name=('Intel Xeon Core i7') then 'Intel Nehalem Family'
	else
		cpu_name
end
)
where cpu_name in ('Intel Xeon Core2','Intel Xeon 45nm Core2','Intel Xeon Core i7')
GO

-- Change VmAdmin role name & description 
update roles set name = 'VmOperator' , description = 'VM operator'
where  id = 'DEF00006-0000-0000-0000-DEF000000006'
go

-- Check entity_snapshot type , if it is image we should drop the table and recreate
-- it with a text column type in order to store object as json rather as binary.
if exists (SELECT 1
	FROM sys.columns AS c
	JOIN sys.types AS t ON c.user_type_id=t.user_type_id
	WHERE OBJECT_NAME(c.OBJECT_ID) = 'business_entity_snapshot' and
              t.name = 'image' and c.name = 'entity_snapshot')
begin
	drop table business_entity_snapshot
end
go


--add the business_entity_snapshot table for compensation support
if (not exists (select * from sys.tables WHERE name = 'business_entity_snapshot'))
begin

	CREATE TABLE business_entity_snapshot
	(
	  id uniqueidentifier NOT NULL,
	  command_id uniqueidentifier NOT NULL,
	  command_type nvarchar(256) NOT NULL,
	  entity_id nvarchar(128),
	  entity_type nvarchar(128),
	  entity_snapshot  text,
	  snapshot_type INTEGER,
	  insertion_order INTEGER,
	  CONSTRAINT PK_id PRIMARY KEY (id),
	  CONSTRAINT UQ_command_id_entity_id UNIQUE (command_id, entity_id, entity_type,snapshot_type)
	)
end
go

if not exists (SELECT name FROM sysindexes WHERE name = N'IDX_business_entity_snapshot_command_id')
begin

	CREATE NONCLUSTERED INDEX [IDX_business_entity_snapshot_command_id] ON [dbo].[business_entity_snapshot]
	([command_id] ASC)
end

go

-- change vm_ip in table vm_dynamic from char(255) to nvarchar(max)
if ( exists(select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_dynamic' and COLUMN_NAME = 'vm_ip' and CHARACTER_MAXIMUM_LENGTH=255))
begin
    ALTER TABLE vm_dynamic ALTER COLUMN  vm_ip nvarchar(max)
end
go



--------------------------------------------------------
-- VDC OPTIONS CHANGES - put here values that should
-- be changed in vdc_options only once upon upgrade.
-------------------------------------------------------

-- The folowing option should be changed once , we are not setting it with override=true
-- in configuration file since we still want that customer changed over that value will be honored 
-- Updates must specify the expected value since if the customer had changed this value, we should
-- leave it as is.
update vdc_options set option_value = '180' where option_name = 'vdsTimeout' and option_value ='90'
update vdc_options set option_value = '3' where option_name = 'MaxRerunVmOnVdsCount' and option_value ='1000'
go

------------------------------------------------------------------
-- End of VDC OPTIONS CHANGES Section
------------------------------------------------------------------

-------------------------------------------------------
-- DROPs Sections - should be the last section
-------------------------------------------------------


-- remove is_readonly from permissions table
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'permissions' and COLUMN_NAME = 'is_readonly'))
begin
	ALTER TABLE permissions DROP COLUMN [is_readonly]
end
go

-- remove defaults of system (for new created permissions)
if exists (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = 'permissions' and CONSTRAINT_NAME = 'DF_permissions_object_id_system')
begin
	ALTER TABLE permissions DROP constraint [DF_permissions_object_id_system]
end
go
if exists (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = 'permissions' and CONSTRAINT_NAME = 'DF_permissions_object_type_id_system')
begin
	ALTER TABLE permissions DROP constraint [DF_permissions_object_type_id_system]
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_pool' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [storage_pool] ADD [_create_date] datetime default getdate()
end
go

update [storage_pool] set [_create_date] = getdate() where [_create_date] is null
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_pool' and COLUMN_NAME = '_update_date'))
begin
	ALTER TABLE [storage_pool] ADD [_update_date] datetime default NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_domain_static' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [storage_domain_static] ADD [_create_date] datetime default getdate()
end
go

update [storage_domain_static] set [_create_date] = getdate() where [_create_date] is null
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_domain_static' and COLUMN_NAME = '_update_date'))
begin
	ALTER TABLE [storage_domain_static] ADD [_update_date] datetime default NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'predefined_properties'))
begin
	ALTER TABLE vm_static ADD [predefined_properties]  varchar(max)
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'userdefined_properties'))
begin
	ALTER TABLE vm_static ADD [userdefined_properties]  varchar(max)
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags_vm_pool_map' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [tags_vm_pool_map] ADD [_create_date] datetime default getdate() not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags_vm_map' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [tags_vm_map] ADD [_create_date] datetime default getdate() not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags_vds_map' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [tags_vds_map] ADD [_create_date] datetime default getdate() not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags' and COLUMN_NAME = '_update_date'))
begin
	ALTER TABLE [tags] ADD [_update_date] datetime default NULL
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [tags] ADD [_create_date] datetime default getdate() not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags_user_map' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [tags_user_map] ADD [_create_date] datetime default getdate() not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags_user_group_map' and COLUMN_NAME = '_create_date'))
begin
	ALTER TABLE [tags_user_group_map] ADD [_create_date] datetime default getdate() not null
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = '_update_date'))
begin
	ALTER TABLE [vm_templates] ADD [_update_date] datetime default getdate() not null
end
go


-- drop interface statistics table
if (exists (select * from sys.tables WHERE name = 'interface_statistics'))
begin
	DROP TABLE interface_statistics
end
go


-- remove default of role type
if exists (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = 'roles' and CONSTRAINT_NAME = 'DF_roles_role_type_id_user')
begin
	ALTER TABLE roles DROP CONSTRAINT [DF_roles_role_type_id_user]
end
go

-- drop old roles_actions table
if (exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'roles_actions'))
begin
	DROP table roles_actions
end
go

-- drop old tags_permissions_map table
if (exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'tags_permissions_map'))
begin
	DROP table tags_permissions_map
end
go

-- drop the old table vds_tools_version_map and its constraints
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_tools_version_map_storage_domain_static' AND TABLE_NAME='vds_tools_version_map')
BEGIN
	ALTER TABLE [dbo].[vds_tools_version_map] DROP CONSTRAINT [FK_vds_tools_version_map_storage_domain_static]
END

if (exists (select * from sys.tables WHERE name = 'vds_tools_version_map'))
begin
	DROP TABLE vds_tools_version_map
end
go

-- change max_vds_memory_over_commit to 100 instead of 0
IF (EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'vds_groups' AND COLUMN_NAME = 'max_vds_memory_over_commit'))
BEGIN
    IF EXISTS(SELECT * FROM sys.default_constraints WHERE name = 'DF_vds_groups_mem_over_commit')
    BEGIN
        ALTER TABLE vds_groups
        DROP CONSTRAINT [DF_vds_groups_mem_over_commit]
    END
ALTER TABLE  vds_groups ADD CONSTRAINT [DF_vds_groups_mem_over_commit] DEFAULT (100) FOR max_vds_memory_over_commit
UPDATE vds_groups SET max_vds_memory_over_commit = 100 WHERE max_vds_memory_over_commit = 0

END
GO

-- Adds distinguishedname column to ad_groups
if (not EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ad_groups' AND COLUMN_NAME = 'distinguishedname'))
BEGIN
    ALTER TABLE [ad_groups] ADD [distinguishedname] nvarchar(max) default null
end
GO

-- clean the DF_vds_groups_is_initialized constraint from vds_groups
declare @constraint_name nvarchar(128)
SELECT TOP 1 @constraint_name =  name 
FROM sysobjects 
WHERE  object_name(parent_obj)='vds_groups' and xtype = 'D' and (
       	name like 'DF__vds_group%__is_i%' or 
       	name like 'DF_vds_groups_is_initialized%')

IF (@constraint_name IS NOT NULL)
	BEGIN
		declare @sql nvarchar(max)
		set @sql = 'ALTER TABLE vds_groups DROP CONSTRAINT ' + @constraint_name
		exec sp_executesql @sql
	END
GO
-- clean the constraint from vds_groups___old
declare @constraint_name nvarchar(128)
SELECT TOP 1 @constraint_name =  name 
FROM sysobjects 
WHERE  object_name(parent_obj)='vds_groups___old' and xtype = 'D' and (
       	name like 'DF__vds_group%__is_i%' or 
       	name like 'DF_vds_groups_is_initialized%')
                          
IF (@constraint_name IS NOT NULL)
	BEGIN
		declare @sql nvarchar(max)
		set @sql = 'ALTER TABLE vds_groups___old DROP CONSTRAINT ' + @constraint_name
		exec sp_executesql @sql
	END
GO


IF (EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'vds_groups' AND COLUMN_NAME = 'is_initialized'))
BEGIN
	ALTER TABLE  vds_groups DROP column [is_initialized]
END
GO

-- Adds storage_domain_format_type column to storage_domain_static
if (not EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'storage_domain_static' AND COLUMN_NAME = 'storage_domain_format_type'))
BEGIN
    ALTER TABLE [storage_domain_static] ADD [storage_domain_format_type] INT NOT NULL default 0
end
GO

-- Adds storage_pool_format_type column to storage_pool
if (not EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'storage_pool' AND COLUMN_NAME = 'storage_pool_format_type'))
BEGIN
    ALTER TABLE [storage_pool] ADD [storage_pool_format_type] INT default null
end
GO

UPDATE storage_pool SET storage_pool_format_type = 0
WHERE storage_pool_format_type IS NULL AND id IN (select DISTINCT storage_pool_id from storage_pool_iso_map)
GO

-- Add snapshot_class column to business_entity_snapshot
if (not EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'business_entity_snapshot' AND COLUMN_NAME = 'snapshot_class'))
BEGIN
    ALTER TABLE [business_entity_snapshot] ADD [snapshot_class] nvarchar(128) default null
end
GO

-- Add group_ids column to users
if (not EXISTS (select COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'users' AND COLUMN_NAME = 'group_ids'))
BEGIN
    ALTER TABLE [users] ADD [group_ids] VARCHAR(2048)
end
GO

------------------------------------------------------------------
-- End of DROPs Sections - please do not add lines after this line
------------------------------------------------------------------

-- remove subnet_mask from vds_static table
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_static' and COLUMN_NAME = 'subnet_mask'))
begin
	ALTER TABLE vds_static DROP COLUMN [subnet_mask]
end
go

print 'Upgrade script completed...'
go
