USE [rhevm]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET NOCOUNT ON
GO

print 'Upgrade script Started...'
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_static' and COLUMN_NAME = 'pm_options'))
begin
	ALTER TABLE vds_static ADD [pm_options] nvarchar(max) default ''
end
go


if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'images' and COLUMN_NAME = 'num_of_sectors'))
begin
	ALTER TABLE images ALTER COLUMN num_of_sectors bigint
	
    declare @sql nvarchar(max)
	set @sql = 'update images set num_of_sectors = (num_of_sectors * 512)'
    exec sp_executesql @sql	
end
go 

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'image_templates' and COLUMN_NAME = 'num_of_sectors'))
begin
	ALTER TABLE image_templates ALTER COLUMN num_of_sectors bigint
	
    declare @sql nvarchar(max)
	set @sql = 'update image_templates set num_of_sectors = (num_of_sectors * 512)'
    exec sp_executesql @sql	
end
go 

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'disk_image_dynamic' and COLUMN_NAME = 'actual_num_of_sectors'))
begin
	ALTER TABLE disk_image_dynamic ALTER COLUMN actual_num_of_sectors bigint
	
    declare @sql nvarchar(max)
	set @sql = 'update disk_image_dynamic set actual_num_of_sectors = (actual_num_of_sectors * 512)'
    exec sp_executesql @sql		
end
go 

 --add new columns default_boot_sequence,default_display_type,priority to vm_static
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'default_boot_sequence'))
begin
	ALTER TABLE vm_static ADD [default_boot_sequence] int not null default 0
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'default_display_type'))
begin
	ALTER TABLE vm_static ADD [default_display_type] int not null default 0
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'priority'))
begin
	ALTER TABLE vm_static ADD [priority] int not null default 0
end
go

-- disable auto suspend in vms and templates
update vm_static set is_auto_suspend = 0
go
-- disable auto suspend in vms and templates
update vm_templates set is_auto_suspend = 0
go

 --copy old values from defalt_boot_device to default_boot_sequence
 --then remove old defalt_boot_device from vm_static
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'default_boot_device'))
begin
	declare @sql nvarchar(max)
	set @sql = 'update vm_static set [default_boot_sequence] = [default_boot_device] where vm_guid=vm_guid'
    exec sp_executesql @sql
end
go

 --add new columns default_boot_sequence,default_display_type,priority,auto_startup,is_stateless to vm_templates
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'default_boot_sequence'))
begin
	ALTER TABLE vm_templates ADD [default_boot_sequence] int not null default 0
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'default_display_type'))
begin
	ALTER TABLE vm_templates ADD [default_display_type] int not null default 0
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'priority'))
begin
	ALTER TABLE vm_templates ADD [priority] int not null default 0
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'auto_startup'))
begin
	ALTER TABLE vm_templates ADD [auto_startup] bit
end
go
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'is_stateless'))
begin
	ALTER TABLE vm_templates ADD [is_stateless] bit NULL
end
go

 --copy old values from defalt_boot_device to default_boot_sequence
 --then remove old defalt_boot_device from vm_templates
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'default_boot_device'))
begin
	declare @sql nvarchar(max)
	set @sql = 'update vm_templates set [default_boot_sequence] = [default_boot_device] where vmt_guid=vmt_guid'
    exec sp_executesql @sql	
end
go

 --add new columns boot_sequence to vm_dynamic
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_dynamic' and COLUMN_NAME = 'boot_sequence'))
begin
	ALTER TABLE vm_dynamic ADD [boot_sequence] int not null default 0
end
go
 --copy old values from boot_device to boot_sequence
 --then remove old boot_device from vm_dynamic
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_dynamic' and COLUMN_NAME = 'boot_device'))
begin
	declare @sql nvarchar(max)
	set @sql = 'update vm_dynamic set [boot_sequence] = [boot_device] where vm_guid=vm_guid'
    exec sp_executesql @sql			
end
go

if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'tags_vm_pool_map'))
begin
CREATE TABLE [dbo].[tags_vm_pool_map](
	[tag_id] [int] NOT NULL,
	[vm_pool_id] [int] NOT NULL,
 CONSTRAINT [pk_tags_vm_pool_map] PRIMARY KEY  
(
	[tag_id] ,
	[vm_pool_id] 
)
)
end
GO

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_tags_vm_pool_map_tag' AND TABLE_NAME='tags_vm_pool_map')
begin
ALTER TABLE [dbo].[tags_vm_pool_map]   ADD  CONSTRAINT [fk_tags_vm_pool_map_tag] FOREIGN KEY([tag_id])
REFERENCES [dbo].[tags] ([tag_id]) ON DELETE CASCADE 
end
GO
IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_tags_vm_pool_map_vm_pool' AND TABLE_NAME='tags_vm_pool_map')
begin
ALTER TABLE [dbo].[tags_vm_pool_map]   ADD  CONSTRAINT [fk_tags_vm_pool_map_vm_pool] FOREIGN KEY([vm_pool_id])
REFERENCES [dbo].[vm_pools] ([vm_pool_id]) ON DELETE CASCADE 
end 
GO

-- [image_group_storage_domain_map]
if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'image_group_storage_domain_map'))
begin
CREATE TABLE [dbo].[image_group_storage_domain_map](
	[image_group_id] [uniqueidentifier] NOT NULL,
	[storage_domain_id] [uniqueidentifier] NOT NULL CONSTRAINT [FK_image_group_storage_domain_map_storage_domain_static] FOREIGN KEY([storage_domain_id])
		REFERENCES [dbo].[storage_domain_static] ([id]) ON DELETE CASCADE,
 CONSTRAINT [PK_image_group_storage_domain_map] PRIMARY KEY CLUSTERED 
(
	[image_group_id] ASC,
	[storage_domain_id] ASC
))
end
GO

 --add status to storage_pool_iso_map
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_pool_iso_map' and COLUMN_NAME = 'status'))
begin
	ALTER TABLE storage_pool_iso_map ADD status int
end
go
 --add owner to storage_pool_iso_map
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_pool_iso_map' and COLUMN_NAME = 'owner'))
begin
	ALTER TABLE storage_pool_iso_map ADD owner int
end
go
 --copy old values 
 --then remove storage_pool_id from storage_domain_static
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_domain_static' and COLUMN_NAME = 'storage_pool_id'))
begin
	declare @sql nvarchar(max)
	set @sql = 'insert storage_pool_iso_map(storage_id,storage_pool_id,status,owner)
					select sdStatic.id, sdStatic.storage_pool_id, sdDynamic.status, 0 
					from storage_domain_static as sdStatic
					inner join storage_domain_dynamic as sdDynamic on sdStatic.id = sdDynamic.id
					where storage_pool_id is not null'
    exec sp_executesql @sql		
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'iso_path'))
begin
	declare @sql nvarchar(max)
	ALTER TABLE vm_static ADD [iso_path] nvarchar(max) default ''
	set @sql = 'update vm_static set iso_path = '''' where iso_path = NULL'
    exec sp_executesql @sql
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'origin'))
begin
	declare @sql nvarchar(max)
	ALTER TABLE vm_static ADD [origin] int default 0
	set @sql = 'update vm_static set origin = 0 where origin = NULL'
    exec sp_executesql @sql	
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'iso_path'))
begin
	declare @sql nvarchar(max)
	ALTER TABLE vm_templates ADD [iso_path] nvarchar(max) default ''
	set @sql = 'update vm_templates set iso_path = '''' where iso_path = NULL'
    exec sp_executesql @sql		
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'origin'))
begin
	declare @sql nvarchar(max)
	ALTER TABLE vm_templates ADD [origin] int default 0
	set @sql = 'update vm_templates set origin = 0 where origin = NULL'
    exec sp_executesql @sql			
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_statistics' and COLUMN_NAME = 'ksm_state'))
begin
	ALTER TABLE vds_statistics ADD  [swap_free] [BIGINT] NULL,
									[swap_total] [BIGINT] NULL,
									[ksm_cpu_percent] [int] NULL CONSTRAINT [DEF_vds_statistics_ksm_cpu_percent]  DEFAULT ((0)),
									[ksm_pages] [BIGINT] NULL,
									[ksm_state] bit NULL
end
go

 --extend column length for vm_name
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'vm_name' and CHARACTER_MAXIMUM_LENGTH = 255))
begin
	alter table vm_static alter column vm_name nvarchar(255)
end
GO

 --extend column length for vds_name
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_static' and COLUMN_NAME = 'vds_name' and CHARACTER_MAXIMUM_LENGTH = 255))
begin
	alter table vds_static alter column vds_name nvarchar(255)
end
GO

 --extend column length for vm_pool_name

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_pools' and COLUMN_NAME = 'vm_pool_name' and CHARACTER_MAXIMUM_LENGTH = 255))
begin
	alter table vm_pools alter column vm_pool_name nvarchar(255)
end
GO

 --update audit log lengths for vds/vm name
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'audit_log' and COLUMN_NAME = 'vds_name' and CHARACTER_MAXIMUM_LENGTH = 255))
begin
	alter table audit_log alter column vds_name nvarchar(255)
	alter table audit_log alter column vm_name nvarchar(255)
end
GO

-- change cpu names values
if (not exists (select option_name from vdc_options where option_name = 'TempCPUNamesUpdated'))
begin
 	update vds_groups set cpu_name = 'Intel Xeon w/o XD/NX' where cpu_name = 'pentium3'
	update vds_groups set cpu_name = 'Intel Xeon w/o XD/NX' where cpu_name = 'intel-qemu64-nx'
	update vds_groups set cpu_name = 'Intel Xeon' where cpu_name = 'intel-qemu64'
	update vds_groups set cpu_name = 'AMD Opteron G1 w/o NX' where cpu_name = 'amd-qemu64-nx'
	update vds_groups set cpu_name = 'AMD Opteron G1' where cpu_name = 'amd-qemu64'
	insert vdc_options (option_name, option_value) values('TempCPUNamesUpdated', 'true')	
end

go

 --backward compatibility
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_groups' and COLUMN_NAME = 'compatibility_version'))
begin
	ALTER TABLE vds_groups ADD compatibility_version nvarchar(40) not null default '2.1'
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_pool' and COLUMN_NAME = 'compatibility_version'))
begin
	ALTER TABLE storage_pool ADD compatibility_version nvarchar(40) not null default '2.1'
end
go

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'supported_cluster_levels'))
begin
	ALTER TABLE vds_dynamic ADD supported_cluster_levels nvarchar(40) null
	ALTER TABLE vds_dynamic ADD supported_rhevms nvarchar(40) null
end
go

 --[action_version_map]
if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'action_version_map'))
begin
CREATE TABLE [dbo].[action_version_map](
	[action_type] [int] NOT NULL,
	[cluster_minimal_version] [nvarchar](40) NOT NULL,
	[storage_pool_minimal_version] [nvarchar](40) NOT NULL,
 CONSTRAINT [PK_action_version_map] PRIMARY KEY CLUSTERED 
(
	[action_type] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
end
go

/* Upgrade fencing options to client format*/

--upgrade old security bit settings
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_static' and COLUMN_NAME = 'pm_secured'))
begin
	declare @sql nvarchar(max)
	set @sql = 'update vds_static set pm_options = 	case  
	when  (Len(pm_options) = 0) and (pm_secured = 1) then ''secure=true''
	when  (Len(pm_options) > 0 ) and (pm_secured = 1)  then pm_options + '',secure=true''
	else
	pm_options
	end'
    exec sp_executesql @sql	
end
go

--upgrade port settings 
update vds_static set pm_options = 
case  
when  (pm_options ='') and (pm_port > 0) then 'slot=' + convert(nvarchar(10),pm_port)
when  (Len(pm_options) > 0 ) and (pm_port > 0)  then pm_options + ',slot=' + convert(nvarchar(10),pm_port)
else
pm_options
end
go

-- upgrade options set by the user
update vds_static set pm_port=0
update vds_static set pm_options = replace (pm_options,char(13),',')
update vds_static set pm_options = replace (pm_options,'yes','true')
update vds_static set pm_options = replace (pm_options,'no','false')
update vds_static set pm_options = replace (pm_options,'ssl','secure')
update vds_static set pm_options = replace (pm_options,'ipport','xxxx')
update vds_static set pm_options = replace (pm_options,'port','slot')
update vds_static set pm_options = replace (pm_options,'xxxx','port')
go


-- vdc_options change
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vdc_options' and COLUMN_NAME = 'version'))
begin
ALTER TABLE dbo.vdc_options ADD version nvarchar(40) NOT NULL CONSTRAINT DF_vdc_options_version DEFAULT 'general'
ALTER TABLE dbo.vdc_options DROP CONSTRAINT PK_vdc_options
ALTER TABLE dbo.vdc_options ADD CONSTRAINT
	PK_vdc_options PRIMARY KEY CLUSTERED 
	(
	option_id
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

CREATE NONCLUSTERED INDEX IX_vdc_options ON dbo.vdc_options
	(
	option_name
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
end
GO


-- Remove field num_of_cpus and add num_of_sockets and cpu_per_socket in vm_static table
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'num_of_sockets'))
begin
	ALTER TABLE vm_static ADD num_of_sockets int not null default 1
	ALTER TABLE vm_static ADD cpu_per_socket int not null default 1
end
go

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'num_of_cpus'))
begin

declare @sql nvarchar(max)
set @sql = 'UPDATE vm_static SET num_of_sockets=vm_static.num_of_cpus'
exec sp_executesql @sql
end

go

-- Remove field num_of_cpus and add num_of_sockets and cpu_per_socket in vm_templates table
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'num_of_sockets'))
begin
	ALTER TABLE vm_templates ADD num_of_sockets int not null default 1
	ALTER TABLE vm_templates ADD cpu_per_socket int not null default 1
end
go

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_templates' and COLUMN_NAME = 'num_of_cpus'))
begin
declare @sql nvarchar(max)
set @sql = 'UPDATE vm_templates SET num_of_sockets=vm_templates.num_of_cpus'
exec sp_executesql @sql
end
go

--Check existing VDS Power Management config and raise an alert if not configured
declare @audit_log_id int 
declare @vds_id int
declare @vds_name nvarchar(255)
declare @message nvarchar(max)
declare @dt datetime
set @dt = getdate()
DECLARE c1 CURSOR 
FOR
	SELECT  vds_id,vds_name from vds_static 
    where pm_enabled = 0 or pm_type = '' or pm_type IS  NULL
	OPEN c1
	FETCH NEXT FROM c1
	INTO @vds_id, @vds_name
	WHILE @@FETCH_STATUS = 0
	BEGIN  
		set @message = 'Power Management is not configured for Host ' + @vds_name
		exec dbo.InsertAuditLog @audit_log_id,@dt,9000,'VDS_ALERT_FENCING_IS_NOT_CONFIGURED',
             10,@message,NULL,NULL,@vds_id,@vds_name,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL
	FETCH NEXT FROM c1
	INTO @vds_id, @vds_name
	END
	CLOSE c1
	DEALLOCATE c1	
go

/*
Take all users that are attached to pool from user_vm_pool_map
Find all default tags of the user (type = 1) from 
tags ,tags_permissions_map and permissions
add records in tags_vm_pool_map (if not already exists)
*/
if (exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'user_vm_pool_map'))
begin

	declare @vm_pool_id int
	declare @user_id uniqueidentifier

	DECLARE c1 CURSOR READ_ONLY
	FOR
		select vm_pool_id, user_id from user_vm_pool_map
	OPEN c1

	FETCH NEXT FROM c1
	INTO @vm_pool_id, @user_id 

	WHILE @@FETCH_STATUS = 0
	BEGIN
		declare @tag_id int
		--get user default tag using permission definitions
		select @tag_id =  a.tag_id from tags a,tags_permissions_map b,permissions c
			where 
				a.tag_id = b.tag_id and
				b.permission_id  = c.id  and
				c.ad_element_id = @user_id and
				a.[type] = 1
		if @tag_id is not null and not exists (select * from tags_vm_pool_map 
					   where tag_id = @tag_id and vm_pool_id = @vm_pool_id)
		BEGIN
			insert tags_vm_pool_map (tag_id,vm_pool_id) values (@tag_id,@vm_pool_id)
		END
		-- end of specific user tags handling
		FETCH NEXT FROM c1
		INTO @vm_pool_id, @user_id 
	END
	CLOSE c1
	DEALLOCATE c1
end
go

--remove user_vm_pool_map and ad_vm_pool_group_map

if (exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'user_vm_pool_map'))
begin
	IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_pools_user' AND TABLE_NAME='user_vm_pool_map')
	begin
		ALTER TABLE user_vm_pool_map drop CONSTRAINT [vm_pools_user]
		ALTER TABLE user_vm_pool_map drop CONSTRAINT [vm_pools_user_id]
	end
	DROP table user_vm_pool_map
end
go

if (exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'ad_vm_pool_group_map'))
begin
	IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='ad_vm_pool_group_map_group' AND TABLE_NAME='ad_vm_pool_group_map')
	begin
		ALTER TABLE ad_vm_pool_group_map drop CONSTRAINT [ad_vm_pool_group_map_group]
		ALTER TABLE ad_vm_pool_group_map drop CONSTRAINT [ad_vm_pool_group_map_vm_pool]
	end
	DROP table ad_vm_pool_group_map
end
go

-- Add Creation & modification dates to images for history usage

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'images' and COLUMN_NAME = '_create_date'))
begin

	ALTER TABLE images ADD  [_create_date] datetime default getdate(),
 							[_update_date] datetime default NULL
end
go

update images set [_create_date] = getdate() where [_create_date] is null
go

-- change the size of vds_unique_id to 128
alter table vds_static alter column vds_unique_id nvarchar(128)
-- [vds_tools_version_map]
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_tools_version_map' and COLUMN_NAME = 'cluster_version'))
begin
	-- add new fields [cluster_version], [storage_domain_id] and foreign key to storage_domain_static
	ALTER TABLE vds_tools_version_map ADD	[storage_domain_id] uniqueidentifier CONSTRAINT [FK_vds_tools_version_map_storage_domain_static] 
			FOREIGN KEY([storage_domain_id]) REFERENCES [dbo].[storage_domain_static] ([id]) ON DELETE CASCADE,
											[cluster_version] nvarchar(40)
											
	-- insert data
	declare @sql nvarchar(max)
		-- set 2.1 for all old iso files in table and get the correct iso domain by the pool id in the table
	set @sql = 'UPDATE vds_tools_version_map SET cluster_version = ''2.1'', storage_domain_id = 
	(select id from storage_domains where storage_pool_id = vds_tools_version_map.storage_pool_id and storage_domain_type = 2)'
	exec sp_executesql @sql
		-- delete entries without iso domain (pool doesn't exist or no ISO domain)
	set @sql = 'delete from vds_tools_version_map where storage_domain_id is null'
	exec sp_executesql @sql
	
	-- make new fields not null
	ALTER TABLE vds_tools_version_map ALTER column [storage_domain_id] uniqueidentifier not null
	ALTER TABLE vds_tools_version_map ALTER column [cluster_version] nvarchar(40) not null
	
	-- drop old PK [PK_vds_tools_version_map]
	ALTER TABLE vds_tools_version_map DROP constraint [PK_vds_tools_version_map]
	
	-- create new PK
	ALTER TABLE vds_tools_version_map ADD CONSTRAINT
	PK_vds_tools_version_map PRIMARY KEY CLUSTERED 
	(
	[storage_domain_id] ASC,
	[cluster_version] ASC,
	[tools_version] ASC
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	
end
go


-- add forreign key vds_id to vds_spm_id_map
-- Remove first all vds_id's from map that no longer exists in vds_static

DELETE from vds_spm_id_map where
vds_id not in (select vds_id from vds_static)
go

IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_spm_id_map_vds_id' AND TABLE_NAME='vds_spm_id_map')
begin
    ALTER TABLE [dbo].[vds_spm_id_map]  WITH CHECK ADD  CONSTRAINT [FK_vds_spm_id_map_vds_id] FOREIGN KEY([vds_id]) 
    REFERENCES [dbo].[vds_static] ([vds_id]) ON DELETE CASCADE
end
go

 --extend column length for user name 
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'users' and COLUMN_NAME = 'username' and CHARACTER_MAXIMUM_LENGTH = 255))
begin
	alter table users alter column username nvarchar(255)
	alter table audit_log alter column [user_name] nvarchar(255)
	alter table vm_dynamic alter column guest_cur_user_name nvarchar(255)
end
GO

 --extend description column length of all entities to nvarchar(max) => -1 in INFORMATION_SCHEMA.COLUMNS
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'tags' and COLUMN_NAME = 'description' and CHARACTER_MAXIMUM_LENGTH = -1))
begin
	alter table tags alter column description nvarchar(max)
	alter table custom_actions alter column description nvarchar(max)
	alter table image_templates alter column description nvarchar(max)
	alter table images alter column description nvarchar(max)
	alter table vm_templates alter column description nvarchar(max)
	alter table vm_static alter column description nvarchar(max)
	alter table vds_groups alter column description nvarchar(max)
	alter table vm_pools alter column vm_pool_description nvarchar(max)
	alter table storage_pool alter column description nvarchar(max)
	alter table network alter column description nvarchar(max)
end
GO

-- upgrade image (snapshot) description

update images 
set description = substring(description,4,len(description))
where substring(description,1,4) = 'VDC_'


-- change disk_image_dynamic key from image_group_id to image_id
if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'disk_image_dynamic' and COLUMN_NAME = 'image_id'))
begin
	-- drop old PK [PK_disk_image_dynamic]
	ALTER TABLE disk_image_dynamic DROP constraint [PK_disk_image_dynamic]

	-- add new fields [image_id] and foreign key to storage_domain_static
	ALTER TABLE disk_image_dynamic ADD [image_id] uniqueidentifier CONSTRAINT [FK_disk_image_dynamic_images]
			FOREIGN KEY([image_id]) REFERENCES [dbo].[images] ([image_guid]) ON DELETE CASCADE
											
	-- insert data
	declare @sql nvarchar(max)
	-- insert disk_image_dynamic all images with the information of the current image
	set @sql = 
'insert into disk_image_dynamic(image_group_id, image_id, actual_num_of_sectors, read_rate, write_rate)
select images.image_guid as image_group_id, images.image_guid as image_id, disk_image_dynamic.actual_num_of_sectors, disk_image_dynamic.read_rate, disk_image_dynamic.write_rate 
from images, disk_image_dynamic where images.image_group_id = disk_image_dynamic.image_group_id'
	exec sp_executesql @sql
	
	-- delete old entries without image_id
	set @sql = 'delete from disk_image_dynamic where image_id is null'
	exec sp_executesql @sql
	
	-- make new field not null
	ALTER TABLE disk_image_dynamic ALTER column [image_id] uniqueidentifier not null
	
	-- create new PK
	ALTER TABLE disk_image_dynamic ADD CONSTRAINT
	[PK_disk_image_dynamic] PRIMARY KEY CLUSTERED 
	(
	[image_id] ASC
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

end
GO

--update default tag permissions from Super User to VDI User role
update [permissions ] set role_id = '00000000-0000-0000-0001-000000000003' 
where id in (select permission_id from tags_permissions_map inner join tags on tags_permissions_map.tag_id = tags.tag_id
             where type = 1)
GO

if (not exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_dynamic' and COLUMN_NAME = 'host_os'))
begin
	ALTER TABLE vds_dynamic ADD host_os nvarchar(max) null
	ALTER TABLE vds_dynamic ADD kvm_version nvarchar(max) null
	ALTER TABLE vds_dynamic ADD spice_version nvarchar(max) null
	ALTER TABLE vds_dynamic ADD kernel_version nvarchar(max) null
end
go

-- change connection column to support case sensitive queries
ALTER TABLE dbo.storage_server_connections ALTER COLUMN connection nvarchar(250) COLLATE SQL_Latin1_General_CP1_CS_AS  NOT NULL
GO


/************************************************************************
				The following should be included in any upgrade
************************************************************************/

-- Upgrade VdcBootStrapUrl , should be changed for each new release

update vdc_options set option_value =  replace(option_value,'/4/4/','/4/5/') where option_name = 'VdcBootStrapUrl'
go


/************************************************************************
				DROP/RENAMING COLUMN  DB OBJECTS HERE !!!!
                ******************************************
	 This must be done on last step since  views may be used by dynamic sql
	 earlier ,so , if we drop that erlier, the view will not be updated and 
     we can not use it.
************************************************************************/

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'default_boot_device'))
begin
	alter table vm_static drop constraint DF_vm_static_default_boot_device
	ALTER TABLE vm_static drop COLUMN [default_boot_device]
	alter table vm_templates drop constraint DF_vm_templates_default_boot_device
	ALTER TABLE vm_templates drop COLUMN [default_boot_device]
	ALTER TABLE vm_dynamic drop COLUMN [boot_device]
end
go

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_static' and COLUMN_NAME = 'pm_secured'))
begin
	ALTER TABLE vds_static DROP COLUMN [pm_secured]
end
go

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vm_static' and COLUMN_NAME = 'num_of_cpus'))
begin
	ALTER TABLE vm_static DROP COLUMN num_of_cpus
	ALTER TABLE vm_templates DROP constraint DEF_vm_templates_num_of_cpus
	ALTER TABLE vm_templates DROP COLUMN num_of_cpus
end
go
	
if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'vds_tools_version_map' and COLUMN_NAME = 'storage_pool_id'))
begin
	-- drop old fields storage_pool_id, vds_minimal_version
	ALTER TABLE vds_tools_version_map DROP COLUMN storage_pool_id
	ALTER TABLE vds_tools_version_map DROP COLUMN vds_minimal_version
end
go

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'disk_image_dynamic' and COLUMN_NAME = 'image_group_id'))
begin
	-- drop old field image_group_id
	ALTER TABLE disk_image_dynamic DROP COLUMN image_group_id
end
go


if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'storage_domain_static' and COLUMN_NAME = 'storage_pool_id'))
begin
	ALTER TABLE storage_domain_static drop CONSTRAINT [fk_storage_domain_static_storage_pool_id] 
	ALTER TABLE storage_domain_static drop COLUMN storage_pool_id
	ALTER TABLE storage_domain_dynamic drop COLUMN status
end
go

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'images' and COLUMN_NAME = 'num_of_sectors'))
begin
	exec sp_rename 'images.num_of_sectors' , 'size'
end
go 

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'image_templates' and COLUMN_NAME = 'num_of_sectors'))
begin
	exec sp_rename 'image_templates.num_of_sectors' , 'size'
end
go 

if (exists (select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'disk_image_dynamic' and COLUMN_NAME = 'actual_num_of_sectors'))
begin
	exec sp_rename 'disk_image_dynamic.actual_num_of_sectors' , 'actual_size' 
end
go 

--Drop Constraints 
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_vm_interface_vm_templates]') AND parent_object_id = OBJECT_ID(N'[dbo].[vm_interface]'))
	ALTER TABLE [dbo].[vm_interface] DROP CONSTRAINT [FK_vm_interface_vm_templates]
go

-- index changes 

IF  EXISTS (SELECT name FROM sysindexes WHERE name = N'IDX_vm_interface_vm_guid_name')
	drop index [IDX_vm_interface_vm_guid_name] ON [dbo].[vm_interface] 
go

print 'Upgrade script completed.'
go
