PRINT 'Processing network_sp.sql'

----------------------------------------------------------------
-- [dbo].[network] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertnetwork')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertnetwork] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertnetwork]
    @addr nvarchar(50) = NULL,
	@description nvarchar(max) = NULL,
	@id uniqueidentifier,
	@name nvarchar(50),
	@subnet nvarchar(20) = NULL,
	@gateway nvarchar(20) = NULL,
	@type int = 0,
	@vlan_id int = NULL,
    @stp bit = 0,
    @storage_pool_id uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[network] ([addr], [description], [id], [name], [subnet], [gateway], [type], [vlan_id], [stp], [storage_pool_id])
	VALUES (@addr, @description, @id, @name, @subnet, @gateway, @type, @vlan_id, @stp, @storage_pool_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatenetwork')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatenetwork] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatenetwork]
    @addr nvarchar(50) = NULL,
	@description nvarchar(max) = NULL,
	@id uniqueidentifier,
	@name nvarchar(50),
	@subnet nvarchar(20) = NULL,
	@gateway nvarchar(20) = NULL,
	@type int = 0,
	@vlan_id int = NULL,
    @stp bit = 0,
    @storage_pool_id uniqueidentifier = NULL
AS
BEGIN

	--The [dbo].[network] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[network] 
	SET [addr] = @addr, [description] = @description, [name] = @name, [subnet] = @subnet, [gateway] = @gateway, [type] = @type, [vlan_id] = @vlan_id, [stp] = @stp, [storage_pool_id] = @storage_pool_id
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletenetwork')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletenetwork] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletenetwork]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[network] WITH (UPDLOCK)
	WHERE [id]=@id
	
    DELETE FROM [dbo].[network]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromnetwork')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromnetwork] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromnetwork]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
    SELECT  distinct   id, name, description, type, addr, subnet, gateway, 
                      vlan_id, stp, storage_pool_id, is_display, status 
    
FROM [dbo].[network_view] [network_view]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetnetworkByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetnetworkByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetnetworkByid] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[network_view].[addr] AS 'addr',
	[network_view].[description] AS 'description',
	[network_view].[id] AS 'id',
	[network_view].[name] AS 'name',
	[network_view].[subnet] AS 'subnet',
	[network_view].[gateway] AS 'gateway',
	[network_view].[type] AS 'type',
	[network_view].[vlan_id] AS 'vlan_id',
	[network_view].[stp] AS 'stp',
    [network_view].[storage_pool_id] as 'storage_pool_id',
    [network_view].[is_display] as 'is_display'
	FROM [dbo].[network_view] [network_view]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetnetworkByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetnetworkByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetnetworkByName] 
	@networkName nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[network_view].[addr] AS 'addr',
	[network_view].[description] AS 'description',
	[network_view].[id] AS 'id',
	[network_view].[name] AS 'name',
	[network_view].[subnet] AS 'subnet',
	[network_view].[gateway] AS 'gateway',
	[network_view].[type] AS 'type',
	[network_view].[vlan_id] AS 'vlan_id',
	[network_view].[stp] AS 'stp',
    [network_view].[storage_pool_id] as 'storage_pool_id',
    [network_view].[is_display] as 'is_display'
	FROM [dbo].[network_view] [network_view]
	WHERE [name]=@networkName

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllNetworkByStoragePoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllNetworkByStoragePoolId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllNetworkByStoragePoolId]    
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
    SELECT  distinct   network.id, network.name, network.description, network.type, network.addr, network.subnet, network.gateway, 
                      network.vlan_id, network.stp, network.storage_pool_id, convert(bit,0) as is_display, 0 as status 
	FROM [dbo].[network_view] [network]
    where storage_pool_id=@id

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllNetworkByClusterId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllNetworkByClusterId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllNetworkByClusterId]    
 @id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
SELECT DISTINCT
    network_view.id, 
    network_view.name, 
    network_view.description, 
    network_view.type, 
    network_view.addr, 
    network_view.subnet, 
    network_view.gateway, 
    network_view.vlan_id, 
    network_view.stp, 
    network_view.storage_pool_id, 
    network_cluster.*

	FROM [dbo].[network_view] 
	INNER JOIN network_cluster
	ON network_view.id=network_cluster.network_id
    where network_cluster.cluster_id=@id

	SET NOCOUNT OFF
END

GO


--The GetByFK stored procedure cannot be created because the [dbo].[network] table doesn't have at least one foreign key column or the foreign keys are also primary keys.

----------------------------------------------------------------
-- [dbo].[vds_interface] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertvds_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertvds_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertvds_interface]
    @addr nvarchar(20) = NULL,  
 @bond_name nvarchar(50) = NULL,  
 @bond_type int = NULL,  
 @gateway nvarchar(20) = NULL,  
 @id uniqueidentifier,  
 @is_bond bit = NULL,  
 @bond_opts nvarchar(max) = NULL,
 @mac_addr nvarchar(20) = NULL,  
 @name nvarchar(50),  
 @network_name nvarchar(50) = NULL,  
 @speed int = NULL,  
 @subnet nvarchar(20) = NULL,  
 @boot_protocol int = NULL,  
 @type int = NULL,  
 @vds_id uniqueidentifier,  
 @vlan_id int = NULL  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vds_interface] ([addr], [bond_name], [bond_type], [gateway], [id], [is_bond], [bond_opts], [mac_addr], [name], [network_name], [speed], [subnet], [boot_protocol], [type], [vds_id], [vlan_id])
	VALUES (@addr, @bond_name, @bond_type, @gateway, @id, @is_bond, @bond_opts, @mac_addr, @name, @network_name, @speed, @subnet, @boot_protocol, @type, @vds_id, @vlan_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatevds_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatevds_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatevds_interface]
    @addr nvarchar(20) = NULL,  
 @bond_name nvarchar(50) = NULL,  
 @bond_type int = NULL,  
 @gateway nvarchar(20) = NULL,  
 @id uniqueidentifier,  
 @is_bond bit = NULL,  
 @bond_opts nvarchar(max) = NULL,
 @mac_addr nvarchar(20) = NULL,  
 @name nvarchar(50),  
 @network_name nvarchar(50) = NULL,  
 @speed int = NULL,  
 @subnet nvarchar(20) = NULL,  
 @boot_protocol int = NULL,  
 @type int = NULL,  
 @vds_id uniqueidentifier,  
 @vlan_id int = NULL  
AS
BEGIN

	--The [dbo].[vds_interface] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vds_interface] 
	SET [addr] = @addr, [bond_name] = @bond_name, [bond_type] = @bond_type, [gateway] = @gateway, [is_bond] = @is_bond, [bond_opts] = @bond_opts, [mac_addr] = @mac_addr, [name] = @name, [network_name] = @network_name, [speed] = @speed, [subnet] = @subnet, [boot_protocol] = @boot_protocol, [type] = @type, [vds_id] = @vds_id, [vlan_id] = @vlan_id, _update_date = getdate()
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletevds_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletevds_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletevds_interface]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[vds_interface]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvm_interfaceByvm_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvm_interfaceByvm_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvm_interfaceByvm_id] 
	@vm_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT rx_rate, tx_rate, rx_drop, tx_drop, iface_status, type, gateway, subnet, addr, speed, vlan_id, bond_type, bond_name, is_bond, mac_addr, network_name, name, vds_id, vds_name, vm_guid, vmt_guid, vm_name, id	
	FROM [dbo].[interface_view]
	WHERE [vm_guid]=@vm_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getinterface_viewByvds_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getinterface_viewByvds_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getinterface_viewByvds_id] 
	@vds_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT rx_rate, tx_rate, rx_drop, tx_drop, iface_status, type, gateway, subnet, addr, speed, vlan_id, bond_type, bond_name, is_bond, bond_opts, mac_addr, network_name, name, vds_id, vds_name, vm_guid, vmt_guid, vm_name, id, boot_protocol
	
	FROM [dbo].[interface_view]
	WHERE [vds_id]=@vds_id

	SET NOCOUNT OFF
END

GO


----------------------------------------------------------------
-- [dbo].[vm_interface] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertvm_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertvm_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertvm_interface]
    @id uniqueidentifier,
	@mac_addr nvarchar(20) = NULL,
	@name nvarchar(50),
	@network_name nvarchar(50) = NULL,
	@speed int = NULL,
	@vm_guid uniqueidentifier = NULL,
	@vmt_guid uniqueidentifier = NULL, 
    @type int = 0
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_interface] ([id], [mac_addr], [name], [network_name], [speed], [vm_guid], [vmt_guid], [type])
	VALUES (@id, @mac_addr, @name, @network_name, @speed, @vm_guid, @vmt_guid, @type)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatevm_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatevm_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatevm_interface]
    @id uniqueidentifier,
	@mac_addr nvarchar(20) = NULL,
	@name nvarchar(50),
	@network_name nvarchar(50) = NULL,
	@speed int = NULL,
	@vm_guid uniqueidentifier = NULL,
	@vmt_guid uniqueidentifier = NULL,
    @type int = 0
AS
BEGIN

	--The [dbo].[vm_interface] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_interface] 
	SET [mac_addr] = @mac_addr, [name] = @name, [network_name] = @network_name, [speed] = @speed, [vm_guid] = @vm_guid, [vmt_guid] = @vmt_guid, [type] = @type, _update_date = getdate()
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletevm_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletevm_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletevm_interface]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[vm_interface] WITH (UPDLOCK)
	WHERE [id]=@id
	
    DELETE FROM [dbo].[vm_interface]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END


GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromvm_interface')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromvm_interface] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromvm_interface]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vm_interface].[id] AS 'id',
	[vm_interface].[mac_addr] AS 'mac_addr',
	[vm_interface].[name] AS 'name',
	[vm_interface].[network_name] AS 'network_name',
	[vm_interface].[speed] AS 'speed',
	[vm_interface].[vm_guid] AS 'vm_guid',
	[vm_interface].[vmt_guid] AS 'vmt_guid'
FROM [dbo].[vm_interface] [vm_interface]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvm_interfaceByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvm_interfaceByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvm_interfaceByid] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vm_interface].[id] AS 'id',
	[vm_interface].[mac_addr] AS 'mac_addr',
	[vm_interface].[name] AS 'name',
	[vm_interface].[network_name] AS 'network_name',
	[vm_interface].[speed] AS 'speed',
	[vm_interface].[vm_guid] AS 'vm_guid',
	[vm_interface].[vmt_guid] AS 'vmt_guid'
	FROM [dbo].[vm_interface] [vm_interface]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvm_interfaceByvm_guidAndByvmt_guid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvm_interfaceByvm_guidAndByvmt_guid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvm_interfaceByvm_guidAndByvmt_guid] 
	@vm_guid uniqueidentifier,
	@vmt_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vm_interface].[id] AS 'id',
	[vm_interface].[mac_addr] AS 'mac_addr',
	[vm_interface].[name] AS 'name',
	[vm_interface].[network_name] AS 'network_name',
	[vm_interface].[speed] AS 'speed',
	[vm_interface].[vm_guid] AS 'vm_guid',
	[vm_interface].[vmt_guid] AS 'vmt_guid'
	FROM [dbo].[vm_interface] [vm_interface]
	WHERE [vm_guid]=@vm_guid AND [vmt_guid]=@vmt_guid

	SET NOCOUNT OFF
END

GO


set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
GO

----------------------------------------------------------------
-- [dbo].[vm_interface_statistics] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertvm_interface_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertvm_interface_statistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertvm_interface_statistics]
    @id uniqueidentifier,
	@rx_drop decimal(18,0) = NULL,
	@rx_rate decimal(18,0) = NULL,
	@tx_drop decimal(18,0) = NULL,
	@tx_rate decimal(18,0) = NULL,
	@iface_status int = 0,
	@vm_id uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_interface_statistics] ([id], [rx_drop], [rx_rate], [tx_drop], [tx_rate], [vm_id], [iface_status])
	VALUES (@id, @rx_drop, @rx_rate, @tx_drop, @tx_rate, @vm_id,@iface_status)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatevm_interface_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatevm_interface_statistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatevm_interface_statistics]
    @id uniqueidentifier,  
 @rx_drop decimal(18,0) = NULL,  
 @rx_rate decimal(18,0) = NULL,  
 @tx_drop decimal(18,0) = NULL,  
 @tx_rate decimal(18,0) = NULL,  
 @iface_status int = 0,  
 @vm_id uniqueidentifier = NULL  
AS
BEGIN

	--The [dbo].[vm_interface_statistics] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_interface_statistics] 
	SET [rx_drop] = @rx_drop, [rx_rate] = @rx_rate, [tx_drop] = @tx_drop, [tx_rate] = @tx_rate, [vm_id] = @vm_id,  [iface_status] = @iface_status
	WHERE [id]=@id

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletevm_interface_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletevm_interface_statistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletevm_interface_statistics]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[vm_interface_statistics] WITH (UPDLOCK)
	WHERE [id]=@id

    DELETE FROM [dbo].[vm_interface_statistics]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END

GO


----------------------------------------------------------------
-- [dbo].[vds_interface_statistics] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertvds_interface_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertvds_interface_statistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertvds_interface_statistics]
    @id uniqueidentifier,
	@rx_drop decimal(18,0) = NULL,
	@rx_rate decimal(18,0) = NULL,
	@tx_drop decimal(18,0) = NULL,
	@tx_rate decimal(18,0) = NULL,
	@iface_status int = 0,
	@vds_id uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vds_interface_statistics] ([id], [rx_drop], [rx_rate], [tx_drop], [tx_rate], [vds_id], [iface_status])
	VALUES (@id, @rx_drop, @rx_rate, @tx_drop, @tx_rate, @vds_id,@iface_status)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatevds_interface_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatevds_interface_statistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatevds_interface_statistics]
    @id uniqueidentifier,  
 @rx_drop decimal(18,0) = NULL,  
 @rx_rate decimal(18,0) = NULL,  
 @tx_drop decimal(18,0) = NULL,  
 @tx_rate decimal(18,0) = NULL,  
 @iface_status int = 0,  
 @vds_id uniqueidentifier = NULL  
AS
BEGIN

	--The [dbo].[vds_interface_statistics] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vds_interface_statistics] 
	SET [rx_drop] = @rx_drop, [rx_rate] = @rx_rate, [tx_drop] = @tx_drop, [tx_rate] = @tx_rate, [vds_id] = @vds_id,  [iface_status] = @iface_status
	WHERE [id]=@id

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletevds_interface_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletevds_interface_statistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletevds_interface_statistics]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	declare @val uniqueidentifier
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[vds_interface_statistics] WITH (UPDLOCK)
	WHERE [id]=@id

    DELETE FROM [dbo].[vds_interface_statistics]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END

GO




----------------------------------------------------------------
-- [dbo].[network_cluster] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertnetwork_cluster')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertnetwork_cluster] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertnetwork_cluster]
    @cluster_id uniqueidentifier,  
 @network_id uniqueidentifier,  
 @status int,   
    @is_display bit = 0  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[network_cluster] ([cluster_id], [network_id], [status], [is_display])
	VALUES (@cluster_id, @network_id, @status, @is_display)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatenetwork_cluster')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatenetwork_cluster] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatenetwork_cluster]
    @cluster_id uniqueidentifier,
	@network_id uniqueidentifier,
	@status int,
    @is_display bit = 0
AS
BEGIN

	UPDATE [dbo].[network_cluster] 
	SET [status] = @status, [is_display] = @is_display
	WHERE [cluster_id]=@cluster_id AND [network_id]=@network_id

END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatenetwork_cluster_status')
BEGIN
        EXEC('CREATE PROCEDURE [dbo].[Updatenetwork_cluster_status] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatenetwork_cluster_status]
    @cluster_id uniqueidentifier,
    @network_id uniqueidentifier,
    @status int
AS
BEGIN

        UPDATE [dbo].[network_cluster]
        SET [status] = @status
        WHERE [cluster_id]=@cluster_id AND [network_id]=@network_id

END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletenetwork_cluster')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletenetwork_cluster] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletenetwork_cluster]
	 @cluster_id uniqueidentifier,
	@network_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[network_cluster]
	WHERE [cluster_id]=@cluster_id AND [network_id]=@network_id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromnetwork_cluster')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromnetwork_cluster] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromnetwork_cluster]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[network_cluster].[cluster_id] AS 'cluster_id',
	[network_cluster].[network_id] AS 'network_id',
	[network_cluster].[status] AS 'status',
	[network_cluster].[is_display] AS 'is_display'
FROM [dbo].[network_cluster] [network_cluster]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromnetwork_clusterByClusterId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromnetwork_clusterByClusterId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromnetwork_clusterByClusterId]    
  @cluster_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[network_cluster].[cluster_id] AS 'cluster_id',
	[network_cluster].[network_id] AS 'network_id',
	[network_cluster].[status] AS 'status',
	[network_cluster].[is_display] AS 'is_display'
FROM [dbo].[network_cluster] [network_cluster]
    WHERE [cluster_id] = @cluster_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromnetwork_clusterByNetworkId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromnetwork_clusterByNetworkId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromnetwork_clusterByNetworkId]    
	 @network_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT *
FROM [dbo].[network_cluster] [network_cluster]
    WHERE [network_id] = @network_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getnetwork_clusterBycluster_idAndBynetwork_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getnetwork_clusterBycluster_idAndBynetwork_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getnetwork_clusterBycluster_idAndBynetwork_id] 
 @cluster_id uniqueidentifier,  
 @network_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[network_cluster].[cluster_id] AS 'cluster_id',
	[network_cluster].[network_id] AS 'network_id',
	[network_cluster].[status] AS 'status',
	[network_cluster].[is_display] AS 'is_display'
	FROM [dbo].[network_cluster] [network_cluster]
	WHERE [cluster_id]=@cluster_id AND [network_id]=@network_id

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetvmStaticByGroupIdAndNetwork')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetvmStaticByGroupIdAndNetwork] AS RETURN')
END

GO


ALTER PROCEDURE [dbo].[GetvmStaticByGroupIdAndNetwork]
  @groupId uniqueidentifier,  
     @networkName nvarchar(50)  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	select vm_static.* from interface_view
	inner join vm_static
	on vm_static.vm_guid = interface_view.vm_guid
	and network_name = @networkName
	and vm_static.vds_group_id=@groupId

    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getvm_interfaceBytemplate_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getvm_interfaceBytemplate_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getvm_interfaceBytemplate_id] 
	@template_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT rx_rate, tx_rate, rx_drop, tx_drop, iface_status, type, gateway, subnet, addr, speed, vlan_id, bond_type, bond_name, is_bond, mac_addr, network_name, name, vds_id, vds_name, vm_guid, vmt_guid, vm_name, id	
	FROM [dbo].[interface_view]
	WHERE [vmt_guid]=@template_id

	SET NOCOUNT OFF
END
GO
