PRINT 'Processing DiskImageDynamic_sp.sql'

----------------------------------------------------------------
-- [dbo].[disk_image_dynamic] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertdisk_image_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertdisk_image_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertdisk_image_dynamic]
    @image_id uniqueidentifier,
	@read_rate int = null,
	@write_rate int = null,
	@actual_size bigint = null
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[disk_image_dynamic] ([image_id], [read_rate], [write_rate], [actual_size])
	VALUES (@image_id, @read_rate, @write_rate, @actual_size)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatedisk_image_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatedisk_image_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatedisk_image_dynamic]
    @image_id uniqueidentifier,
	@read_rate int = null,
	@write_rate int = null,
	@actual_size bigint = null
AS
BEGIN

	--The [dbo].[disk_image_dynamic] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[disk_image_dynamic] 
	SET [read_rate] = @read_rate, [write_rate] = @write_rate, [actual_size] = @actual_size
	WHERE [image_id]=@image_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletedisk_image_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletedisk_image_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletedisk_image_dynamic]
	 @image_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[disk_image_dynamic]
	WHERE [image_id]=@image_id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromdisk_image_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromdisk_image_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromdisk_image_dynamic]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[disk_image_dynamic].[image_id] AS 'image_id',
	[disk_image_dynamic].[read_rate] AS 'read_rate',
	[disk_image_dynamic].[write_rate] AS 'write_rate',
	[disk_image_dynamic].[actual_size] AS 'actual_size'
FROM [dbo].[disk_image_dynamic] [disk_image_dynamic]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getdisk_image_dynamicByimage_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getdisk_image_dynamicByimage_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getdisk_image_dynamicByimage_id] 
	@image_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[disk_image_dynamic].[image_id] AS 'image_id',
	[disk_image_dynamic].[read_rate] AS 'read_rate',
	[disk_image_dynamic].[write_rate] AS 'write_rate',
	[disk_image_dynamic].[actual_size] AS 'actual_size'
	FROM [dbo].[disk_image_dynamic] [disk_image_dynamic]
	WHERE [image_id]=@image_id

	SET NOCOUNT OFF
END

GO