using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Reflection;
using System.Text;
using System.Windows.Interop;
using System.Xml.Linq;
using org.ovirt.engine.ui.uicommon;

namespace UI.WPFClient
{
	public class WPFConfigurator : Configurator
	{
		public WPFConfigurator()
		{
			IsAsync = true;
			IsAdmin = true;
			SpiceAdminConsole = true;
			SpiceFullScreen = false;
			LoadFromExternalSource();
		}

		private void LoadFromExternalSource()
		{
			//When application run locally, don't download anything from web server.
			//The default values will be used instead.
			if (BrowserInteropHelper.Source.IsFile)
			{
				return;
			}


			var client = new WebClient();
			string src = null;

			//Read the values from ExternalConfig.txt
			try
			{
				src = client.DownloadString(App.RelativePath + "ExternalConfig.txt");
			}
			catch (Exception)
			{
			}

			if (String.IsNullOrEmpty(src))
			{
				return;
			}

			using (TextReader reader = new StringReader(src))
			{
				XDocument doc = XDocument.Load(reader);
				foreach (XElement el in doc.Descendants(XName.Get("add")))
				{
					PropertyInfo prop = typeof(Configurator).GetProperty(el.Attribute(XName.Get("key")).Value);
					if (prop == null)
					{
						continue;
					}

					string strValue = el.Attribute(XName.Get("value")).Value;

					object value;
					if (prop.PropertyType == typeof(int))
					{
						value = Convert.ToInt32(strValue);
					}
					else if (prop.PropertyType == typeof(bool))
					{
						value = Convert.ToBoolean(strValue);
					}
					else if (prop.PropertyType == typeof(Version))
					{
						value = new Version(strValue.Replace(',', '.'));
					}
					else if (prop.PropertyType == typeof(ValidateServerCertificateEnum))
					{
						try
						{
							value = Enum.Parse(typeof(ValidateServerCertificateEnum), strValue.ToUpper());
						}
						catch
						// for some reason, value in ExternalConfig didn't fit to any of 
						// the enum values:
						{
							value = ValidateServerCertificateEnum.AUTO;
						}
					}
					else
					{
						value = strValue;
					}

					prop.SetValue(this, value, null);
				}
			}


			//Read the value from SpiceVersion.txt
			src = null;
			try
			{
				src = client.DownloadString(App.RelativePath + "SpiceVersion.txt");
			}
			catch (Exception)
			{
			}

			if (String.IsNullOrEmpty(src))
			{
				return;
			}

			SpiceVersion = new Version(src.Replace(',', '.'));
		}
	}
}
