using System;
using System.Collections.Generic;
using System.Text;
using log4net;

[assembly: log4net.Config.XmlConfigurator(Watch = true)]

namespace VdcUtils
{
	public class QLogger
	{
		public static QLogger Instance { get; set; }
		protected static ILog log;

		public bool IsDebugEnabled
		{
			get { return log.IsDebugEnabled; }
		}

		static QLogger()
		{
			log = LogManager.GetLogger("");
			Instance = new QLogger();
		}

		public void Debug(String msg)
		{
			log.Debug(msg);
		}

		public void Debug(string message, Exception exception)
		{
			log.Debug(message, exception);
		}

		public void DebugFormat(string format, params object[] args)
		{
			log.DebugFormat(format, args);
		}

		public void Error(string message)
		{
			log.Error(message);
		}

		public void Error(string message, Exception exception)
		{
			log.Error(message, exception);
		}

		public void ErrorFormat(string format, params object[] args)
		{
			log.ErrorFormat(format, args);
		}

		public void Fatal(string message)
		{
			log.Fatal(message);
		}

		public void Fatal(string message, Exception exception)
		{
			log.Fatal(message, exception);
		}

		public void FatalFormat(string format, params object[] args)
		{
			log.FatalFormat(format, args);
		}

		public void Info(string message)
		{
			log.Info(message);
		}

		public void Info(string message, Exception exception)
		{
			log.Info(message, exception);
		}

		public void InfoFormat(string format, params object[] args)
		{
			log.InfoFormat(format, args);
		}

		public void Warn(string message)
		{
			log.Warn(message);
		}

		public void Warn(string message, Exception exception)
		{
			log.Warn(message, exception);
		}

		public void WarnFormat(string format, params object[] args)
		{
			log.WarnFormat(format, args);
		}
	}
}
