using System;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class KeyValuePairValidation : IValidation
	{
		private bool allowAlsoKey { get; set; }

		public KeyValuePairValidation()
		{
			this.allowAlsoKey = false;
		}

		//allows key without value, i.e. key,key=value,key,key</param>
		public KeyValuePairValidation(bool allowAlsoKey)
		{
			this.allowAlsoKey = allowAlsoKey;
		}

		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();

			if (value != null && value is String && !((string)value).Equals(String.Empty))
			{
				string strValue = (string)value;

				if (strValue.EndsWith(","))
				{
					result.Success = false;
				}
				else
				{
					//Try parse value.
					foreach (string pair in strValue.Split(','))
					{
						if (!result.Success)
						{
							break;
						}

						string[] array = pair.Split('=');

						//if the split length is 2, its a 'key=value'
						//if the split length is 1 (key), we accept only when we allow it (allowAlsoKey==true)
						if (allowAlsoKey)
						{
							if (array.Length < 1 || array.Length > 2)
							{
								result.Success = false;
								break;
							}
						}
						else
						{
							if (array.Length != 2)
							{
								result.Success = false;
								break;
							}
						}
						
						foreach (string t in array)
						{
							if (String.IsNullOrEmpty(t.Trim()))
							{
								result.Success = false;
								break;
							}
						}
					}
				}
			}

			if (!result.Success)
			{
				if (!allowAlsoKey)
				{
					result.Reasons.Add("Value doesn't not match pattern: key=value,key=value...");
				}
				else
				{
					result.Reasons.Add("Value doesn't not match pattern: key=value,key,key=value...");
				}
			}

			return result;
		}
	}
}