﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.validation
{
    public class CustomPropertyValidation : IValidation
    {
		private List<string> CustomPropertiesKeysList { get; set; }
		public CustomPropertyValidation(List<string> customPropertiesKeysList)
		{
			CustomPropertiesKeysList = new List<string>();

			if (customPropertiesKeysList != null && customPropertiesKeysList.Count > 0)
			{
				foreach (string customPropertyKey in customPropertiesKeysList)
				{
					// make sure that only non-empty strings that contain '=' within them enter to the key list:
					if (!string.IsNullOrEmpty(customPropertyKey) && customPropertyKey.Contains("="))
					{
						CustomPropertiesKeysList.Add(customPropertyKey);
					}
				}
			}
		}
        #region IValidation Members

        public ValidationResult Validate(object value)
        {
            //check regex first
            RegexValidation regexValidation = 
                new RegexValidation
                {
					Expression = "(([a-zA-Z0-9_]+=[^;]+)+(;)?)(([a-zA-Z0-9_]+=[^;]+;+)*$)",
                    Message = "Field value should follow: <parameter=value;parameter=value;...>"
                };

            ValidationResult validationResult = regexValidation.Validate(value);
            if (validationResult.Success == false)
            {
                return validationResult;
            }

            string[] split;

			if (value == null || ((string)(value)).Trim() == string.Empty)
			{
				split = new string[0];
			}
			else
			{
				split = ((string)value).Split(';');
			}
			if (CustomPropertiesKeysList == null || CustomPropertiesKeysList.Count == 0 || String.IsNullOrEmpty(CustomPropertiesKeysList[0]))
			{
				return new ValidationResult();
			}
            
            foreach (string line in split)
            {
				if (string.IsNullOrEmpty(line))
				{
					continue;
				}
            	bool contains = false;
                // TODO: GILAD: Validate values according to RegExps (keys will be available via drop-down in the new design)
                // Also, put an appropriate validation messgae when necessary.
				foreach (string validKey in CustomPropertiesKeysList)
                {
					if (line.Substring(0, line.IndexOf('=') < 0 ? line.Length : line.IndexOf('=')).Equals(validKey.Substring(0, validKey.IndexOf('='))))
					{
						contains = true;
						break;
					}
                }
                if (!contains)
                {
                	string reasonStr = "One of the parameters isn't supported";
					reasonStr += " (available parameter(s): ";
					foreach (string keyValue in CustomPropertiesKeysList)
                	{
						reasonStr += keyValue.Substring(0, keyValue.IndexOf('=')) + ", ";
                	}
					reasonStr = reasonStr.Remove(reasonStr.Length - 2);
					reasonStr += ")";
					List<string> reason = new List<string>();
					reason.Add(reasonStr);
					return new ValidationResult { Success = false, Reasons = reason };
                }
            }
			string falseProperty = null;
			foreach (string line in split)
			{
				if (string.IsNullOrEmpty(line))
				{
					continue;
				}
				foreach (string validKey in CustomPropertiesKeysList)
				{
					if (line.Substring(0, line.IndexOf('=')).Equals(validKey.Substring(0, validKey.IndexOf('='))))
					{
						RegexValidation testValue = new RegexValidation {Expression = validKey.Substring(validKey.IndexOf('=') + 1)};
						if (testValue.Validate(line.Substring(line.IndexOf('=') + 1)).Success == false)
						{
							falseProperty = validKey;
							continue;
						}
					}
				}
			}
        	if(falseProperty !=null)
            {
				List<string> reason = new List<string>();
				reason.Add("the value for parameter <" + falseProperty.Substring(0, falseProperty.IndexOf('=')) + "> should be in the format of: <" + falseProperty.Substring(falseProperty.IndexOf('=') + 1) + ">");
				return new ValidationResult { Success = false, Reasons = reason };
            	
            }
        	return new ValidationResult();
        }

        #endregion
    }
}
