using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicompat;

using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VncConsoleModel : ConsoleModel
	{
		private readonly IVnc vnc;


		public VncConsoleModel()
		{
			Title = "VNC";

			vnc = (IVnc)TypeResolver.Instance.Resolve(typeof(IVnc));
		}

		protected override void Connect()
		{
			if (Entity != null)
			{
				Logger.Debug("Connecting to VNC console...");

				//Don't connect if there VM is not running on any host.
				if (Entity.run_on_vds == null)
				{
					return;
				}

				//Determine the display IP.
				string displayIp = Entity.display_ip;
				if (String.IsNullOrEmpty(Entity.display_ip) || Entity.display_ip == "0")
				{
					VDS host = DataProvider.GetHostById(Entity.run_on_vds.Value);
					if (host == null)
					{
						return;
					}

					displayIp = host.host_name;
				}

                string otp64 = null;
				VdcReturnValueBase ticketReturnValue = Frontend.RunAction(VdcActionType.SetVmTicket,
					new SetVmTicketParameters(Entity.vm_guid, null, 120));

                if (ticketReturnValue != null && ticketReturnValue.ActionReturnValue != null)
                {
                    otp64 = (string)ticketReturnValue.ActionReturnValue;
                }

				vnc.Host = displayIp;
				vnc.Port = Entity.display.GetValueOrDefault();
				vnc.Password = otp64;
				vnc.Title = Entity.vm_name;

				//Try to connect.
				try
				{
					vnc.Connect();
					UpdateActionAvailability();
				}
				catch (Exception ex)
				{
					Logger.Error("Exception on VNC connect", ex);
				}
			}
		}

		protected override void UpdateActionAvailability()
		{
			base.UpdateActionAvailability();

			ConnectCommand.IsExecutionAllowed = Entity != null
				&& Entity.display_type == DisplayType.vnc
				&& (Entity.status == VMStatus.PoweringUp || Entity.status == VMStatus.Up || Entity.status == VMStatus.RebootInProgress || Entity.status == VMStatus.PoweringDown || Entity.status == VMStatus.Paused);
		}
	}
}
