using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using System.ComponentModel;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
    public class MigrateModel : Model
	{
		#region Properties

		public ListModel Hosts { get; private set; }

		public List<VM> VmList { get; set; }

        public bool VmsOnSameCluster{get;set;}

		private bool isAutoSelect;
		public bool IsAutoSelect
		{
			get { return isAutoSelect; }
			set
			{
				if (isAutoSelect != value)
				{
					isAutoSelect = value;
					Hosts.IsChangable = !isAutoSelect;
					OnPropertyChanged(new PropertyChangedEventArgs("IsAutoSelect"));
					IsSameVdsMessageVisible = !value;
				}
			}
		}

		private bool isHostSelAvailable;
		public bool IsHostSelAvailable
		{
			get { return isHostSelAvailable; }
			set
			{
				if (isHostSelAvailable != value)
				{
					isHostSelAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsHostSelAvailable"));
				}
			}
		}

    	private bool noSelAvailable;
		public bool NoSelAvailable
		{
			get { return noSelAvailable; }
			set
			{
				if (noSelAvailable != value)
				{
					noSelAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NoSelAvailable"));
				}
			}
		}


    	private bool isSameVdsMessageVisible;
		public bool IsSameVdsMessageVisible
		{
			get { return isSameVdsMessageVisible; }
			set
			{
				isSameVdsMessageVisible = value & hasSameVdsMessage & !IsAutoSelect;
				OnPropertyChanged(new PropertyChangedEventArgs("IsSameVdsMessageVisible"));
			}
		}


		//OnPropertyChanged(new PropertyChangedEventArgs("IsSameVdsMessageVisible"));
		public bool hasSameVdsMessage { get; set; }

		#endregion

		public MigrateModel()
		{
			Hosts = new ListModel();
			Hosts.SelectedItemChangedEvent.addListener(this);
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);
			if (sender == Hosts && VmsOnSameCluster)
			{
				VDS selectedHost = (VDS)Hosts.SelectedItem;
				hasSameVdsMessage = false;
				foreach (VM vm in VmList)
				{
					if(selectedHost.vds_id.Value.Equals(vm.run_on_vds.Value))
					{
						hasSameVdsMessage = true;
						break;
					}
				}
				IsSameVdsMessageVisible = hasSameVdsMessage;
			}
		}
	}
}
