using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class DiskModel : Model
	{
		#region Properties

		public bool IsNew { get; set; }
		public string Name { get; set; }
		public VolumeFormat VolumeFormat { get; set; }
		public DateTime CreationDate { get; set; }
		public int ActualSize { get; set; }
		public DiskType DiskType { get; set; }
		public EntityModel Size { get; set; }
		public ListModel Preset { get; set; }
		public ListModel VolumeType { get; set; }
		public ListModel Interface { get; set; }
		public ListModel StorageDomain { get; set; }
		public EntityModel WipeAfterDelete { get; set; }
		public EntityModel IsBootable { get; set; }

		#endregion

		public DiskModel()
		{
			Size = new EntityModel();
			Size.IsValid = true;

			Interface = new ListModel();
			StorageDomain = new ListModel();

			Preset = new ListModel();
			Preset.SelectedItemChangedEvent.addListener(this);

			VolumeType = new ListModel();
			VolumeType.Items = DataProvider.GetVolumeTypeList();
			VolumeType.SelectedItemChangedEvent.addListener(this);

			WipeAfterDelete = new EntityModel();
			WipeAfterDelete.Entity = false;
			WipeAfterDelete.EntityChangedEvent.addListener(this);

			IsBootable = new EntityModel();
			IsBootable.Entity = false;
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(EntityModel.EntityChangedEventDefinition) && sender == WipeAfterDelete)
			{
				WipeAfterDelete_EntityChanged(args);
			}
			else if (ev.Equals(ListModel.SelectedItemChangedEventDefinition) && sender == Preset)
			{
				Preset_SelectedItemChanged();
			}
			else if (ev.Equals(ListModel.SelectedItemChangedEventDefinition) && sender == VolumeType)
			{
				VolumeType_SelectedItemChanged();
			}
		}

		void Preset_SelectedItemChanged()
		{
			DiskImageBase preset = (DiskImageBase)Preset.SelectedItem;
			VolumeFormat = preset.volume_format;
			VolumeType.SelectedItem = preset.volume_type;
		}

		void VolumeType_SelectedItemChanged()
		{
			UpdateVolumeFormat();
		}

		private void UpdateVolumeFormat()
		{
			VolumeType volumeType =
				VolumeType.SelectedItem == null ?
				VdcCommon.BusinessEntities.VolumeType.Unassigned :
				(VolumeType)VolumeType.SelectedItem;

			StorageType storageType =
				StorageDomain.SelectedItem == null ?
				StorageType.UNKNOWN :
				((storage_domains)StorageDomain.SelectedItem).storage_type;

			VolumeFormat = DataProvider.GetDiskVolumeFormat(volumeType, storageType);
		}

		void WipeAfterDelete_EntityChanged(EventArgs e)
		{
			if (!WipeAfterDelete.IsChangable && (bool)WipeAfterDelete.Entity)
			{
				WipeAfterDelete.Entity = false;
			}
		}

		internal bool Validate()
		{
			IntegerValidation intValidation =
				new IntegerValidation
				{
					Minimum = 1,
					Maximum = DataProvider.GetDiskMaxSize()
				};
			Size.ValidateEntity(new IValidation[] { new NotEmptyValidation(), intValidation });
			
			StorageDomain.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			return Size.IsValid && StorageDomain.IsValid;
		}
	}
}
