using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.vms;

using VdcCommon;
using VdcCommon.Interfaces;
using VdcCommon.Users;

using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class UserVmListModel : VmListModel
	{
		#region Commands

		public UICommand AttachCommand { get; private set; }
		public UICommand DetachCommand { get; private set; }

		#endregion

		#region Properties

		public new DbUser Entity
		{
			get { return base.Entity as DbUser; }
			set { base.Entity = value; }
		}

		#endregion

		public UserVmListModel()
		{
			Title = "Virtual Machines";

			AttachCommand = new UICommand("Attach", this);
			DetachCommand = new UICommand("Detach", this);

			UpdateActionAvailability();
		}

		private void Attach()
		{
			if (Window != null)
			{
				return;
			}

			FindDesktopModel model = new FindDesktopModel();
			Window = model;
			model.Title = "Add Desktop(s) to User/AD Group";
			model.HashName = "add_desktop_to_user_ad_group";
			model.ExcludeItems = Items;

			model.Commands.Add(
				new UICommand("OnAttach", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		public void OnAttach()
		{
			FindDesktopModel model = (FindDesktopModel)Window;
			if (model.SelectedItems == null)
			{
				Cancel();
				return;
			}

			//			var items = model.Items.Cast<EntityModel>()
			//				.Where(Selector.GetIsSelected)
			//				.Select(a => (VM)a.Entity)
			//				.ToList();
			List<VM> items = new List<VM>();
			foreach (object item in model.Items)
			{
				EntityModel a = (EntityModel)item;
				if (a.IsSelected)
				{
					items.Add((VM)a.Entity);
				}
			}

			List<VdcActionParametersBase> prms = new List<VdcActionParametersBase>();

			if (Entity.IsGroup)
			{
				foreach (VM a in items)
				{
					prms.Add(new VmToAdGroupParameters(a.vm_guid, new ad_groups(Entity.user_id, Entity.name, Entity.domain)));
				}
				// TODO: Remove Model! VmUserListModel should be removed!
				//Frontend.RunMultipleActions(VdcActionType.AttachVmToAdGroup, prms);
			}
			else
			{
				foreach (VM a in items)
				{
					prms.Add(new VmToUserParameters(new VdcUser(Entity.user_id, Entity.username, Entity.domain), a.vm_guid));
				}
				//Attach vm to users
				// TODO: Remove Model! VmUserListModel should be removed!
				//Frontend.RunMultipleActions(VdcActionType.AttachVmToUser, prms);
			}

			//if (Entity.IsGroup)
			//{
			//    Frontend.RunMultipleActions(VdcActionType.AttachVmToAdGroup,
			//        items
			//        .Select(a => (VdcActionParametersBase)new VmToAdGroupParameters(a.vm_guid,
			//            new ad_groups(Entity.user_id, Entity.name, Entity.domain)))
			//        .ToList()
			//    );
			//}


			//else
			//{
			//    Frontend.RunMultipleActions(VdcActionType.AttachVmToUser,
			//        items
			//        .Select(a => (VdcActionParametersBase)new VmToUserParameters(
			//            new VdcUser(Entity.user_id, Entity.username, Entity.domain), a.vm_guid))
			//        .ToList()
			//    );
			//}

			Cancel();
		}

		public void Detach()
		{
			if (Window != null)
			{
				return;
			}

			ConfirmationModel model = new ConfirmationModel();
			Window = model;
			model.Title = "Detach Virtual Machine(s)";
			model.HashName  = "detach_virtual_machine";
			model.Message = "Are you sure you want to Detach from the user the following Virtual Machine(s)";
			
			List<string> list = new List<string>();
			foreach (object item in SelectedItems)
			{
				VM a = (VM)item;
				list.Add(a.vm_name);
			}
			model.Items = list;


			model.Commands.Add(
				new UICommand("OnDetach", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		public void OnDetach()
		{
			List<VM> items = Linq.Cast<VM>(SelectedItems);

			List<VdcActionParametersBase> parameters = new List<VdcActionParametersBase>();
			//
			foreach (VM a in items)
			{
				parameters.Add((VdcActionParametersBase)new VmToAdElementParameters(Entity.user_id, a.vm_guid));
			}

			//			var parameters = items
			//				.Select(a => (VdcActionParametersBase)new VmToAdElementParameters(Entity.user_id, a.vm_guid))
			//				.ToList();

			// TODO: Remove Model! VmUserListModel should be removed!

			//if (Entity.IsGroup)
			//{
			//    Frontend.RunMultipleActions(VdcActionType.DetachVmFromAdGroup, parameters);
			//}
			//else
			//{
			//    Frontend.RunMultipleActions(VdcActionType.DetachVmFromUser, parameters);
			//}

			Cancel();
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				SearchString = String.Format("VMs: users.name={0}", Entity.name);
				base.Search();
			}
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemsChanged()
		{
			base.SelectedItemsChanged();
			UpdateActionAvailability();
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "name")
			{
				SearchCommand.Execute();
				UpdateActionAvailability();
			}
		}

		private void UpdateActionAvailability()
		{
			ArrayList items = SelectedItems != null && SelectedItem != null ? (ArrayList)SelectedItems : new ArrayList();

			DetachCommand.IsExecutionAllowed = items.Count > 0
				&& VdcActionUtils.CanExecute(items, typeof(DbUser), VdcActionType.RemoveUser);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == AttachCommand)
			{
				Attach();
			}
			if (command == DetachCommand)
			{
				Detach();
			}
			if (command.Name == "OnAttach")
			{
				OnAttach();
			}
			if (command.Name == "OnDetach")
			{
				OnDetach();
			}
			if (command.Name == "Cancel")
			{
				Cancel();
			}
		}
	}
}
