using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicompat;
using VdcCommon;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.Interfaces;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public class VmBasicDiskListModel : SearchableListModel
	{
		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				SearchCommand.Execute();
			}
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			if (Entity is VM)
			{
				VM vm = (VM) Entity;

				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
				{
					IList<DiskImage> disks = (IList<DiskImage>)((VdcQueryReturnValue)ReturnValue).ReturnValue;
					List<DiskImage> diskList = new List<DiskImage>();
					diskList.AddRange(disks);
					diskList.Sort(new Linq.DiskByInternalDriveMappingComparer());

					SearchableListModel searchableListModel = (SearchableListModel)model;
					searchableListModel.Items = (IEnumerable)diskList;
				};//END_DELEGATE

				Frontend.RunQuery(VdcQueryType.GetAllDisksByVmId, new GetAllDisksByVmIdParameters(vm.vm_guid), _asyncQuery);
			}
			else if (Entity is vm_pools)
			{
				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
				{
					VM vm = (VM)result;
					if (vm != null)
					{
						VmBasicDiskListModel poolDiskListModel = (VmBasicDiskListModel)model;

						AsyncQuery _asyncQuery1 = new AsyncQuery();
						_asyncQuery1.Model = poolDiskListModel;
						/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object ReturnValue)
						{
							IList<DiskImage> disks = (IList<DiskImage>)((VdcQueryReturnValue)ReturnValue).ReturnValue;
							List<DiskImage> diskList = new List<DiskImage>();
							diskList.AddRange(disks);
							diskList.Sort(new Linq.DiskByInternalDriveMappingComparer());

							SearchableListModel searchableListModel = (SearchableListModel)model1;
							searchableListModel.Items = (IEnumerable)diskList;
						};//END_DELEGATE
						Frontend.RunQuery(VdcQueryType.GetAllDisksByVmId, new GetAllDisksByVmIdParameters(vm.vm_guid), _asyncQuery1);
					}
				};//END_DELEGATE

				vm_pools pool = (vm_pools)Entity;
				AsyncDataProvider.GetAnyVm(_asyncQuery, pool.vm_pool_name);
			}
		}

		#region IFrontendActionAsyncCallback Members

		public void OnSuccess(FrontendActionAsyncResult result)
		{
		}

		public void OnFailure(FrontendActionAsyncResult result)
		{
		}

		#endregion
	}
}
