﻿using System.Text;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicompat;
using VdcCommon;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.Interfaces;
using System.Collections.Generic;
using System;
using System.Collections.ObjectModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public class UserPortalBasicListModel : IUserPortalListModel, IVmPoolResolutionService
	{
		#region Events

		public static EventDefinition SearchCompletedEventDefinition;
		public Event SearchCompletedEvent { get; private set; }

		#endregion
               
		
		#region Properties
	
		#endregion

		public ListModel vmBasicDiskListModel { get; private set; }
		public List<VM> vms { get; set; }
		public List<vm_pools> pools { get; set; }

		public EntityModel SelectedItemDefinedMemory { get; private set; }
		public EntityModel SelectedItemNumOfCpuCores { get; private set; }

		private readonly Dictionary<Guid, List<ConsoleModel>> cachedConsoleModels;
	
		static UserPortalBasicListModel()
		{
			SearchCompletedEventDefinition = new EventDefinition("SearchCompleted", typeof(UserPortalBasicListModel));
		}

		public UserPortalBasicListModel()
		{
			SearchCompletedEvent = new Event(SearchCompletedEventDefinition);

			SelectedItemDefinedMemory = new EntityModel();
			SelectedItemNumOfCpuCores = new EntityModel();

			cachedConsoleModels = new Dictionary<Guid, List<ConsoleModel>>();
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			{
				UserPortalBasicListModel userPortalBasicListModel = (UserPortalBasicListModel) model;
				userPortalBasicListModel.vms = (List<VM>) ((VdcQueryReturnValue)ReturnValue).ReturnValue;
				userPortalBasicListModel.OnVmAndPoolLoad();
			};//END_DELEGATE

			Frontend.RunQuery(VdcQueryType.GetUserVmsByUserIdAndGroups, new GetUserVmsByUserIdAndGroupsParameters(Frontend.LoggedInUser.UserId), _asyncQuery);

			AsyncQuery _asyncQuery1 = new AsyncQuery();
			_asyncQuery1.Model = this;
			/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model, Object ReturnValue)
			{
				if (ReturnValue != null)
				{
					UserPortalBasicListModel userPortalBasicListModel = (UserPortalBasicListModel) model;
					userPortalBasicListModel.pools = (List<vm_pools>)((VdcQueryReturnValue)ReturnValue).ReturnValue;
					userPortalBasicListModel.OnVmAndPoolLoad();
				}
			};//END_DELEGATE

			  Frontend.RunQuery(VdcQueryType.GetAllVmPoolsAttachedToUser, new GetAllVmPoolsAttachedToUserParameters(Frontend.LoggedInUser.UserId), _asyncQuery1);

		}
		
		protected override void AsyncSearch()
		{
			base.AsyncSearch();
			SyncSearch();
		}

		protected override void InitDetailModels()
		{
			base.InitDetailModels();

			vmBasicDiskListModel = new VmBasicDiskListModel();

			ObservableCollection<EntityModel> list = new ObservableCollection<EntityModel>();
			list.Add(vmBasicDiskListModel);

			DetailModels = list;
			ActiveDetailModel = vmBasicDiskListModel;
		}

		protected override object ProvideDetailModelEntity(object selectedItem)
		{
			//Each item in this list model is not a business entity,
			//therefore select an Entity property to provide it to
			//the detail models.

			EntityModel model = (EntityModel)selectedItem;
			if (model == null)
			{
				return null;
			}

			return model.Entity;
		}

		protected override void UpdateDetailsAvailability()
		{
			base.UpdateDetailsAvailability();
		}
               
		
		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();

			UpdateSelectedEntityDetails();
		}

		private void UpdateSelectedEntityDetails()
		{
			if (SelectedItem == null)
			{
				return;
			}

			Object entity = ((EntityModel)SelectedItem).Entity;
			if (entity is VM)
			{
				VM vm = (VM)entity;
				UpdateDetails(vm);
			}
			else if (entity is vm_pools)
			{
				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
				{
					UserPortalBasicListModel userPortalBasicListModel = (UserPortalBasicListModel)model;
					VM vm = (VM)result;
					if (vm != null)
					{
						userPortalBasicListModel.UpdateDetails(vm);
					}
				};//END_DELEGATE

				vm_pools pool = (vm_pools)entity;
				AsyncDataProvider.GetAnyVm(_asyncQuery, pool.vm_pool_name);
			}
		}

		public void UpdateDetails(VM vm)
		{
			SelectedItemDefinedMemory.Entity = SizeParser(vm.vm_mem_size_mb);
			SelectedItemNumOfCpuCores.Entity = vm.num_of_cpus + " " + "(" + vm.num_of_sockets + " Socket(s), " + vm.cpu_per_socket + " Core(s) per Socket)";
		}

		// Temporarily converter
		// TODO: Use converters infrastructure in UICommon
		public string SizeParser(int sizeInMb)
		{
			return ((sizeInMb >= 1024 && sizeInMb % 1024 == 0) ? (sizeInMb / 1024 + "GB") : (sizeInMb + "MB"));
		}
		
		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);
		}
		
		public override void OnVmAndPoolLoad()
		{
			if (vms != null && pools != null)
			{
				//Complete search.

				//Remove pools that has provided VMs.
				List<vm_pools> filteredPools = new List<vm_pools>();
				poolMap = new Dictionary<Guid, vm_pools>();

				foreach (vm_pools pool in pools)
				{
					//Add pool to map.
					poolMap.Add(pool.vm_pool_id, pool);

					bool found = false;
					foreach (VM vm in vms)
					{
						if (vm.VmPoolId != null && vm.VmPoolId.Equals(pool.vm_pool_id))
						{
							found = true;
							break;
						}
					}

					if (!found)
					{
						filteredPools.Add(pool);
					}
				}

				//Merge VMs and Pools, and create item models.
				IList all = Linq.Concat(vms, filteredPools);
				Linq.Sort(all, new Linq.VmAndPoolByNameComparer());

				List<Model> items = new List<Model>();
				foreach (object item in all)
				{
					UserPortalItemModel model = new UserPortalItemModel(this);
					model.Entity = item;
					items.Add(model);

					UpdateConsoleModel(model);
				}

				// In userportal 'Basic View': Set 'CanConnectAutomatically' to true if there's one and only one VM in status 'UP' and the other VMs aren't up.
				CanConnectAutomatically = GetStatusUpVms(items).Count == 1 && GetUpVms(items).Count == 1 && 
					((UICommand)GetStatusUpVms(items)[0].DefaultConsole.ConnectCommand).IsExecutionAllowed;
                            
				Items = items;

				vms = null;
				pools = null;
                               
				
				SearchCompletedEvent.raise(this, EventArgs.Empty);
			}
		}

		private void UpdateConsoleModel(UserPortalItemModel item)
		{
			if (item.Entity != null)
			{
				VM vm = item.Entity as VM;
				if (vm == null)
				{
					return;
				}

				// Caching console model if needed
				if (!cachedConsoleModels.ContainsKey(vm.vm_guid))
				{
					SpiceConsoleModel spiceConsoleModel = new SpiceConsoleModel();
					spiceConsoleModel.ErrorEvent.addListener(this);
					VncConsoleModel vncConsoleModel = new VncConsoleModel();
					RdpConsoleModel rdpConsoleModel = new RdpConsoleModel();

					cachedConsoleModels.Add(vm.vm_guid, new List<ConsoleModel> { spiceConsoleModel, vncConsoleModel, rdpConsoleModel });
				}

				// Getting cached console model
				List<ConsoleModel> cachedModels = cachedConsoleModels[vm.vm_guid];
				foreach (ConsoleModel cachedModel in cachedModels)
				{
					cachedModel.Entity = null;
					cachedModel.Entity = vm;
				}

				// Set default console by vm's display type
				item.DefaultConsole = vm.display_type == DisplayType.vnc ? cachedModels[1] : cachedModels[0];

				// Adjust item's default console for userportal 'Basic View'
				item.DefaultConsole.ForceVmStatusUp = true;

				// Update additional console
				if (DataProvider.IsWindowsOsType(vm.vm_os))
				{
					item.AdditionalConsole = cachedModels[2];
					item.HasAdditionalConsole = true;
				}
				else
				{
					item.AdditionalConsole = null;
					item.HasAdditionalConsole = false;
				}
			}
		}
	}
}
