﻿using System;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public abstract class ItemBehavior
	{
		protected UserPortalItemModel Item { get; private set; }

		protected ItemBehavior(UserPortalItemModel item)
		{
			Item = item;
		}

		public abstract void OnEntityChanged();

		public abstract void EntityPropertyChanged(PropertyChangedEventArgs e);

		public abstract void ExecuteCommand(UICommand command);

		public abstract void eventRaised(Event ev, object sender, EventArgs args);
	}
}