using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using VdcCommon.Interfaces;
using VdcFrontend;
using VdcCommon.VdcQueries;
using System.Collections;
using System.ComponentModel;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class StorageTemplateListModel : SearchableListModel
	{
		#region Properties

		public new storage_domains Entity
		{
			get { return (storage_domains)base.Entity; }
			set { base.Entity = value; }
		}

		#endregion

		public StorageTemplateListModel()
		{
			Title = "Templates";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				base.Search();
			}
			else
			{
				Items = null;
			}
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			VdcQueryReturnValue returnValue = Frontend.RunQuery(VdcQueryType.GetVmTemplatesFromStorageDomain,
				new StorageDomainQueryParametersBase(Entity.id));

			if (returnValue != null && returnValue.Succeeded)
			{
				Items = (List<VmTemplate>)returnValue.ReturnValue;
			}
			else
			{
				Items = new List<VmTemplate>();
			}

			IsEmpty = ((IList)Items).Count == 0;
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();
			SyncSearch();
		}
	}
}
