using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.dataprovider;
using VdcFrontend;
using VdcCommon.Interfaces;

namespace org.ovirt.engine.ui.uicommon.models.pools
{
	public class PoolGeneralModel : EntityModel
	{
		#region Events

		public static EventDefinition UpdateCompleteEventDefinition;
		public Event UpdateCompleteEvent { get; private set; }

		#endregion

		#region Properties

		public VM vm { get; set; }

		private string name;
		public string Name
		{
			get { return name; }
			set
			{
				if (name != value)
				{
					name = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Name"));
				}
			}
		}

		private string description;
		public string Description
		{
			get { return description; }
			set
			{
				if (description != value)
				{
					description = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Description"));
				}
			}
		}

		private string os;
		public string OS
		{
			get { return os; }
			set
			{
				if (os != value)
				{
					os = value;
					OnPropertyChanged(new PropertyChangedEventArgs("OS"));
				}
			}
		}

		private string defaultDisplayType;
		public string DefaultDisplayType
		{
			get { return defaultDisplayType; }
			set
			{
				if (defaultDisplayType != value)
				{
					defaultDisplayType = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefaultDisplayType"));
				}
			}
		}

		private string origin;
		public string Origin
		{
			get { return origin; }
			set
			{
				if (origin != value)
				{
					origin = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Origin"));
				}
			}
		}

		private string template;
		public string Template
		{
			get { return template; }
			set
			{
				if (template != value)
				{
					template = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Template"));
				}
			}
		}

		private int cpuCount;
		public int CpuCount
		{
			get { return cpuCount; }
			set
			{
				if (cpuCount != value)
				{
					cpuCount = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CpuCount"));
				}
			}
		}

		private int monitorCount;
		public int MonitorCount
		{
			get { return monitorCount; }
			set
			{
				if (monitorCount != value)
				{
					monitorCount = value;
					OnPropertyChanged(new PropertyChangedEventArgs("MonitorCount"));
				}
			}
		}

		private string definedMemory;
		public string DefinedMemory
		{
			get { return definedMemory; }
			set
			{
				if (definedMemory != value)
				{
					definedMemory = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefinedMemory"));
				}
			}
		}

		private string minAllocatedMemory;
		public string MinAllocatedMemory
		{
			get { return minAllocatedMemory; }
			set
			{
				if (minAllocatedMemory != value)
				{
					minAllocatedMemory = value;
					OnPropertyChanged(new PropertyChangedEventArgs("MinAllocatedMemory"));
				}
			}
		}

		private bool hasDomain;
		public bool HasDomain
		{
			get { return hasDomain; }
			set
			{
				if (hasDomain != value)
				{
					hasDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasDomain"));
				}
			}
		}

		private bool hasStorageDomain;
		public bool HasStorageDomain
		{
			get { return hasStorageDomain; }
			set
			{
				if (hasStorageDomain != value)
				{
					hasStorageDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasStorageDomain"));
				}
			}
		}

		private bool hasTimeZone;
		public bool HasTimeZone
		{
			get { return hasTimeZone; }
			set
			{
				if (hasTimeZone != value)
				{
					hasTimeZone = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasTimeZone"));
				}
			}
		}

		private string usbPolicy;
		public string UsbPolicy
		{
			get { return usbPolicy; }
			set
			{
				if (usbPolicy != value)
				{
					usbPolicy = value;
					OnPropertyChanged(new PropertyChangedEventArgs("UsbPolicy"));
				}
			}
		}

		private string domain;
		public string Domain
		{
			get { return domain; }
			set
			{
				if (domain != value)
				{
					domain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Domain"));
				}
			}
		}

		private string storageDomain;
		public string StorageDomain
		{
			get { return storageDomain; }
			set
			{
				if (storageDomain != value)
				{
					storageDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("StorageDomain"));
				}
			}
		}

		private string timeZone;
		public string TimeZone
		{
			get { return timeZone; }
			set
			{
				if (timeZone != value)
				{
					timeZone = value;
					OnPropertyChanged(new PropertyChangedEventArgs("TimeZone"));
				}
			}
		}

		private string cpuInfo;
		public string CpuInfo
		{
			get { return cpuInfo; }
			set
			{
				if (cpuInfo != value)
				{
					cpuInfo = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CpuInfo"));
				}
			}
		}

		private bool hasDefaultHost;
		public bool HasDefaultHost
		{
			get { return hasDefaultHost; }
			set
			{
				if (hasDefaultHost != value)
				{
					hasDefaultHost = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasDefaultHost"));
				}
			}
		}

		private string defaultHost;
		public string DefaultHost
		{
			get { return defaultHost; }
			set
			{
				if (defaultHost != value)
				{
					defaultHost = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefaultHost"));
				}
			}
		}

		private bool isStateless;
		public bool IsStateless
		{
			get { return isStateless; }
			set
			{
				if (isStateless != value)
				{
					isStateless = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsStateless"));
				}
			}
		}

		#endregion

		static PoolGeneralModel()
		{
			UpdateCompleteEventDefinition = new EventDefinition("UpdateComplete", typeof(PoolGeneralModel));
		}

		public PoolGeneralModel()
		{
			UpdateCompleteEvent = new Event(UpdateCompleteEventDefinition);

			Title = "General";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				UpdateProperties();
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);
			UpdateProperties();
		}

		private void UpdateProperties()
		{
			vm_pools pool = (vm_pools)Entity;

			Name = pool.vm_pool_name;
			Description = pool.vm_pool_description;
			
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
			{
				// currently, only query that is being invoked asynchrounously in
				// this context is GetAnyVmQuery. If more async queries will be needed,
				// refactor to "switch ... case...".
				vm = (VM)result;
				PoolGeneralModel poolGeneralModel = (PoolGeneralModel) model;
				if (vm != null)
				{
					poolGeneralModel.Template = vm.vmt_name;
					poolGeneralModel.CpuInfo = vm.num_of_cpus + " " + "(" + vm.num_of_sockets + " Socket(s), " + vm.cpu_per_socket + " Core(s) per Socket)";
					poolGeneralModel.MonitorCount = vm.num_of_monitors;

					Translator translator = EnumTranslator.Create<VmOsType>();
					poolGeneralModel.OS = translator[vm.vm_os];

					poolGeneralModel.DefinedMemory = vm.vm_mem_size_mb + " MB";
					poolGeneralModel.MinAllocatedMemory = vm.MinAllocatedMem + " MB";

					translator = EnumTranslator.Create<DisplayType>();
					poolGeneralModel.DefaultDisplayType = translator[vm.default_display_type];

					translator = EnumTranslator.Create<OriginType>();
					poolGeneralModel.Origin = translator[vm.origin];

					translator = EnumTranslator.Create<UsbPolicy>();
					poolGeneralModel.UsbPolicy = translator[vm.usb_policy];

					HasDomain = DataProvider.IsWindowsOsType(vm.vm_os);
					poolGeneralModel.Domain = vm.vm_domain;

					HasTimeZone = DataProvider.IsWindowsOsType(vm.vm_os);
					poolGeneralModel.TimeZone = vm.time_zone;

					poolGeneralModel.IsStateless = vm.is_stateless;

					poolGeneralModel.HasDefaultHost = vm.dedicated_vm_for_vds != null;
					if (poolGeneralModel.HasDefaultHost)
					{
						AsyncQuery _asyncQuery1 = new AsyncQuery();
						_asyncQuery1.Model = poolGeneralModel;
						/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object ReturnValue1)
						{
							PoolGeneralModel poolGeneralModel1 = (PoolGeneralModel)model1;
							List<VDS> hosts = (List<VDS>)((VdcQueryReturnValue)ReturnValue1).ReturnValue;
							foreach (VDS host in hosts)
							{
								if (host.vds_id.Equals(poolGeneralModel1.vm.dedicated_vm_for_vds))
								{
									poolGeneralModel1.DefaultHost = host.vds_name;
									break;
								}
							}

							poolGeneralModel1.UpdateStorageDomain();
						};//END_DELEGATE

						Frontend.RunQuery(VdcQueryType.Search, new SearchParameters("Host: cluster = " + vm.vds_group_name + " sortby name", SearchType.VDS), _asyncQuery1);
					}
					else
					{
						poolGeneralModel.DefaultHost = "Any Host in Cluster";

						poolGeneralModel.UpdateStorageDomain();
					}
				}
				else
				{
					poolGeneralModel.Template = null;
					poolGeneralModel.CpuCount = 0;
					poolGeneralModel.MonitorCount = 0;
					poolGeneralModel.OS = null;
					poolGeneralModel.DefinedMemory = null;
					poolGeneralModel.MinAllocatedMemory = null;
					poolGeneralModel.DefaultDisplayType = null;
					poolGeneralModel.StorageDomain = null;
					poolGeneralModel.HasStorageDomain = false;
					poolGeneralModel.HasDomain = false;
					poolGeneralModel.Domain = null;
					poolGeneralModel.HasTimeZone = false;
					poolGeneralModel.TimeZone = null;
					poolGeneralModel.UsbPolicy = null;
					poolGeneralModel.DefaultHost = null;
					poolGeneralModel.IsStateless = false;

					poolGeneralModel.UpdateCompleteEvent.raise(this, EventArgs.Empty);
				}
			};//END_DELEGATE
			AsyncDataProvider.GetAnyVm(_asyncQuery, pool.vm_pool_name);
		}

		

		private void UpdateStorageDomain()
		{
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			{
				PoolGeneralModel poolGeneralModel = (PoolGeneralModel)model;
				IEnumerable disks = (IEnumerable)((VdcQueryReturnValue)ReturnValue).ReturnValue;
				IEnumerator disksIterator = disks.GetEnumerator();
				if (disksIterator.MoveNext())
				{
					poolGeneralModel.HasStorageDomain = true;

					AsyncQuery _asyncQuery1 = new AsyncQuery();
					_asyncQuery1.Model = poolGeneralModel;
					/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object ReturnValue1)
					{
						PoolGeneralModel poolGeneralModel1 = (PoolGeneralModel)model1;
						storage_domains storage = (storage_domains)((VdcQueryReturnValue)ReturnValue1).ReturnValue;
						poolGeneralModel1.StorageDomain = storage.storage_name;

						poolGeneralModel1.UpdateCompleteEvent.raise(this, EventArgs.Empty);
					};//END_DELEGATE

					DiskImage firstDisk = (DiskImage)disksIterator.Current;
					Frontend.RunQuery(VdcQueryType.GetStorageDomainById, new StorageDomainQueryParametersBase(firstDisk.storage_id.Value), _asyncQuery1);
				}
				else
				{
					poolGeneralModel.HasStorageDomain = false;

					poolGeneralModel.UpdateCompleteEvent.raise(this, EventArgs.Empty);
				}
			};//END_DELEGATE
			
			Frontend.RunQuery(VdcQueryType.GetAllDisksByVmId, new GetAllDisksByVmIdParameters(vm.vm_guid), _asyncQuery);
		}

	}
}
