using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.datacenters
{
	public class NetworkModel : Model
	{
		#region Properties

		public bool IsNew { get; set; }

		public EntityModel Name { get; private set; }
		public EntityModel Address { get; private set; }
		public EntityModel Subnet { get; private set; }
		public EntityModel Gateway { get; private set; }
		public EntityModel Description { get; private set; }
		public EntityModel VLanTag { get; private set; }

		private bool isStpEnabled;
		public bool IsStpEnabled
		{
			get { return isStpEnabled; }
			set
			{
				if (isStpEnabled != value)
				{
					isStpEnabled = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsStpEnabled"));
				}
			}
		}

		private bool hasVLanTag;
		public bool HasVLanTag
		{
			get { return hasVLanTag; }
			set
			{
				if (hasVLanTag != value)
				{
					hasVLanTag = value;
					HasVLanTagChanged();
					OnPropertyChanged(new PropertyChangedEventArgs("HasVLanTag"));
				}
			}
		}

		#endregion

		public NetworkModel()
		{
			Name = new EntityModel();
			Address = new EntityModel();
			Subnet = new EntityModel();
			Gateway = new EntityModel();
			Description = new EntityModel();
			VLanTag = new EntityModel();
		}

		private void HasVLanTagChanged()
		{
			if (!HasVLanTag)
			{
				VLanTag.IsValid = true;
			}
		}

		public virtual bool Validate()
		{
			Name.ValidateEntity(new IValidation[]{
									new  NotEmptyValidation(),
									new RegexValidation { Expression = "^[A-Za-z0-9_]{1,15}$", Message = "Name must contain alphanumeric characters or '_' (maximum length 15 characters)." },
                                    new RegexValidation { IsNegate = true, Expression = "^(bond)", Message = "Network name shouldn't start with 'bond'." }
								});

			Address.ValidateEntity(new IValidation[] { new IpAddressValidation() });

			Subnet.ValidateEntity(new IValidation[] { new IpAddressValidation() });

			Gateway.ValidateEntity(new IValidation[] { new IpAddressValidation() });

            Description.ValidateEntity(new IValidation[] { new LengthValidation{ MaxLength = 40 } });

			VLanTag.IsValid = true;
			if (HasVLanTag)
			{
				VLanTag.ValidateEntity(
					new IValidation[]
					{
						new NotEmptyValidation(),
						new IntegerValidation
						{
							Minimum = 0, 
							Maximum = 4095
						}
					});
			}

			return Name.IsValid
				   && Address.IsValid
				   && Subnet.IsValid
				   && Gateway.IsValid
				   && VLanTag.IsValid
                   && Description.IsValid;
		}
	}
}
