﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;
using System.Reflection;
using VdcCommon.VdcQueries;
using VdcUtils;

namespace VdcFrontend
{
    public interface IQueryUpdatableData
    {
        void QueryDataChanged(IRegisterQueryUpdatedData updatedData);
    }

    public class QuerySingleIVdcQueryableUpdatableData : IQueryUpdatableData
    {
        public IVdcQueryable IVdcQueryableObject { get; protected set; }

        public QuerySingleIVdcQueryableUpdatableData(ref IVdcQueryable iVdcQueryableObject)
        {
            IVdcQueryableObject = iVdcQueryableObject;
        }

        public static void UpdateIVdcQueryable(ref IVdcQueryable toUpdate, IVdcQueryable toUpdateBy)
        {
            Type queryableType = toUpdate.GetType();
            foreach (string propertyName in toUpdateBy.ChangeablePropertiesList)
            {
                PropertyInfo property = queryableType.GetProperty(propertyName);
                if (property != null)
                {
                    //Set value each time we have an updated element,
                    //with no matter whether it was really changed.
                    object destinationValue = property.GetValue(toUpdateBy, null);
                    property.SetValue(toUpdate, destinationValue, null);
                }
            }
        }

        #region IQueryUpdatableData Members

        public void QueryDataChanged(IRegisterQueryUpdatedData updatedData)
        {
            try
            {
                if (updatedData != null && !(updatedData is IVdcQueryable))
                {
                    throw new ArgumentException("QueryISearchableData::QueryDataChanged: Argument should be of type IVdcQueryable", "updatedData");
                }

                if (updatedData != null)
                {
                    IVdcQueryable iQueryableUpdatedData = updatedData as IVdcQueryable;
                    IVdcQueryable current = IVdcQueryableObject;
                    UpdateIVdcQueryable(ref current, iQueryableUpdatedData);
                }
            }
            catch (Exception ex)
            {
                QLogger.Instance.ErrorFormat("Frontend.QuerySingleIVdcQueryableUpdatableData.QueryDataChanged - {0} - {1}", ex.Message, ex.StackTrace);
                throw ex;
            }
        }

        #endregion
    }

    /// <summary>
    /// This class encapsulates GUI data binding. Its contains some query results 
    /// and updates each time backend notified about query result changed
    /// </summary>
	class QueryListIVdcQueryableUpdatableData : EventProvidingCollection<IVdcQueryable>, IQueryUpdatableData
    {
        private readonly object _locker = new object();

        internal void ListIVdcQueryableQueryDataChanged(
                               Dictionary<object, IVdcQueryable> added,
                               List<object> removed,
                               Dictionary<object, IVdcQueryable> updated)
        {
            lock (_locker)
            {
                if (Count > 0)
                {
                    for (int i = Count - 1; i >= 0; i--)
                    {
                        if (removed.Contains(this[i].QueryableId))
                        {
                            RemoveAt(i);
                        }
                        else if (updated.ContainsKey(this[i].QueryableId))
                        {
                            UpdateElement(i, updated[this[i].QueryableId]);
						}
                    }
                }
                AddElements(added);
            }
        }

        void UpdateElement(int index, IVdcQueryable updated)
        {
            IVdcQueryable current = this[index];
            QuerySingleIVdcQueryableUpdatableData.UpdateIVdcQueryable(ref current, updated);
        }

        void AddElements(Dictionary<object, IVdcQueryable> added)
        {
            foreach (IVdcQueryable queriable in added.Values)
            {
                this.Add(queriable);
            }
        }

        #region IQueryData Members

        public void QueryDataChanged(IRegisterQueryUpdatedData updatedData)
        {
            try
            {
                if (!(updatedData is ListIVdcQueryableUpdatedData))
                {
                    throw new ArgumentException("ListIVdcQueryableQueryData::QueryDataChanged: Argument should be of type ListIVdcQueryableUpdatedData", "updatedData");
                }

                ListIVdcQueryableUpdatedData typedUpdatedData = updatedData as ListIVdcQueryableUpdatedData;
                ListIVdcQueryableQueryDataChanged((Dictionary<object, IVdcQueryable>)typedUpdatedData.Added, (List<object>)typedUpdatedData.Removed, (Dictionary<object, IVdcQueryable>)typedUpdatedData.Updated);
            }
            catch (Exception ex)
            {
                QLogger.Instance.ErrorFormat("Frontend.QueryListIVdcQueryableUpdatableData.QueryDataChanged - {0} - {1}", ex.Message, ex.StackTrace);
                throw ex;
            }
        }

        #endregion
    }
}
