﻿using System;
using System.Collections.Generic;
using System.Text;
using VdcCommon.BusinessEntities;
using VdcCommon.Interfaces;

using System.Linq;
using System.Collections;

namespace VdcCommon
{
	public static class VdcActionUtils
	{
		private static IDictionary<Type, IDictionary<Enum, HashSet<VdcActionType>>> _matrix =
			new Dictionary<Type, IDictionary<Enum, HashSet<VdcActionType>>>();

		static VdcActionUtils()
		{
			// this matrix contains the actions that CANNOT run per status ("black list")
			var vdsMatrix = new Dictionary<Enum, HashSet<VdcActionType>>();
			vdsMatrix.Add(VDSStatus.Maintenance, new HashSet<VdcActionType>(new[] { VdcActionType.MaintananceVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.Up, new HashSet<VdcActionType>(new[] { VdcActionType.ActivateVds, VdcActionType.RemoveVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds, VdcActionType.StartVds, VdcActionType.StopVds }));
			vdsMatrix.Add(VDSStatus.Error, new HashSet<VdcActionType>(new[] { VdcActionType.RemoveVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.Installing, new HashSet<VdcActionType>(new[] { VdcActionType.RemoveVds, VdcActionType.ActivateVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds, VdcActionType.MaintananceVds, VdcActionType.StartVds, VdcActionType.StopVds }));
			vdsMatrix.Add(VDSStatus.NonResponsive, new HashSet<VdcActionType>(new[] { VdcActionType.RemoveVds, VdcActionType.ActivateVds, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.PreparingForMaintenance, new HashSet<VdcActionType>(new[] { VdcActionType.RemoveVds, VdcActionType.MaintananceVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.Reboot, new HashSet<VdcActionType>(new[] { VdcActionType.ActivateVds, VdcActionType.RemoveVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds, VdcActionType.MaintananceVds }));
			vdsMatrix.Add(VDSStatus.Unassigned, new HashSet<VdcActionType>(new[] { VdcActionType.ActivateVds, VdcActionType.RemoveVds, VdcActionType.MaintananceVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.Initializing, new HashSet<VdcActionType>(new[] { VdcActionType.ActivateVds, VdcActionType.RemoveVds, VdcActionType.ClearNonResponsiveVdsVms, VdcActionType.ApproveVds, VdcActionType.MaintananceVds }));
			vdsMatrix.Add(VDSStatus.NonOperational, new HashSet<VdcActionType>(new[] { VdcActionType.RemoveVds, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.PendingApproval, new HashSet<VdcActionType>(new[] { VdcActionType.UpdateVds, VdcActionType.ActivateVds, VdcActionType.MaintananceVds, VdcActionType.AttachVdsToTag, VdcActionType.ClearNonResponsiveVdsVms }));
			vdsMatrix.Add(VDSStatus.InstallFailed, new HashSet<VdcActionType>(new[] { VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.Problematic, new HashSet<VdcActionType>(new[] { VdcActionType.MaintananceVds, VdcActionType.RemoveVds, VdcActionType.ActivateVds, VdcActionType.ApproveVds }));
			vdsMatrix.Add(VDSStatus.Down, new HashSet<VdcActionType>(new[] { VdcActionType.ActivateVds, VdcActionType.ApproveVds }));
			_matrix.Add(typeof(VDS), vdsMatrix);

			var vmMatrix = new Dictionary<Enum, HashSet<VdcActionType>>();
			vmMatrix.Add(VMStatus.WaitForLaunch, new HashSet<VdcActionType>(new[] { VdcActionType.HibernateVm, VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
            vmMatrix.Add(VMStatus.Up, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface }));
			vmMatrix.Add(VMStatus.PoweringDown, new HashSet<VdcActionType>(new[] { VdcActionType.HibernateVm, VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.MigrateVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.PoweringUp, new HashSet<VdcActionType>(new[] { VdcActionType.HibernateVm, VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.RebootInProgress, new HashSet<VdcActionType>(new[] { VdcActionType.HibernateVm, VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.MigratingFrom, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.PoweredDown, new HashSet<VdcActionType>(new[] { VdcActionType.HibernateVm, VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.AddVmTemplate, VdcActionType.RemoveVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));

			vmMatrix.Add(VMStatus.Suspended, new HashSet<VdcActionType>(new[] { VdcActionType.HibernateVm, VdcActionType.AddVmTemplate, VdcActionType.RunVmOnce, VdcActionType.MigrateVm, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.RemoveVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
            vmMatrix.Add(VMStatus.Paused, new HashSet<VdcActionType>(new[] { VdcActionType.RemoveVm, VdcActionType.HibernateVm, VdcActionType.AddVmTemplate, VdcActionType.RunVmOnce, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface }));
			vmMatrix.Add(VMStatus.SavingState, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.RemoveVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.RestoringState, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.RemoveVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));

			vmMatrix.Add(VMStatus.Down, new HashSet<VdcActionType>(new[] { VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.ImageIllegal, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.ImageLocked, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.RemoveVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.NotResponding, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.RemoveVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));

			vmMatrix.Add(VMStatus.Unassigned, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.RemoveVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			vmMatrix.Add(VMStatus.Unknown, new HashSet<VdcActionType>(new[] { VdcActionType.RunVm, VdcActionType.RunVmOnce, VdcActionType.StopVm, VdcActionType.ShutdownVm, VdcActionType.HibernateVm, VdcActionType.MigrateVm, VdcActionType.RemoveVm, VdcActionType.AddVmTemplate, VdcActionType.ExportVm, VdcActionType.MoveVm, VdcActionType.ImportVm, VdcActionType.AddVmInterface, VdcActionType.UpdateVmInterface, VdcActionType.RemoveVmInterface, VdcActionType.ChangeDisk }));
			_matrix.Add(typeof(VM), vmMatrix);

			var vmTemplateMatrix = new Dictionary<Enum, HashSet<VdcActionType>>();
			vmTemplateMatrix.Add(VmTemplateStatus.Locked, new HashSet<VdcActionType>(new VdcActionType[] { VdcActionType.RemoveVmTemplate, VdcActionType.ExportVmTemplate, VdcActionType.MoveOrCopyTemplate, VdcActionType.ImportVmTemplate }));
			vmTemplateMatrix.Add(VmTemplateStatus.Illegal, new HashSet<VdcActionType>(new VdcActionType[] { VdcActionType.ExportVmTemplate, VdcActionType.MoveOrCopyTemplate, VdcActionType.ImportVmTemplate }));
			_matrix.Add(typeof(VmTemplate), vmTemplateMatrix);

			var storageDomainMatrix = new Dictionary<Enum, HashSet<VdcActionType>>();
			storageDomainMatrix.Add(StorageDomainStatus.Active, new HashSet<VdcActionType>(new[] { VdcActionType.DetachStorageDomainFromPool, VdcActionType.ActivateStorageDomain }));
			storageDomainMatrix.Add(StorageDomainStatus.InActive, new HashSet<VdcActionType>(new[] { VdcActionType.DeactivateStorageDomain }));
			storageDomainMatrix.Add(StorageDomainStatus.Locked, new HashSet<VdcActionType>(new[] { VdcActionType.DetachStorageDomainFromPool, VdcActionType.DeactivateStorageDomain, VdcActionType.ActivateStorageDomain }));
			storageDomainMatrix.Add(StorageDomainStatus.Unattached, new HashSet<VdcActionType>(new[] { VdcActionType.DetachStorageDomainFromPool, VdcActionType.DeactivateStorageDomain, VdcActionType.ActivateStorageDomain }));
			storageDomainMatrix.Add(StorageDomainStatus.Uninitialized, new HashSet<VdcActionType>(new[] { VdcActionType.DetachStorageDomainFromPool, VdcActionType.DeactivateStorageDomain, VdcActionType.ActivateStorageDomain }));
			storageDomainMatrix.Add(StorageDomainStatus.Unknown, new HashSet<VdcActionType>(new[] { VdcActionType.DetachStorageDomainFromPool, VdcActionType.DeactivateStorageDomain }));
			_matrix.Add(typeof(storage_domains), storageDomainMatrix);
			//var userMatrix = new Dictionary<Enum, HashSet<VdcActionType>>();
			//_matrix.Add(SearchType.DBUser, userMatrix);
		}


		public static bool CanExecute(IList entities, Type type, VdcActionType action)
		{
			if (_matrix.ContainsKey(type))
			{
				foreach (object a in entities)
				{
					if (a.GetType() == type &&
					   _matrix[type].ContainsKey(GetStatusProperty(a)) &&
					   _matrix[type][GetStatusProperty(a)].Contains(action))
						return false;
				}
			}
			return true;
		}

		private static Enum GetStatusProperty(object entity)
		{
			switch (entity.GetType().Name)
			{
				case "VDS":
					return (entity as VDS).status;

				case "VM":
					return (entity as VM).status;

				case "VmTemplate":
					return (entity as VmTemplate).status;

				case "storage_domains":
					return (entity as storage_domains).status.HasValue
						? (entity as storage_domains).status.Value
						: StorageDomainStatus.Uninitialized;
				//case SearchType.DBUser:
				//    return (entity as DbUser).status;
			}

			throw new NotImplementedException();
		}
	}
}
