package org.ovirt.engine.core.config;

import org.apache.log4j.Logger;
import org.ovirt.engine.core.config.validation.ConfigActionType;

/**
 * The <code>RhevmConfig</code> class represents the main class of the RhevmConfig tool.
 */
public class RhevmConfig {

    public static final String CONFIG_FILE_PATH_PROPERTY = "rhevm-config.config.file.path";
    public static final String DEFAULT_CONFIG_PATH = "/etc/rhevm/rhevm-config/";
    private static final Logger log = Logger.getLogger(RhevmConfig.class);
    private RhevmConfigCLIParser parser;
    private RhevmConfigLogic rhevmConfigLogic;
    private static RhevmConfig instance = new RhevmConfig();

    private RhevmConfig() {
    }

    /**
     * Parses the arguments, validates that they are valid, instantiates the RhevmConfigLogic object and executes the
     * desired action.
     *
     * @param args
     *            The arguments given by the user.
     *
     * @throws Exception
     */
    public void setUpAndExecute(String... args) throws Exception {
        parser.parse(args);
        log.debug("Arguments have been parsed: " + parser.rhevmConfigMapToString());
        ConfigActionType actionType = parser.getConfigAction();
        actionType.validate(parser.getRhevmConfigMap());
        setRhevmConfigLogic(new RhevmConfigLogic(parser));
        rhevmConfigLogic.execute();
    }

    /**
     * The main method, instantiates the parser and executes.
     *
     * @param args
     *            The arguments given by the user.
     */
    public static void main(String... args) {
        try {
            getInstance().setParser(new RhevmConfigCLIParser());
            getInstance().setUpAndExecute(args);

        } catch (Throwable t) {
            log.debug("Exiting with error: ", t);
            System.err.println(t.getMessage());
            System.exit(1);
        }
    }

    public void setRhevmConfigLogic(RhevmConfigLogic rhevmConfigLogic) {
        this.rhevmConfigLogic = rhevmConfigLogic;
    }

    public void setParser(RhevmConfigCLIParser parser) {
        this.parser = parser;
    }

    public RhevmConfigLogic getRhevmConfigLogic() {
        return instance.rhevmConfigLogic;
    }

    public static RhevmConfig getInstance() {
        return instance;
    }
}