package org.ovirt.engine.api.restapi.resource;

import java.util.List;

import com.redhat.rhevm.api.model.Host;
import com.redhat.rhevm.api.resource.AssignedTagsResource;
import org.ovirt.engine.core.common.businessentities.tags;
import org.ovirt.engine.core.common.action.AttachVdsToTagParameters;
import org.ovirt.engine.core.common.action.TagsActionParametersBase;
import org.ovirt.engine.core.common.action.VdcActionType;
import org.ovirt.engine.core.common.queries.GetTagsByVdsIdParameters;
import org.ovirt.engine.core.common.queries.VdcQueryType;

public class BackendHostTagsResource
    extends AbstractBackendAssignedTagsResource
    implements AssignedTagsResource {

    public BackendHostTagsResource(String parentId) {
        super(Host.class, parentId, VdcActionType.AttachVdsToTag, VdcActionType.DetachVdsFromTag);
    }

    public List<tags> getCollection() {
        return getBackendCollection(VdcQueryType.GetTagsByVdsId, new GetTagsByVdsIdParameters(parentId));
    }

    protected TagsActionParametersBase getAttachParams(String id) {
        return new AttachVdsToTagParameters(asGuid(id), asList(asGuid(parentId)));
    }
}
