package org.ovirt.engine.core.common;

import java.util.HashMap;

import javax.xml.bind.annotation.XmlType;

@XmlType(name = "AuditLogType")
public enum AuditLogType {
    UNASSIGNED(0),
    // -- VDC Log types --
    VDC_START(1),

    VDC_STOP(2),
    // -- VDS Log types --
    VDS_FAILURE(12), // When VDS changes status to up -> down or in VDC
    // initialization the VDS is down
    VDS_DETECTED(13), // When VDC initializes and detects a running VDS
    VDS_RECOVER(14), // When VDS changes status down->up
    VDS_MAINTENANCE(15), // When VDS is transferred to maintenance mode
    VDS_ACTIVATE(16), // When VDS is reactivated
    VDS_MAINTENANCE_FAILED(17, AuditLogTimeInterval.MINUTE.getValue()), // When VDS is transferred to maintenance mode
    VDS_ACTIVATE_FAILED(18, AuditLogTimeInterval.MINUTE.getValue()), // When VDS is reactivated
    VDS_RECOVER_FAILED(19, AuditLogTimeInterval.MINUTE.getValue()), // When VDS changes status down->up
    VDS_SLOW_STORAGE_RESPONSE_TIME(123, AuditLogTimeInterval.MINUTE.getValue() * 5), // ?
    VDS_ALREADY_IN_REQUESTED_STATUS(493),
    VDS_MANUAL_FENCE_STATUS(494),
    VDS_MANUAL_FENCE_STATUS_FAILED(495),
    VDS_MANUAL_FENCE_FAILED_CALL_FENCE_SPM(530),
    VDS_LOW_MEM(531, AuditLogTimeInterval.HOUR.getValue() * 5),
    VDS_FENCE_STATUS(496),
    VDS_FENCE_STATUS_FAILED(497),
    VDS_APPROVE(498),
    VDS_APPROVE_FAILED(499),
    VDS_FAILED_TO_RUN_VMS(500, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_INSTALL(504),
    VDS_INSTALL_FAILED(505),
    VDS_INITIATED_RUN_VM(506),
    VDS_INITIATED_RUN_VM_FAILED(507),
    // VDS_INITIATED_RUN_VM_CHECKOUT_FAILED = 508,
    VDS_INSTALL_IN_PROGRESS(509),
    VDS_INSTALL_IN_PROGRESS_WARNING(510, AuditLogTimeInterval.SECOND.getValue()),
    VDS_INSTALL_IN_PROGRESS_ERROR(511, AuditLogTimeInterval.SECOND.getValue()),
    VDS_RECOVER_FAILED_VMS_UNKNOWN(513),
    VDS_INITIALIZING(514, AuditLogTimeInterval.SECOND.getValue() * 30),
    VDS_CPU_LOWER_THAN_CLUSTER(515),
    VDS_CPU_RETRIEVE_FAILED(516),
    VDS_STORAGE_CONNECTION_FAILED_BUT_LAST_VDS(533),
    VDS_SET_NONOPERATIONAL(517, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_FAILED(518, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_NETWORK(519, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_IFACE_DOWN(603, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_DOMAIN(522, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_SET_NONOPERATIONAL_DOMAIN_FAILED(523, AuditLogTimeInterval.MINUTE.getValue()),
    VDS_DOMAIN_DELAY_INTERVAL(524, AuditLogTimeInterval.HOUR.getValue()),
    VDS_LOW_DISK_SPACE(23, AuditLogTimeInterval.HOUR.getValue() * 12),
    VDS_LOW_DISK_SPACE_ERROR(24, AuditLogTimeInterval.MINUTE.getValue() * 15),
    USER_VDS_MAINTENANCE(600), // When VDS is transferred to
    CPU_FLAGS_NX_IS_MISSING(601),
    // maintenance mode
    USER_VDS_MAINTENANCE_MIGRATION_FAILED(602),

    SYSTEM_VDS_RESTART(121, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_FAILED_VDS_RESTART(122, AuditLogTimeInterval.MINUTE.getValue()),

    // -- IRS Log types --
    IRS_FAILURE(22, AuditLogTimeInterval.HOUR.getValue() * 12),
    IRS_DISK_SPACE_LOW(26, AuditLogTimeInterval.HOUR.getValue() * 12),
    IRS_DISK_SPACE_LOW_ERROR(201, AuditLogTimeInterval.MINUTE.getValue() * 15),
    IRS_HOSTED_ON_VDS(204),
    // -- USER Log types --
    USER_VDC_LOGIN(30), // user logged in to VDC
    USER_VDC_LOGIN_FAILED(114), // user logged in to VDC
    USER_VDC_LOGOUT(31), // User logged out from VDC
    USER_VDC_LOGOUT_FAILED(815), // User logged out failed

    USER_INITIATED_RUN_VM(150),
    USER_STARTED_VM(153),
    USER_INITIATED_RUN_VM_FAILED(151),
    USER_RUN_VM(32), // User issued runVm command
    USER_FAILED_RUN_VM(54), // User issued runVm command
    USER_RUN_VM_AS_STATELESS_FINISHED_FAILURE(70),
    USER_RUN_VM_FAILURE_STATELESS_SNAPSHOT_LEFT(1001),
    USER_RUN_VM_ON_NON_DEFAULT_VDS(152),

    USER_STOP_VM(33), // User issued stopVm command
    USER_STOP_SUSPENDED_VM(111),
    USER_STOP_SUSPENDED_VM_FAILED(112),
    USER_FAILED_STOP_VM(56),
    USER_ADD_VM(34),
    USER_ADD_VM_STARTED(37),
    USER_ADD_VM_FINISHED_SUCCESS(53),
    USER_ADD_VM_FINISHED_FAILURE(60),
    USER_FAILED_ADD_VM(57),
    USER_UPDATE_VM(35),
    USER_FAILED_UPDATE_VM(58),
    USER_UPDATE_VM_CLUSTER_DEFAULT_HOST_CLEARED(250),
    USER_REMOVE_VM(36),
    USER_REMOVE_VM_FINISHED(113),
    USER_ADD(149),
    USER_FAILED_REMOVE_VM(59),
    USER_CHANGE_DISK_VM(38),
    USER_FAILED_CHANGE_DISK_VM(102),
    USER_CHANGE_FLOPPY_VM(72),
    USER_FAILED_CHANGE_FLOPPY_VM(75),
    USER_PAUSE_VM(39),
    USER_FAILED_PAUSE_VM(55),
    USER_SUSPEND_VM(501),
    USER_SUSPEND_VM_FINISH_SUCCESS(512),
    USER_SUSPEND_VM_FINISH_FAILURE(521),
    USER_SUSPEND_VM_FINISH_FAILURE_WILL_TRY_AGAIN(532),
    USER_FAILED_SUSPEND_VM(502),
    USER_SUSPEND_VM_OK(503),
    USER_RESUME_VM(40),
    USER_FAILED_RESUME_VM(103),
    USER_INITIATED_SHUTDOWN_VM(73),
    USER_FAILED_SHUTDOWN_VM(74),
    USER_STOPPED_VM_INSTEAD_OF_SHUTDOWN(76),
    USER_FAILED_STOPPING_VM_INSTEAD_OF_SHUTDOWN(77),
    USER_ADD_DISK_TO_VM(78),
    USER_ADD_DISK_TO_VM_FINISHED_SUCCESS(97),
    USER_ADD_DISK_TO_VM_FINISHED_FAILURE(98),
    USER_FAILED_ADD_DISK_TO_VM(79),
    USER_REMOVE_DISK_FROM_VM(80),
    USER_FAILED_REMOVE_DISK_FROM_VM(81),
    USER_MOVED_VM(82),
    USER_MOVED_VM_FINISHED_SUCCESS(91),
    USER_MOVED_VM_FINISHED_FAILURE(92),
    USER_FAILED_MOVE_VM(83),
    USER_MOVED_TEMPLATE(84),
    USER_MOVED_TEMPLATE_FINISHED_SUCCESS(93),
    USER_MOVED_TEMPLATE_FINISHED_FAILURE(94),
    USER_FAILED_MOVE_TEMPLATE(85),
    USER_COPIED_TEMPLATE(86),
    USER_COPIED_TEMPLATE_FINISHED_SUCCESS(95),
    USER_COPIED_TEMPLATE_FINISHED_FAILURE(96),
    USER_FAILED_COPY_TEMPLATE(87),
    USER_UPDATE_VM_DISK(88),
    USER_FAILED_UPDATE_VM_DISK(89),
    USER_VDS_RESTART(41),
    USER_FAILED_VDS_RESTART(107),
    USER_VDS_START(20),
    USER_FAILED_VDS_START(118),
    USER_VDS_STOP(21),
    USER_FAILED_VDS_STOP(137),
    USER_ADD_VDS(42),
    USER_FAILED_ADD_VDS(104),
    USER_UPDATE_VDS(43),
    USER_FAILED_UPDATE_VDS(105),
    USER_REMOVE_VDS(44),
    USER_FAILED_REMOVE_VDS(106),
    USER_VDS_SHUTDOWN(90),
    USER_FAILED_VDS_SHUTDOWN(130),
    USER_CREATE_SNAPSHOT(45),
    USER_CREATE_SNAPSHOT_FINISHED_SUCCESS(68),
    USER_CREATE_SNAPSHOT_FINISHED_FAILURE(69),
    USER_FAILED_CREATE_SNAPSHOT(117),
    USER_MERGE_SNAPSHOT(342),
    USER_FAILED_MERGE_SNAPSHOT(343),
    USER_MERGE_SNAPSHOT_FINISHED_SUCCESS(356),
    USER_MERGE_SNAPSHOT_FINISHED_FAILURE(357),
    USER_TRY_BACK_TO_SNAPSHOT(46),
    USER_TRY_BACK_TO_SNAPSHOT_FINISH_SUCCESS(71),
    USER_TRY_BACK_TO_SNAPSHOT_FINISH_FAILURE(99),
    USER_FAILED_TRY_BACK_TO_SNAPSHOT(115),
    USER_RESTORE_FROM_SNAPSHOT(47),
    USER_RESTORE_FROM_SNAPSHOT_START(1190),
    USER_RESTORE_FROM_SNAPSHOT_FINISH_SUCCESS(100),
    USER_RESTORE_FROM_SNAPSHOT_FINISH_FAILURE(101),
    USER_FAILED_RESTORE_FROM_SNAPSHOT(116),
    USER_ADD_VM_TEMPLATE(48),
    USER_ADD_VM_TEMPLATE_FINISHED_SUCCESS(51),
    USER_ADD_VM_TEMPLATE_FINISHED_FAILURE(52),
    USER_FAILED_ADD_VM_TEMPLATE(108),
    USER_UPDATE_VM_TEMPLATE(49),
    USER_FAILED_UPDATE_VM_TEMPLATE(109),
    USER_REMOVE_VM_TEMPLATE(50),
    USER_REMOVE_VM_TEMPLATE_FINISHED(251),
    USER_FAILED_REMOVE_VM_TEMPLATE(110),
    TEMPLATE_IMPORT(135),
    TEMPLATE_IMPORT_FAILED(136),
    USER_ATTACH_USER_TO_VM(520),
    USER_DETACH_USER_FROM_VM(360),
    USER_FAILED_DETACH_USER_FROM_VM(361),
    USER_FAILED_ATTACH_USER_TO_VM(182),
    USER_REMOVE_ADUSER(325),
    USER_FAILED_REMOVE_ADUSER(326),
    USER_FAILED_ADD_ADUSER(327),
    USER_PASSWORD_CHANGED(346),
    USER_PASSWORD_CHANGE_FAILED(347),
    USER_CLEAR_UNKNOWN_VMS(348),
    USER_FAILED_CLEAR_UNKNOWN_VMS(349),

    AUTO_SUSPEND_VM(524),
    AUTO_SUSPEND_VM_FINISH_SUCCESS(525),
    AUTO_SUSPEND_VM_FINISH_FAILURE(526),
    AUTO_FAILED_SUSPEND_VM(527),

    USER_EJECT_VM_DISK(528),
    USER_EJECT_VM_FLOPPY(529),

    // -- VM Log types --
    VM_DOWN(61),
    VM_DOWN_ERROR(119),
    VM_MIGRATION_START(62),
    VM_MIGRATION_DONE(63),
    VM_MIGRATION_ABORT(64),
    VM_MIGRATION_FAILED(65),
    VM_MIGRATION_FAILED_FROM_TO(120),
    VM_MIGRATION_TRYING_RERUN(128),
    VM_FAILURE(66),

    VM_MIGRATION_FAILED_DURING_MOVE_TO_MAINTANANCE(140),
    VM_SET_TO_UNKNOWN_STATUS(142),
    VM_WAS_SET_DOWN_DUE_TO_HOST_REBOOT_OR_MANUAL_FENCE(143),

    USER_EXPORT_VM(131),
    USER_EXPORT_VM_FAILED(132),
    USER_EXPORT_TEMPLATE(133),
    USER_EXPORT_TEMPLATE_FAILED(134),
    VM_IMPORT(124),
    VM_IMPORT_FAILED(125),
    VM_NOT_RESPONDING(126),
    VDS_RUN_IN_NO_KVM_MODE(127),
    VDS_VERSION_NOT_SUPPORTED_FOR_CLUSTER(141),
    VM_CLEARED(129),
    VM_PAUSED_ENOSPC(138),
    VM_PAUSED_ERROR(139),
    VM_IMPORT_INFO(144),
    VM_PAUSED_EIO(145),
    VM_PAUSED_EPERM(146),

    USER_ADD_VM_POOL(300),
    USER_ADD_VM_POOL_FAILED(301),
    USER_ADD_VM_POOL_WITH_VMS(302),
    USER_ADD_VM_POOL_WITH_VMS_FAILED(303),
    USER_ADD_VM_POOL_WITH_VMS_ADD_VDS_FAILED(320),
    USER_REMOVE_VM_POOL(304),
    USER_REMOVE_VM_POOL_FAILED(305),
    USER_ADD_VM_TO_POOL(306),
    USER_ADD_VM_TO_POOL_FAILED(307),
    USER_REMOVE_VM_FROM_POOL(308),
    USER_REMOVE_VM_FROM_POOL_FAILED(309),
    USER_ATTACH_USER_TO_POOL(310),
    USER_ATTACH_USER_TO_POOL_INTERNAL(472),
    USER_ATTACH_USER_TO_POOL_FAILED(311),
    USER_ATTACH_USER_TO_POOL_FAILED_INTERNAL(473),
    USER_DETACH_USER_FROM_POOL(312),
    USER_DETACH_USER_FROM_POOL_FAILED(313),
    USER_UPDATE_VM_POOL(314),
    USER_UPDATE_VM_POOL_FAILED(315),
    USER_ATTACH_USER_TO_VM_FROM_POOL(316),
    USER_ATTACH_USER_TO_VM_FROM_POOL_FINISHED_SUCCESS(318),
    USER_ATTACH_USER_TO_VM_FROM_POOL_FINISHED_FAILURE(319),
    USER_ATTACH_USER_TO_VM_FROM_POOL_FAILED(317),
    USER_UPDATE_VM_POOL_WITH_VMS(344),
    USER_UPDATE_VM_POOL_WITH_VMS_FAILED(345),

    USER_ATTACH_USER_TO_TIME_LEASED_POOL(328),
    USER_ATTACH_USER_TO_TIME_LEASED_POOL_FAILED(329),
    USER_DETACH_USER_FROM_TIME_LEASED_POOL(330),
    USER_DETACH_USER_FROM_TIME_LEASED_POOL_FAILED(331),

    USER_ATTACH_AD_GROUP_TO_TIME_LEASED_POOL(332),
    USER_ATTACH_AD_GROUP_TO_TIME_LEASED_POOL_FAILED(333),
    USER_DETACH_AD_GROUP_FROM_TIME_LEASED_POOL(334),
    USER_DETACH_AD_GROUP_FROM_TIME_LEASED_POOL_FAILED(335),

    USER_UPDATE_USER_TO_TIME_LEASED_POOL(336),
    USER_UPDATE_USER_TO_TIME_LEASED_POOL_FAILED(337),
    USER_UPDATE_AD_GROUP_TO_TIME_LEASED_POOL(338),
    USER_UPDATE_AD_GROUP_TO_TIME_LEASED_POOL_FAILED(339),

    USER_ADD_BOOKMARK(350),
    USER_ADD_BOOKMARK_FAILED(351),
    USER_UPDATE_BOOKMARK(352),
    USER_UPDATE_BOOKMARK_FAILED(353),
    USER_REMOVE_BOOKMARK(354),
    USER_REMOVE_BOOKMARK_FAILED(355),
    /**
     * AdGroups
     */
    USER_ATTACH_VM_TO_AD_GROUP(400),
    USER_ATTACH_VM_TO_AD_GROUP_FAILED(401),
    USER_DETACH_VM_TO_AD_GROUP(402),
    USER_DETACH_VM_TO_AD_GROUP_FAILED(403),
    USER_ATTACH_VM_POOL_TO_AD_GROUP(404),
    USER_ATTACH_VM_POOL_TO_AD_GROUP_INTERNAL(470),
    USER_ATTACH_VM_POOL_TO_AD_GROUP_FAILED(405),
    USER_ATTACH_VM_POOL_TO_AD_GROUP_FAILED_INTERNAL(471),
    USER_DETACH_VM_POOL_TO_AD_GROUP(406),
    USER_DETACH_VM_POOL_TO_AD_GROUP_FAILED(407),
    USER_REMOVE_AD_GROUP(408),
    USER_REMOVE_AD_GROUP_FAILED(409),
    USER_UPDATE_TAG(430),
    USER_UPDATE_TAG_FAILED(431),
    USER_ADD_TAG(432),
    USER_ADD_TAG_FAILED(433),
    USER_REMOVE_TAG(434),
    USER_REMOVE_TAG_FAILED(435),
    USER_ATTACH_TAG_TO_USER(436),
    USER_ATTACH_TAG_TO_USER_FAILED(437),
    USER_ATTACH_TAG_TO_USER_GROUP(438),
    USER_ATTACH_TAG_TO_USER_GROUP_FAILED(439),
    USER_ATTACH_TAG_TO_VM(440),
    USER_ATTACH_TAG_TO_VM_FAILED(441),
    USER_ATTACH_TAG_TO_VDS(442),
    USER_ATTACH_TAG_TO_VDS_FAILED(443),
    USER_DETACH_VDS_FROM_TAG(444),
    USER_DETACH_VDS_FROM_TAG_FAILED(445),
    USER_DETACH_VM_FROM_TAG(446),
    USER_DETACH_VM_FROM_TAG_FAILED(447),
    USER_DETACH_USER_FROM_TAG(448),
    USER_DETACH_USER_FROM_TAG_FAILED(449),
    USER_DETACH_USER_GROUP_FROM_TAG(450),
    USER_DETACH_USER_GROUP_FROM_TAG_FAILED(451),
    USER_ATTACH_TAG_TO_USER_EXISTS(452),
    USER_ATTACH_TAG_TO_USER_GROUP_EXISTS(453),
    USER_ATTACH_TAG_TO_VM_EXISTS(454),
    USER_ATTACH_TAG_TO_VDS_EXISTS(455),
    USER_MOVE_TAG(555),
    USER_MOVE_TAG_FAILED(556),
    USER_LOGGED_IN_VM(456),
    USER_LOGGED_OUT_VM(457),
    USER_LOCKED_VM(458),
    USER_UNLOCKED_VM(459),
    USER_DETACH_USER_FROM_TIME_LEASED_POOL_INTERNAL(460),
    USER_DETACH_USER_FROM_TIME_LEASED_POOL_FAILED_INTERNAL(461),
    USER_DETACH_AD_GROUP_FROM_TIME_LEASED_POOL_INTERNAL(462),
    USER_DETACH_AD_GROUP_FROM_TIME_LEASED_POOL_FAILED_INTERNAL(463),
    UPDATE_TAGS_VM_DEFAULT_DISPLAY_TYPE(467),
    UPDATE_TAGS_VM_DEFAULT_DISPLAY_TYPE_FAILED(468),
    IMAGES_SYNCRONIZER_DESKTOP_NOT_EXIST_IN_VDC(800),
    IMAGES_SYNCRONIZER_TEMPLATE_NOT_EXIST_IMAGE_EXIST(801),
    IMAGES_SYNCRONIZER_SNAPSHOT_NOT_EXIST_IN_VDC(802),
    IMAGES_SYNCRONIZER_SNAPSHOTS_NOT_ATTACHED_TO_VM_IN_VDC(803),
    IMAGES_SYNCRONIZER_TEMPLATE_NOT_EXIST_IN_VDC(804),
    IMAGES_SYNCRONIZER_DESKTOP_NOT_EXIST_IN_IRS(805),
    IMAGES_SYNCRONIZER_SNAPSHOT_NOT_EXIST_IN_IRS(806),
    IMAGES_SYNCRONIZER_DESKTOP_WITHOUT_TEMPLATE_VDC(807),
    IMAGES_SYNCRONIZER_IMAGE_TEMPLATE_NOT_EXIST(808),
    USER_ADD_VDS_GROUP(809),
    USER_ADD_VDS_GROUP_FAILED(810),
    USER_UPDATE_VDS_GROUP(811),
    USER_UPDATE_VDS_GROUP_FAILED(812),
    SYSTEM_UPDATE_VDS_GROUP(835, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_UPDATE_VDS_GROUP_FAILED(836, AuditLogTimeInterval.MINUTE.getValue()),
    USER_REMOVE_VDS_GROUP(813),
    USER_REMOVE_VDS_GROUP_FAILED(814),
    MAC_POOL_EMPTY(816),
    MAC_ADDRESS_IS_IN_USE(833),
    CERTIFICATE_FILE_NOT_FOUND(817),
    RUN_VM_FAILED(818),
    // CBC
    VDS_REGISTER_ERROR_UPDATING_HOST(819),
    VDS_REGISTER_ERROR_UPDATING_HOST_ALL_TAKEN(820),
    VDS_REGISTER_HOST_IS_ACTIVE(821),
    VDS_REGISTER_ERROR_UPDATING_NAME(822),
    VDS_REGISTER_ERROR_UPDATING_NAMES_ALL_TAKEN(823),
    VDS_REGISTER_NAME_IS_ACTIVE(824),
    VDS_REGISTER_AUTO_APPROVE_PATTERN(825),
    VDS_REGISTER_FAILED(826),
    VDS_REGISTER_EXISTING_VDS_UPDATE_FAILED(827),
    VDS_REGISTER_SUCCEEDED(828),
    VM_MIGRATION_ON_CONNECT_CHECK_FAILED(829),
    VM_MIGRATION_ON_CONNECT_CHECK_SUCCEEDED(830),
    USER_DEDICATE_VM_TO_POWERCLIENT(831),
    USER_DEDICATE_VM_TO_POWERCLIENT_FAILED(832),

    // Network
    NETWORK_ATTACH_NETWORK_TO_VDS(920),
    NETWORK_ATTACH_NETWORK_TO_VDS_FAILED(921),
    NETWORK_DETACH_NETWORK_FROM_VDS(922),
    NETWORK_DETACH_NETWORK_FROM_VDS_FAILED(923),
    NETWORK_ADD_BOND(924),
    NETWORK_ADD_BOND_FAILED(925),
    NETWORK_REMOVE_BOND(926),
    NETWORK_REMOVE_BOND_FAILED(927),
    NETWORK_VDS_NETWORK_MATCH_CLUSTER(928),
    NETWORK_VDS_NETWORK_NOT_MATCH_CLUSTER(929),
    NETWORK_REMOVE_VM_INTERFACE(930),
    NETWORK_REMOVE_VM_INTERFACE_FAILED(931),
    NETWORK_ADD_VM_INTERFACE(932),
    NETWORK_ADD_VM_INTERFACE_FAILED(933),
    NETWORK_UPDATE_VM_INTERFACE(934),
    NETWORK_UPDATE_VM_INTERFACE_FAILED(935),
    NETWORK_ADD_TEMPLATE_INTERFACE(936),
    NETWORK_ADD_TEMPLATE_INTERFACE_FAILED(937),
    NETWORK_REMOVE_TEMPLATE_INTERFACE(938),
    NETWORK_REMOVE_TEMPLATE_INTERFACE_FAILED(939),
    NETWORK_UPDATE_TEMPLATE_INTERFACE(940),
    NETWORK_UPDATE_TEMPLATE_INTERFACE_FAILED(941),
    NETWORK_ADD_NETWORK(942),
    NETWORK_ADD_NETWORK_FAILED(943),
    NETWORK_REMOVE_NETWORK(944),
    NETWORK_REMOVE_NETWORK_FAILED(945),
    NETWORK_ATTACH_NETWORK_TO_VDS_GROUP(946),
    NETWORK_ATTACH_NETWORK_TO_VDS_GROUP_FAILED(947),
    NETWORK_DETACH_NETWORK_TO_VDS_GROUP(948),
    NETWORK_DETACH_NETWORK_TO_VDS_GROUP_FAILED(949),
    NETWORK_UPDATE_DISPLAY_TO_VDS_GROUP(1100),
    NETWORK_UPDATE_DISPLAY_TO_VDS_GROUP_FAILED(1101),
    NETWORK_UPDATE_NETWORK_TO_VDS_INTERFACE(1102),
    NETWORK_UPDATE_NETWORK_TO_VDS_INTERFACE_FAILED(1103),
    NETWORK_COMMINT_NETWORK_CHANGES(1104),
    NETWORK_COMMINT_NETWORK_CHANGES_FAILED(1105),
    NETWORK_HOST_USING_WRONG_CLUSER_VLAN(1106),
    NETWORK_HOST_MISSING_CLUSER_VLAN(1107),

    // Import/Export
    IMPORTEXPORT_STARTING_EXPORT_VM(1162),
    IMPORTEXPORT_EXPORT_VM(1150),
    IMPORTEXPORT_EXPORT_VM_FAILED(1151),
    IMPORTEXPORT_STARTING_IMPORT_VM(1165),
    IMPORTEXPORT_IMPORT_VM(1152),
    IMPORTEXPORT_IMPORT_VM_FAILED(1153),
    IMPORTEXPORT_STARTING_REMOVE_TEMPLATE(1166),
    IMPORTEXPORT_REMOVE_TEMPLATE(1154),
    IMPORTEXPORT_REMOVE_TEMPLATE_FAILED(1155),
    IMPORTEXPORT_EXPORT_TEMPLATE(1156),
    IMPORTEXPORT_STARTING_EXPORT_TEMPLATE(1164),
    IMPORTEXPORT_EXPORT_TEMPLATE_FAILED(1157),
    IMPORTEXPORT_STARTING_IMPORT_TEMPLATE(1163),
    IMPORTEXPORT_IMPORT_TEMPLATE(1158),
    IMPORTEXPORT_IMPORT_TEMPLATE_FAILED(1159),
    IMPORTEXPORT_STARTING_REMOVE_VM(1167),
    IMPORTEXPORT_REMOVE_VM(1160),
    IMPORTEXPORT_REMOVE_VM_FAILED(1161),
    IMPORTEXPORT_FAILED_TO_IMPORT_VM(1168),
    IMPORTEXPORT_FAILED_TO_IMPORT_TEMPLATE(1169),

    USER_ADD_PERMISSION(850),
    USER_ADD_PERMISSION_FAILED(851),
    USER_REMOVE_PERMISSION(852),
    USER_REMOVE_PERMISSION_FAILED(853),
    USER_ADD_ROLE(854),
    USER_ADD_ROLE_FAILED(855),
    USER_UPDATE_ROLE(856),
    USER_UPDATE_ROLE_FAILED(857),
    USER_REMOVE_ROLE(858),
    USER_REMOVE_ROLE_FAILED(859),
    USER_ATTACHED_ACTION_GROUP_TO_ROLE(860),
    USER_ATTACHED_ACTION_GROUP_TO_ROLE_FAILED(861),
    USER_DETACHED_ACTION_GROUP_FROM_ROLE(862),
    USER_DETACHED_ACTION_GROUP_FROM_ROLE_FAILED(863),
    USER_ADD_ROLE_WITH_ACTION_GROUP(864),
    USER_ADD_ROLE_WITH_ACTION_GROUP_FAILED(865),

    // AD Computer Account
    AD_COMPUTER_ACCOUNT_SUCCEEDED(900),
    AD_COMPUTER_ACCOUNT_FAILED(901),
    USER_ADD_STORAGE_POOL(950),
    USER_ADD_STORAGE_POOL_FAILED(951),
    USER_UPDATE_STORAGE_POOL(952),
    USER_UPDATE_STORAGE_POOL_FAILED(953),
    USER_REMOVE_STORAGE_POOL(954),
    USER_REMOVE_STORAGE_POOL_FAILED(955),
    USER_ADD_STORAGE_DOMAIN(956),
    USER_ADD_STORAGE_DOMAIN_FAILED(957),
    USER_UPDATE_STORAGE_DOMAIN(958),
    USER_UPDATE_STORAGE_DOMAIN_FAILED(959),
    USER_REMOVE_STORAGE_DOMAIN(960),
    USER_REMOVE_STORAGE_DOMAIN_FAILED(961),
    USER_ATTACH_STORAGE_DOMAIN_TO_POOL(962),
    USER_ATTACH_STORAGE_DOMAIN_TO_POOL_FAILED(963),
    USER_DETACH_STORAGE_DOMAIN_FROM_POOL(964),
    USER_DETACH_STORAGE_DOMAIN_FROM_POOL_FAILED(965),
    USER_ACTIVATED_STORAGE_DOMAIN(966),
    USER_ACTIVATE_STORAGE_DOMAIN_FAILED(967),
    USER_DEACTIVATED_STORAGE_DOMAIN(968),
    USER_DEACTIVATE_STORAGE_DOMAIN_FAILED(969),
    SYSTEM_DEACTIVATED_STORAGE_DOMAIN(970, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_DEACTIVATE_STORAGE_DOMAIN_FAILED(971, AuditLogTimeInterval.MINUTE.getValue()),
    USER_EXTENDED_STORAGE_DOMAIN(972),
    USER_EXTENDED_STORAGE_DOMAIN_FAILED(973),
    USER_REMOVE_VG(974),
    USER_REMOVE_VG_FAILED(975),
    USER_ACTIVATE_STORAGE_POOL(976),
    USER_ACTIVATE_STORAGE_POOL_FAILED(977),
    SYSTEM_FAILED_CHANGE_STORAGE_POOL_STATUS(978, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_NO_HOST_FOR_SPM(979, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC(980, AuditLogTimeInterval.MINUTE.getValue()),

    USER_FORCE_REMOVE_STORAGE_DOMAIN(981),
    USER_FORCE_REMOVE_STORAGE_DOMAIN_FAILED(982),
    RECONSTRUCT_MASTER_FAILED_NO_MASTER(983, AuditLogTimeInterval.HOUR.getValue()),
    RECONSTRUCT_MASTER_DONE(984),
    RECONSTRUCT_MASTER_FAILED(985, AuditLogTimeInterval.HOUR.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_SEARCHING_NEW_SPM(986, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_WITH_ERROR(987, AuditLogTimeInterval.MINUTE.getValue()),
    USER_CONNECT_HOSTS_TO_LUN_FAILED(988),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_PROBLEMATIC_FROM_NON_OPERATIONAL(989, AuditLogTimeInterval.MINUTE.getValue()),
    SYSTEM_MASTER_DOMAIN_NOT_IN_SYNC(990, AuditLogTimeInterval.MINUTE.getValue()),
    RECOVERY_STORAGE_POOL(991),
    RECOVERY_STORAGE_POOL_FAILED(992),
    SYSTEM_CHANGE_STORAGE_POOL_STATUS_RESET_IRS(993, AuditLogTimeInterval.MINUTE.getValue()),
    CONNECT_STORAGE_SERVERS_FAILED(994),
    CONNECT_STORAGE_POOL_FAILED(995),
    STORAGE_DOMAIN_ERROR(996),
    REFRESH_REPOSITORY_FILE_LIST_FAILED(997),
    REFRESH_REPOSITORY_FILE_LIST_SUCCEEDED(998),
    STORAGE_ALERT_VG_METADATA_CRITICALLY_FULL(999, AuditLogTimeInterval.MINUTE.getValue() * 10),
    STORAGE_ALERT_SMALL_VG_METADATA(1000, AuditLogTimeInterval.MINUTE.getValue() * 10),

    VDS_ALERT_FENCING_IS_NOT_CONFIGURED(9000),
    VDS_ALERT_FENCING_TEST_FAILED(9001),
    VDS_ALERT_FENCING_OPERATION_FAILED(9002),
    VDS_ALERT_FENCING_OPERATION_SKIPPED(9003),
    VDS_ALERT_FENCING_NO_PROXY_HOST(9004),
    VDS_ALERT_FENCING_STATUS_VERIFICATION_FAILED(9005),
    CANNOT_HIBERNATE_RUNNING_VMS_AFTER_CLUSTER_CPU_UPGRADE(9006),

    TASK_STOPPING_ASYNC_TASK(9500, AuditLogTimeInterval.MINUTE.getValue()),
    TASK_CLEARING_ASYNC_TASK(9501, AuditLogTimeInterval.MINUTE.getValue());

    private int intValue;
    // indicates time interval in seconds on which identical events from same instance are supressed.
    private int duplicateEventsIntervalValue;
    private static java.util.HashMap<Integer, AuditLogType> mappings = new HashMap<Integer, AuditLogType>();

    static {
        for (AuditLogType logType : values()) {
            mappings.put(logType.getValue(), logType);
        }
    }

    private AuditLogType(int value) {
        this(value, 0);
    }

    private AuditLogType(int value, int duplicateEventsInterval) {
        intValue = value;
        duplicateEventsIntervalValue = duplicateEventsInterval;
    }

    public int getValue() {
        return intValue;
    }

    public int getDuplicateEventsIntervalValue() {
        return duplicateEventsIntervalValue;
    }

    public static AuditLogType forValue(int value) {
        return mappings.get(value);
    }

}
